/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.logcache.v1;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.cloudfoundry.logcache.v1.InfoRequest;
import org.cloudfoundry.logcache.v1.InfoResponse;
import org.cloudfoundry.logcache.v1.LogCacheClient;
import org.cloudfoundry.logcache.v1.MetaRequest;
import org.cloudfoundry.logcache.v1.MetaResponse;
import org.cloudfoundry.logcache.v1.ReadRequest;
import org.cloudfoundry.logcache.v1.ReadResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.logcache.v1.ReactorLogCacheEndpoints;
import org.immutables.value.Value;
import reactor.core.publisher.Mono;

@Value.Immutable
abstract class _ReactorLogCacheClient
implements LogCacheClient {
    _ReactorLogCacheClient() {
    }

    public Mono<InfoResponse> info(InfoRequest request) {
        return this.getReactorLogCacheEndpoints().info(request);
    }

    public Mono<MetaResponse> meta(MetaRequest request) {
        return this.getReactorLogCacheEndpoints().meta(request);
    }

    public Mono<ReadResponse> read(ReadRequest request) {
        return this.getReactorLogCacheEndpoints().read(request);
    }

    abstract ConnectionContext getConnectionContext();

    @Value.Derived
    ReactorLogCacheEndpoints getReactorLogCacheEndpoints() {
        return new ReactorLogCacheEndpoints(this.getConnectionContext(), this.getRoot(), this.getTokenProvider(), this.getRequestTags());
    }

    @Value.Default
    Map<String, String> getRequestTags() {
        return Collections.emptyMap();
    }

    @Value.Default
    Mono<String> getRoot() {
        Mono cached = this.getConnectionContext().getRootProvider().getRoot("log-cache", this.getConnectionContext()).onErrorResume(IllegalArgumentException.class, e -> this.deriveLogCacheUrl());
        return this.getConnectionContext().getCacheDuration().map(arg_0 -> ((Mono)cached).cache(arg_0)).orElseGet(() -> ((Mono)cached).cache());
    }

    abstract TokenProvider getTokenProvider();

    private Mono<String> deriveLogCacheUrl() {
        return this.getConnectionContext().getRootProvider().getRoot(this.getConnectionContext()).map(root -> root.replace("api", "log-cache")).map(URI::create).delayUntil(uri -> this.getConnectionContext().trust(uri.getHost(), uri.getPort())).map(URI::toString);
    }
}

