/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.processes;

import org.cloudfoundry.client.v3.processes.GetProcessRequest;
import org.cloudfoundry.client.v3.processes.GetProcessResponse;
import org.cloudfoundry.client.v3.processes.GetProcessStatisticsRequest;
import org.cloudfoundry.client.v3.processes.GetProcessStatisticsResponse;
import org.cloudfoundry.client.v3.processes.ListProcessesRequest;
import org.cloudfoundry.client.v3.processes.ListProcessesResponse;
import org.cloudfoundry.client.v3.processes.Processes;
import org.cloudfoundry.client.v3.processes.ScaleProcessRequest;
import org.cloudfoundry.client.v3.processes.ScaleProcessResponse;
import org.cloudfoundry.client.v3.processes.TerminateProcessInstanceRequest;
import org.cloudfoundry.client.v3.processes.UpdateProcessRequest;
import org.cloudfoundry.client.v3.processes.UpdateProcessResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorProcesses
extends AbstractClientV3Operations
implements Processes {
    public ReactorProcesses(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    public Mono<GetProcessResponse> get(GetProcessRequest request) {
        return this.get((Object)request, GetProcessResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"processes", request.getProcessId()})).checkpoint();
    }

    public Mono<GetProcessStatisticsResponse> getStatistics(GetProcessStatisticsRequest request) {
        return this.get((Object)request, GetProcessStatisticsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"processes", request.getProcessId(), "stats"})).checkpoint();
    }

    public Mono<ListProcessesResponse> list(ListProcessesRequest request) {
        return this.get((Object)request, ListProcessesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"processes"})).checkpoint();
    }

    public Mono<ScaleProcessResponse> scale(ScaleProcessRequest request) {
        return this.post(request, ScaleProcessResponse.class, builder -> builder.pathSegment(new String[]{"processes", request.getProcessId(), "actions", "scale"})).checkpoint();
    }

    public Mono<Void> terminateInstance(TerminateProcessInstanceRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"processes", request.getProcessId(), "instances", request.getIndex()})).checkpoint();
    }

    public Mono<UpdateProcessResponse> update(UpdateProcessRequest request) {
        return this.patch(request, UpdateProcessResponse.class, builder -> builder.pathSegment(new String[]{"processes", request.getProcessId()})).checkpoint();
    }
}

