/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.buildpacks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.cloudfoundry.client.v2.buildpacks.Buildpacks;
import org.cloudfoundry.client.v2.buildpacks.CreateBuildpackRequest;
import org.cloudfoundry.client.v2.buildpacks.CreateBuildpackResponse;
import org.cloudfoundry.client.v2.buildpacks.DeleteBuildpackRequest;
import org.cloudfoundry.client.v2.buildpacks.DeleteBuildpackResponse;
import org.cloudfoundry.client.v2.buildpacks.GetBuildpackRequest;
import org.cloudfoundry.client.v2.buildpacks.GetBuildpackResponse;
import org.cloudfoundry.client.v2.buildpacks.ListBuildpacksRequest;
import org.cloudfoundry.client.v2.buildpacks.ListBuildpacksResponse;
import org.cloudfoundry.client.v2.buildpacks.UpdateBuildpackRequest;
import org.cloudfoundry.client.v2.buildpacks.UpdateBuildpackResponse;
import org.cloudfoundry.client.v2.buildpacks.UploadBuildpackRequest;
import org.cloudfoundry.client.v2.buildpacks.UploadBuildpackResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.cloudfoundry.reactor.util.MultipartHttpClientRequest;
import org.cloudfoundry.util.FileUtils;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public final class ReactorBuildpacks
extends AbstractClientV2Operations
implements Buildpacks {
    public ReactorBuildpacks(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    public Mono<CreateBuildpackResponse> create(CreateBuildpackRequest request) {
        return this.post(request, CreateBuildpackResponse.class, builder -> builder.pathSegment(new String[]{"buildpacks"})).checkpoint();
    }

    public Mono<DeleteBuildpackResponse> delete(DeleteBuildpackRequest request) {
        return this.delete(request, DeleteBuildpackResponse.class, builder -> builder.pathSegment(new String[]{"buildpacks", request.getBuildpackId()})).checkpoint();
    }

    public Mono<GetBuildpackResponse> get(GetBuildpackRequest request) {
        return this.get((Object)request, GetBuildpackResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"buildpacks", request.getBuildpackId()})).checkpoint();
    }

    public Mono<ListBuildpacksResponse> list(ListBuildpacksRequest request) {
        return this.get((Object)request, ListBuildpacksResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"buildpacks"})).checkpoint();
    }

    public Mono<UpdateBuildpackResponse> update(UpdateBuildpackRequest request) {
        return this.put(request, UpdateBuildpackResponse.class, builder -> builder.pathSegment(new String[]{"buildpacks", request.getBuildpackId()})).checkpoint();
    }

    public Mono<UploadBuildpackResponse> upload(UploadBuildpackRequest request) {
        Path buildpack = request.getBuildpack();
        if (buildpack.toFile().isDirectory()) {
            return FileUtils.compress((Path)buildpack).map(temporaryFile -> UploadBuildpackRequest.builder().from(request).buildpack(temporaryFile).build()).flatMap(requestWithTemporaryFile -> this.upload((UploadBuildpackRequest)requestWithTemporaryFile, request.getFilename() + ".zip", () -> {
                try {
                    Files.delete(requestWithTemporaryFile.getBuildpack());
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }));
        }
        return this.upload(request, request.getFilename(), () -> {});
    }

    private Mono<UploadBuildpackResponse> upload(UploadBuildpackRequest request, String filename, Runnable onTerminate) {
        return this.put(request, UploadBuildpackResponse.class, builder -> builder.pathSegment(new String[]{"buildpacks", request.getBuildpackId(), "bits"}), multipartRequest -> this.upload(request.getBuildpack(), (MultipartHttpClientRequest)multipartRequest, filename), onTerminate).checkpoint();
    }

    private void upload(Path buildpack, MultipartHttpClientRequest multipartRequest, String filename) {
        multipartRequest.addPart(part -> part.setName("buildpack").setFilename(filename).setContentType("application/zip").sendFile(buildpack)).done();
    }
}

