/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.QueryBuilder;
import org.cloudfoundry.reactor.client.v2.FilterBuilder;
import org.cloudfoundry.reactor.util.AbstractReactorOperations;
import org.cloudfoundry.reactor.util.ErrorPayloadMappers;
import org.cloudfoundry.reactor.util.MultipartHttpClientRequest;
import org.cloudfoundry.reactor.util.Operator;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClientForm;
import reactor.netty.http.client.HttpClientRequest;

public abstract class AbstractClientV2Operations
extends AbstractReactorOperations {
    protected AbstractClientV2Operations(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    @Override
    protected Mono<Operator> createOperator() {
        return super.createOperator().map(this::attachErrorPayloadMapper);
    }

    protected final <T> Mono<T> delete(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.delete().uri(AbstractClientV2Operations.queryTransformer(requestPayload).andThen(uriTransformer)).send(requestPayload).response().parseBody(responseType));
    }

    protected final <T> Flux<T> get(Object requestPayload, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<ByteBufFlux, Flux<T>> bodyTransformer) {
        return this.createOperator().flatMapMany(operator -> operator.followRedirects().get().uri(AbstractClientV2Operations.queryTransformer(requestPayload).andThen(uriTransformer)).response().parseBodyToFlux(responseWithBody -> (Flux)bodyTransformer.apply(responseWithBody.getBody())));
    }

    protected final <T> Mono<T> get(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.get().uri(AbstractClientV2Operations.queryTransformer(requestPayload).andThen(uriTransformer)).response().parseBody(responseType));
    }

    protected final <T> Mono<T> post(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.post().uri(AbstractClientV2Operations.queryTransformer(requestPayload).andThen(uriTransformer)).send(requestPayload).response().parseBody(responseType));
    }

    protected final <T> Mono<T> put(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Consumer<MultipartHttpClientRequest> requestTransformer, Runnable onTerminate) {
        return this.createOperator().flatMap(operator -> operator.put().uri(AbstractClientV2Operations.queryTransformer(requestPayload).andThen(uriTransformer)).sendForm(this.multipartRequest(requestTransformer)).response().parseBody(responseType)).doFinally(signalType -> onTerminate.run());
    }

    protected final <T> Mono<T> put(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.put().uri(AbstractClientV2Operations.queryTransformer(requestPayload).andThen(uriTransformer)).send(requestPayload).response().parseBody(responseType));
    }

    private static Function<UriComponentsBuilder, UriComponentsBuilder> queryTransformer(Object requestPayload) {
        return builder -> {
            FilterBuilder.augment(builder, requestPayload);
            QueryBuilder.augment(builder, requestPayload);
            return builder;
        };
    }

    private Operator attachErrorPayloadMapper(Operator operator) {
        return operator.withErrorPayloadMapper(ErrorPayloadMappers.clientV2(this.connectionContext.getObjectMapper()));
    }

    private MultipartHttpClientRequest createMultipartRequest(HttpClientRequest request, HttpClientForm form) {
        return new MultipartHttpClientRequest(this.connectionContext.getObjectMapper(), request, form);
    }

    private BiConsumer<HttpClientRequest, HttpClientForm> multipartRequest(Consumer<MultipartHttpClientRequest> requestTransformer) {
        return (request, form) -> {
            MultipartHttpClientRequest multipartRequest = this.createMultipartRequest((HttpClientRequest)request, (HttpClientForm)form);
            requestTransformer.accept(multipartRequest);
        };
    }
}

