/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.reactor.client.MethodNameComparator;
import org.cloudfoundry.reactor.util.AnnotationUtils;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.Exceptions;

public final class QueryBuilder {
    private QueryBuilder() {
    }

    public static void augment(UriComponentsBuilder builder, Object instance) {
        Arrays.stream(instance.getClass().getMethods()).sorted(MethodNameComparator.INSTANCE).forEach(QueryBuilder.processMethod(builder, instance));
    }

    private static Optional<Object> getValue(Method method, Object instance) {
        try {
            return Optional.ofNullable(method.invoke(instance, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static Consumer<QueryParameter> processAnnotation(UriComponentsBuilder builder, Method method, Object instance) {
        return queryParameter -> QueryBuilder.getValue(method, instance).ifPresent(QueryBuilder.processValue(builder, queryParameter));
    }

    private static void processCollection(UriComponentsBuilder builder, QueryParameter queryParameter, Object value) {
        QueryBuilder.processValue(builder, queryParameter.value(), ((Collection)value).stream().map(o -> o.toString().trim()).collect(Collectors.joining(queryParameter.delimiter())));
    }

    private static Consumer<Method> processMethod(UriComponentsBuilder builder, Object instance) {
        return method -> AnnotationUtils.findAnnotation(method, QueryParameter.class).ifPresent(QueryBuilder.processAnnotation(builder, method, instance));
    }

    private static void processValue(UriComponentsBuilder builder, String name, String value) {
        builder.queryParam(name, new Object[]{value});
    }

    private static Consumer<Object> processValue(UriComponentsBuilder builder, QueryParameter queryParameter) {
        return value -> {
            if (value instanceof Collection) {
                QueryBuilder.processCollection(builder, queryParameter, value);
            } else {
                QueryBuilder.processValue(builder, queryParameter.value(), value.toString());
            }
        };
    }
}

