package org.cloudfoundry.reactor.routing;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.routing.v1.routergroups.RouterGroups;
import org.cloudfoundry.routing.v1.tcproutes.TcpRoutes;
import org.immutables.value.Generated;
import reactor.core.publisher.Mono;

/**
 * The Reactor-based implementation of {@link RoutingClient}
 */
@Generated(from = "_ReactorRoutingClient", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ReactorRoutingClient extends org.cloudfoundry.reactor.routing._ReactorRoutingClient {
  private transient final RouterGroups routerGroups;
  private transient final TcpRoutes tcpRoutes;
  private final ConnectionContext connectionContext;
  private final Mono<String> root;
  private final TokenProvider tokenProvider;

  private ReactorRoutingClient(ReactorRoutingClient.Builder builder) {
    this.connectionContext = builder.connectionContext;
    this.tokenProvider = builder.tokenProvider;
    if (builder.root != null) {
      initShim.root(builder.root);
    }
    this.routerGroups = initShim.routerGroups();
    this.tcpRoutes = initShim.tcpRoutes();
    this.root = initShim.getRoot();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "_ReactorRoutingClient", generator = "Immutables")
  private final class InitShim {
    private byte routerGroupsBuildStage = STAGE_UNINITIALIZED;
    private RouterGroups routerGroups;

    RouterGroups routerGroups() {
      if (routerGroupsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (routerGroupsBuildStage == STAGE_UNINITIALIZED) {
        routerGroupsBuildStage = STAGE_INITIALIZING;
        this.routerGroups = Objects.requireNonNull(ReactorRoutingClient.super.routerGroups(), "routerGroups");
        routerGroupsBuildStage = STAGE_INITIALIZED;
      }
      return this.routerGroups;
    }

    private byte tcpRoutesBuildStage = STAGE_UNINITIALIZED;
    private TcpRoutes tcpRoutes;

    TcpRoutes tcpRoutes() {
      if (tcpRoutesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (tcpRoutesBuildStage == STAGE_UNINITIALIZED) {
        tcpRoutesBuildStage = STAGE_INITIALIZING;
        this.tcpRoutes = Objects.requireNonNull(ReactorRoutingClient.super.tcpRoutes(), "tcpRoutes");
        tcpRoutesBuildStage = STAGE_INITIALIZED;
      }
      return this.tcpRoutes;
    }

    private byte rootBuildStage = STAGE_UNINITIALIZED;
    private Mono<String> root;

    Mono<String> getRoot() {
      if (rootBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rootBuildStage == STAGE_UNINITIALIZED) {
        rootBuildStage = STAGE_INITIALIZING;
        this.root = Objects.requireNonNull(ReactorRoutingClient.super.getRoot(), "root");
        rootBuildStage = STAGE_INITIALIZED;
      }
      return this.root;
    }

    void root(Mono<String> root) {
      this.root = root;
      rootBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (routerGroupsBuildStage == STAGE_INITIALIZING) attributes.add("routerGroups");
      if (tcpRoutesBuildStage == STAGE_INITIALIZING) attributes.add("tcpRoutes");
      if (rootBuildStage == STAGE_INITIALIZING) attributes.add("root");
      return "Cannot build ReactorRoutingClient, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The computed-at-construction value of the {@code routerGroups} attribute
   */
  @Override
  public RouterGroups routerGroups() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.routerGroups()
        : this.routerGroups;
  }

  /**
   * @return The computed-at-construction value of the {@code tcpRoutes} attribute
   */
  @Override
  public TcpRoutes tcpRoutes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.tcpRoutes()
        : this.tcpRoutes;
  }

  /**
   * The connection context
   */
  @Override
  public ConnectionContext getConnectionContext() {
    return connectionContext;
  }

  /**
   * @return The value of the {@code root} attribute
   */
  @Override
  public Mono<String> getRoot() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRoot()
        : this.root;
  }

  /**
   * The token provider
   */
  @Override
  public TokenProvider getTokenProvider() {
    return tokenProvider;
  }

  /**
   * This instance is equal to all instances of {@code ReactorRoutingClient} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ReactorRoutingClient
        && equalTo((ReactorRoutingClient) another);
  }

  private boolean equalTo(ReactorRoutingClient another) {
    return routerGroups.equals(another.routerGroups)
        && tcpRoutes.equals(another.tcpRoutes)
        && connectionContext.equals(another.connectionContext)
        && root.equals(another.root)
        && tokenProvider.equals(another.tokenProvider);
  }

  /**
   * Computes a hash code from attributes: {@code routerGroups}, {@code tcpRoutes}, {@code connectionContext}, {@code root}, {@code tokenProvider}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + routerGroups.hashCode();
    h += (h << 5) + tcpRoutes.hashCode();
    h += (h << 5) + connectionContext.hashCode();
    h += (h << 5) + root.hashCode();
    h += (h << 5) + tokenProvider.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ReactorRoutingClient} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReactorRoutingClient{"
        + "routerGroups=" + routerGroups
        + ", tcpRoutes=" + tcpRoutes
        + ", connectionContext=" + connectionContext
        + ", root=" + root
        + ", tokenProvider=" + tokenProvider
        + "}";
  }

  /**
   * Creates a builder for {@link ReactorRoutingClient ReactorRoutingClient}.
   * <pre>
   * ReactorRoutingClient.builder()
   *    .connectionContext(org.cloudfoundry.reactor.ConnectionContext) // required {@link ReactorRoutingClient#getConnectionContext() connectionContext}
   *    .root(reactor.core.publisher.Mono&lt;String&gt;) // optional {@link ReactorRoutingClient#getRoot() root}
   *    .tokenProvider(org.cloudfoundry.reactor.TokenProvider) // required {@link ReactorRoutingClient#getTokenProvider() tokenProvider}
   *    .build();
   * </pre>
   * @return A new ReactorRoutingClient builder
   */
  public static ReactorRoutingClient.Builder builder() {
    return new ReactorRoutingClient.Builder();
  }

  /**
   * Builds instances of type {@link ReactorRoutingClient ReactorRoutingClient}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ReactorRoutingClient", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CONNECTION_CONTEXT = 0x1L;
    private static final long INIT_BIT_TOKEN_PROVIDER = 0x2L;
    private long initBits = 0x3L;

    private ConnectionContext connectionContext;
    private Mono<String> root;
    private TokenProvider tokenProvider;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReactorRoutingClient} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReactorRoutingClient instance) {
      return from((_ReactorRoutingClient) instance);
    }

    /**
     * Copy abstract value type {@code _ReactorRoutingClient} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ReactorRoutingClient instance) {
      Objects.requireNonNull(instance, "instance");
      connectionContext(instance.getConnectionContext());
      root(instance.getRoot());
      tokenProvider(instance.getTokenProvider());
      return this;
    }

    /**
     * Initializes the value for the {@link ReactorRoutingClient#getConnectionContext() connectionContext} attribute.
     * @param connectionContext The value for connectionContext 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectionContext(ConnectionContext connectionContext) {
      this.connectionContext = Objects.requireNonNull(connectionContext, "connectionContext");
      initBits &= ~INIT_BIT_CONNECTION_CONTEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link ReactorRoutingClient#getRoot() root} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ReactorRoutingClient#getRoot() root}.</em>
     * @param root The value for root 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder root(Mono<String> root) {
      this.root = Objects.requireNonNull(root, "root");
      return this;
    }

    /**
     * Initializes the value for the {@link ReactorRoutingClient#getTokenProvider() tokenProvider} attribute.
     * @param tokenProvider The value for tokenProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenProvider(TokenProvider tokenProvider) {
      this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider");
      initBits &= ~INIT_BIT_TOKEN_PROVIDER;
      return this;
    }

    /**
     * Builds a new {@link ReactorRoutingClient ReactorRoutingClient}.
     * @return An immutable instance of ReactorRoutingClient
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ReactorRoutingClient build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ReactorRoutingClient(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONNECTION_CONTEXT) != 0) attributes.add("connectionContext");
      if ((initBits & INIT_BIT_TOKEN_PROVIDER) != 0) attributes.add("tokenProvider");
      return "Cannot build ReactorRoutingClient, some of required attributes are not set " + attributes;
    }
  }
}
