/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.cloudfoundry.util.TimeUtils;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClientResponse;

public final class NetworkLogging {
    static final Logger REQUEST_LOGGER = LoggerFactory.getLogger((String)"cloudfoundry-client.request");
    static final Logger RESPONSE_LOGGER = LoggerFactory.getLogger((String)"cloudfoundry-client.response");
    private static final String CF_WARNINGS = "X-Cf-Warnings";

    private NetworkLogging() {
    }

    public static Consumer<Subscription> delete(String uri) {
        return s -> REQUEST_LOGGER.debug("DELETE {}", (Object)uri);
    }

    public static Consumer<Subscription> get(String uri) {
        return s -> REQUEST_LOGGER.debug("GET    {}", (Object)uri);
    }

    public static Consumer<Subscription> patch(String uri) {
        return s -> REQUEST_LOGGER.debug("PATCH  {}", (Object)uri);
    }

    public static Consumer<Subscription> post(String uri) {
        return s -> REQUEST_LOGGER.debug("POST   {}", (Object)uri);
    }

    public static Consumer<Subscription> put(String uri) {
        return s -> REQUEST_LOGGER.debug("PUT    {}", (Object)uri);
    }

    public static Function<Mono<HttpClientResponse>, Mono<HttpClientResponse>> response(String uri) {
        if (!RESPONSE_LOGGER.isDebugEnabled()) {
            return inbound -> inbound;
        }
        AtomicLong startTimeHolder = new AtomicLong();
        AtomicReference responseHolder = new AtomicReference();
        return inbound -> inbound.doOnSubscribe(s -> startTimeHolder.set(System.currentTimeMillis())).doOnNext(responseHolder::set).doFinally(signalType -> {
            String elapsed = TimeUtils.asTime((long)(System.currentTimeMillis() - startTimeHolder.get()));
            Optional.ofNullable(responseHolder.get()).ifPresent(response -> {
                List warnings = response.responseHeaders().getAll(CF_WARNINGS);
                if (warnings.isEmpty()) {
                    RESPONSE_LOGGER.debug("{}    {} ({})", new Object[]{response.status().code(), uri, elapsed});
                } else {
                    RESPONSE_LOGGER.warn("{}    {} ({}) [{}]", new Object[]{response.status().code(), uri, elapsed, warnings.stream().collect(Collectors.joining(", "))});
                }
            });
        });
    }

    public static Consumer<Subscription> ws(String uri) {
        return s -> REQUEST_LOGGER.debug("WS     {}", (Object)uri);
    }
}

