/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.applications;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.cloudfoundry.client.v2.applications.ApplicationEnvironmentRequest;
import org.cloudfoundry.client.v2.applications.ApplicationEnvironmentResponse;
import org.cloudfoundry.client.v2.applications.ApplicationInstancesRequest;
import org.cloudfoundry.client.v2.applications.ApplicationInstancesResponse;
import org.cloudfoundry.client.v2.applications.ApplicationStatisticsRequest;
import org.cloudfoundry.client.v2.applications.ApplicationStatisticsResponse;
import org.cloudfoundry.client.v2.applications.ApplicationsV2;
import org.cloudfoundry.client.v2.applications.AssociateApplicationRouteRequest;
import org.cloudfoundry.client.v2.applications.AssociateApplicationRouteResponse;
import org.cloudfoundry.client.v2.applications.CopyApplicationRequest;
import org.cloudfoundry.client.v2.applications.CopyApplicationResponse;
import org.cloudfoundry.client.v2.applications.CreateApplicationRequest;
import org.cloudfoundry.client.v2.applications.CreateApplicationResponse;
import org.cloudfoundry.client.v2.applications.DeleteApplicationRequest;
import org.cloudfoundry.client.v2.applications.DownloadApplicationDropletRequest;
import org.cloudfoundry.client.v2.applications.DownloadApplicationRequest;
import org.cloudfoundry.client.v2.applications.GetApplicationPermissionsRequest;
import org.cloudfoundry.client.v2.applications.GetApplicationPermissionsResponse;
import org.cloudfoundry.client.v2.applications.GetApplicationRequest;
import org.cloudfoundry.client.v2.applications.GetApplicationResponse;
import org.cloudfoundry.client.v2.applications.ListApplicationRoutesRequest;
import org.cloudfoundry.client.v2.applications.ListApplicationRoutesResponse;
import org.cloudfoundry.client.v2.applications.ListApplicationServiceBindingsRequest;
import org.cloudfoundry.client.v2.applications.ListApplicationServiceBindingsResponse;
import org.cloudfoundry.client.v2.applications.ListApplicationsRequest;
import org.cloudfoundry.client.v2.applications.ListApplicationsResponse;
import org.cloudfoundry.client.v2.applications.RemoveApplicationRouteRequest;
import org.cloudfoundry.client.v2.applications.RemoveApplicationServiceBindingRequest;
import org.cloudfoundry.client.v2.applications.RestageApplicationRequest;
import org.cloudfoundry.client.v2.applications.RestageApplicationResponse;
import org.cloudfoundry.client.v2.applications.SummaryApplicationRequest;
import org.cloudfoundry.client.v2.applications.SummaryApplicationResponse;
import org.cloudfoundry.client.v2.applications.TerminateApplicationInstanceRequest;
import org.cloudfoundry.client.v2.applications.UpdateApplicationRequest;
import org.cloudfoundry.client.v2.applications.UpdateApplicationResponse;
import org.cloudfoundry.client.v2.applications.UploadApplicationDropletRequest;
import org.cloudfoundry.client.v2.applications.UploadApplicationDropletResponse;
import org.cloudfoundry.client.v2.applications.UploadApplicationRequest;
import org.cloudfoundry.client.v2.applications.UploadApplicationResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.cloudfoundry.reactor.util.MultipartHttpClientRequest;
import org.cloudfoundry.util.FileUtils;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClientRequest;

public final class ReactorApplicationsV2
extends AbstractClientV2Operations
implements ApplicationsV2 {
    public ReactorApplicationsV2(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    public Mono<AssociateApplicationRouteResponse> associateRoute(AssociateApplicationRouteRequest request) {
        return this.put(request, AssociateApplicationRouteResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "routes", request.getRouteId()})).checkpoint();
    }

    public Mono<CopyApplicationResponse> copy(CopyApplicationRequest request) {
        return this.post(request, CopyApplicationResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "copy_bits"})).checkpoint();
    }

    public Mono<CreateApplicationResponse> create(CreateApplicationRequest request) {
        return this.post(request, CreateApplicationResponse.class, builder -> builder.pathSegment(new String[]{"apps"})).checkpoint();
    }

    public Mono<Void> delete(DeleteApplicationRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId()})).checkpoint();
    }

    public Flux<byte[]> download(DownloadApplicationRequest request) {
        return this.get((Object)request, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "download"}), (Mono<HttpClientRequest> outbound) -> outbound.map(HttpClientRequest::followRedirect)).flatMapMany(response -> response.receive().asByteArray()).checkpoint();
    }

    public Flux<byte[]> downloadDroplet(DownloadApplicationDropletRequest request) {
        return this.get((Object)request, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "droplet", "download"}), (Mono<HttpClientRequest> outbound) -> outbound.map(HttpClientRequest::followRedirect)).flatMapMany(response -> response.receive().asByteArray()).checkpoint();
    }

    public Mono<ApplicationEnvironmentResponse> environment(ApplicationEnvironmentRequest request) {
        return this.get((Object)request, ApplicationEnvironmentResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "env"})).checkpoint();
    }

    public Mono<GetApplicationResponse> get(GetApplicationRequest request) {
        return this.get((Object)request, GetApplicationResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"apps", request.getApplicationId()})).checkpoint();
    }

    public Mono<GetApplicationPermissionsResponse> getPermissions(GetApplicationPermissionsRequest request) {
        return this.get((Object)request, GetApplicationPermissionsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "permissions"})).checkpoint();
    }

    public Mono<ApplicationInstancesResponse> instances(ApplicationInstancesRequest request) {
        return this.get((Object)request, ApplicationInstancesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "instances"})).checkpoint();
    }

    public Mono<ListApplicationsResponse> list(ListApplicationsRequest request) {
        return this.get((Object)request, ListApplicationsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"apps"})).checkpoint();
    }

    public Mono<ListApplicationRoutesResponse> listRoutes(ListApplicationRoutesRequest request) {
        return this.get((Object)request, ListApplicationRoutesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "routes"})).checkpoint();
    }

    public Mono<ListApplicationServiceBindingsResponse> listServiceBindings(ListApplicationServiceBindingsRequest request) {
        return this.get((Object)request, ListApplicationServiceBindingsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "service_bindings"})).checkpoint();
    }

    public Mono<Void> removeRoute(RemoveApplicationRouteRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "routes", request.getRouteId()})).checkpoint();
    }

    public Mono<Void> removeServiceBinding(RemoveApplicationServiceBindingRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "service_bindings", request.getServiceBindingId()})).checkpoint();
    }

    public Mono<RestageApplicationResponse> restage(RestageApplicationRequest request) {
        return this.post(request, RestageApplicationResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "restage"})).checkpoint();
    }

    public Mono<ApplicationStatisticsResponse> statistics(ApplicationStatisticsRequest request) {
        return this.get((Object)request, ApplicationStatisticsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "stats"})).checkpoint();
    }

    public Mono<SummaryApplicationResponse> summary(SummaryApplicationRequest request) {
        return this.get((Object)request, SummaryApplicationResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "summary"})).checkpoint();
    }

    public Mono<Void> terminateInstance(TerminateApplicationInstanceRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "instances", request.getIndex()})).checkpoint();
    }

    public Mono<UpdateApplicationResponse> update(UpdateApplicationRequest request) {
        return this.put(request, UpdateApplicationResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId()})).checkpoint();
    }

    public Mono<UploadApplicationResponse> upload(UploadApplicationRequest request) {
        return this.put(request, UploadApplicationResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "bits"}), outbound -> outbound.flatMap(r -> {
            if (Files.isDirectory(request.getApplication(), new LinkOption[0])) {
                return FileUtils.compress((Path)request.getApplication()).flatMap(application -> this.upload((Path)application, (MultipartHttpClientRequest)r, request).doOnTerminate(() -> {
                    try {
                        Files.delete(application);
                    }
                    catch (IOException e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                }));
            }
            return this.upload(request.getApplication(), (MultipartHttpClientRequest)r, request);
        })).checkpoint();
    }

    public Mono<UploadApplicationDropletResponse> uploadDroplet(UploadApplicationDropletRequest request) {
        return this.put(request, UploadApplicationDropletResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "droplet", "upload"}), outbound -> outbound.flatMap(r -> this.upload((MultipartHttpClientRequest)r, request))).checkpoint();
    }

    private Mono<Void> upload(Path application, MultipartHttpClientRequest r, UploadApplicationRequest request) {
        return r.addPart(part -> part.setContentDispositionFormData("resources").setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)HttpHeaderValues.APPLICATION_JSON).send(request.getResources())).addPart(part -> part.setContentDispositionFormData("application", "application.zip").setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)APPLICATION_ZIP).sendFile(application)).done();
    }

    private Mono<Void> upload(MultipartHttpClientRequest r, UploadApplicationDropletRequest request) {
        return r.addPart(part -> part.setContentDispositionFormData("droplet", request.getDroplet().getFileName().toString()).sendFile(request.getDroplet())).done();
    }
}

