/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.tokenprovider;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.reactor.tokenprovider.AbstractUaaTokenProvider;
import org.cloudfoundry.reactor.tokenprovider._RefreshTokenGrantTokenProvider;
import org.immutables.value.Generated;

@Generated(from="_RefreshTokenGrantTokenProvider", generator="Immutables")
public final class RefreshTokenGrantTokenProvider
extends _RefreshTokenGrantTokenProvider {
    private final String token;
    private final String clientId;
    private final String clientSecret;
    @Nullable
    private final String identityZoneSubdomain;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private RefreshTokenGrantTokenProvider(Builder builder) {
        this.token = builder.token;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
        if (builder.clientId != null) {
            this.initShim.clientId(builder.clientId);
        }
        if (builder.clientSecret != null) {
            this.initShim.clientSecret(builder.clientSecret);
        }
        this.clientId = this.initShim.getClientId();
        this.clientSecret = this.initShim.getClientSecret();
        this.initShim = null;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getClientId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getClientId() : this.clientId;
    }

    @Override
    public String getClientSecret() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getClientSecret() : this.clientSecret;
    }

    @Override
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RefreshTokenGrantTokenProvider && this.equalTo((RefreshTokenGrantTokenProvider)another);
    }

    private boolean equalTo(RefreshTokenGrantTokenProvider another) {
        return this.token.equals(another.token) && this.clientId.equals(another.clientId) && this.clientSecret.equals(another.clientSecret) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + this.clientSecret.hashCode();
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        return h;
    }

    public String toString() {
        return "RefreshTokenGrantTokenProvider{token=" + this.token + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", identityZoneSubdomain=" + this.identityZoneSubdomain + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private long initBits = 1L;
        private String token;
        private String clientId;
        private String clientSecret;
        private String identityZoneSubdomain;

        private Builder() {
        }

        public final Builder from(AbstractUaaTokenProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RefreshTokenGrantTokenProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_RefreshTokenGrantTokenProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractUaaTokenProvider instance;
            if (object instanceof AbstractUaaTokenProvider) {
                instance = (AbstractUaaTokenProvider)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                this.clientSecret(instance.getClientSecret());
                this.clientId(instance.getClientId());
            }
            if (object instanceof _RefreshTokenGrantTokenProvider) {
                instance = (_RefreshTokenGrantTokenProvider)object;
                this.token(((_RefreshTokenGrantTokenProvider)instance).getToken());
            }
        }

        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            return this;
        }

        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public RefreshTokenGrantTokenProvider build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new RefreshTokenGrantTokenProvider(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            return "Cannot build RefreshTokenGrantTokenProvider, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte clientIdBuildStage = 0;
        private String clientId;
        private byte clientSecretBuildStage = 0;
        private String clientSecret;

        private InitShim() {
        }

        String getClientId() {
            if (this.clientIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clientIdBuildStage == 0) {
                this.clientIdBuildStage = (byte)-1;
                this.clientId = Objects.requireNonNull(RefreshTokenGrantTokenProvider.super.getClientId(), "clientId");
                this.clientIdBuildStage = 1;
            }
            return this.clientId;
        }

        void clientId(String clientId) {
            this.clientId = clientId;
            this.clientIdBuildStage = 1;
        }

        String getClientSecret() {
            if (this.clientSecretBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clientSecretBuildStage == 0) {
                this.clientSecretBuildStage = (byte)-1;
                this.clientSecret = Objects.requireNonNull(RefreshTokenGrantTokenProvider.super.getClientSecret(), "clientSecret");
                this.clientSecretBuildStage = 1;
            }
            return this.clientSecret;
        }

        void clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            this.clientSecretBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.clientIdBuildStage == -1) {
                attributes.add("clientId");
            }
            if (this.clientSecretBuildStage == -1) {
                attributes.add("clientSecret");
            }
            return "Cannot build RefreshTokenGrantTokenProvider, attribute initializers form cycle " + attributes;
        }
    }
}

