/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.cloudfoundry.reactor.AbstractRootProvider;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.util.JsonCodec;
import org.cloudfoundry.reactor.util.NetworkLogging;
import org.cloudfoundry.reactor.util.UserAgent;
import org.immutables.value.Value;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClientRequest;

@Value.Immutable
abstract class _InfoPayloadRootProvider
extends AbstractRootProvider {
    _InfoPayloadRootProvider() {
    }

    @Override
    protected Mono<UriComponents> doGetRoot(ConnectionContext connectionContext) {
        return Mono.just((Object)this.getRoot());
    }

    @Override
    protected Mono<UriComponents> doGetRoot(String key, ConnectionContext connectionContext) {
        return this.getInfo(connectionContext).map(info -> {
            if (!info.containsKey(key)) {
                throw new IllegalArgumentException(String.format("Info payload does not contain key '%s'", key));
            }
            return this.normalize(UriComponentsBuilder.fromUriString((String)((String)info.get(key))));
        });
    }

    abstract ObjectMapper getObjectMapper();

    @Value.Derived
    private Mono<Map<String, String>> getInfo(ConnectionContext connectionContext) {
        return this.getRoot(connectionContext).map(uri -> UriComponentsBuilder.fromUriString((String)uri).pathSegment(new String[]{"v2", "info"}).build().encode().toUriString()).flatMap(uri -> connectionContext.getHttpClient().get(uri, request -> Mono.just((Object)request).map(UserAgent::addUserAgent).map(JsonCodec::addDecodeHeaders).flatMapMany(HttpClientRequest::send)).doOnSubscribe(NetworkLogging.get(uri)).transform(NetworkLogging.response(uri))).transform(JsonCodec.decode(this.getObjectMapper(), Map.class)).switchIfEmpty(Mono.error((Throwable)new IllegalArgumentException("Info endpoint does not contain a payload"))).map(m -> m).checkpoint();
    }
}

