/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.viterbi;

import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Doubles;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.uima.UimaContext;
import org.apache.uima.fit.component.initialize.ConfigurationParameterInitializer;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.initializable.Initializable;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Classifier;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.SequenceClassifier;
import org.cleartk.ml.viterbi.OutcomeFeatureExtractor;
import org.cleartk.util.CleartkInitializationException;
import org.cleartk.util.ReflectionUtil;

public class ViterbiClassifier<OUTCOME_TYPE>
implements SequenceClassifier<OUTCOME_TYPE>,
Initializable,
ReflectionUtil.TypeArgumentDelegator {
    protected Classifier<OUTCOME_TYPE> delegatedClassifier;
    protected OutcomeFeatureExtractor[] outcomeFeatureExtractors;
    public static final String PARAM_STACK_SIZE = "stackSize";
    @ConfigurationParameter(name="stackSize", description="specifies the maximum number of candidate paths to keep track of. In general, this number should be higher than the number of possible classifications at any given point in the sequence. This guarantees that highest-possible scoring sequence will be returned. If, however, the number of possible classifications is quite high and/or you are concerned about throughput performance, then you may want to reduce the number of candidate paths to maintain.  If Classifier.score is not implemented for the given delegated classifier, then the value of this parameter must be 1. ", defaultValue={"1"})
    protected int stackSize;
    public static final String PARAM_ADD_SCORES = "addScores";
    @ConfigurationParameter(name="addScores", description="specifies whether the scores of candidate sequence classifications should be calculated by summing classfication scores for each member of the sequence or by multiplying them. A value of true means that the scores will be summed. A value of false means that the scores will be multiplied. ", defaultValue={"false"})
    protected boolean addScores = false;

    public ViterbiClassifier(Classifier<OUTCOME_TYPE> delegatedClassifier, OutcomeFeatureExtractor[] outcomeFeatureExtractors) {
        this.delegatedClassifier = delegatedClassifier;
        this.outcomeFeatureExtractors = outcomeFeatureExtractors;
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        ConfigurationParameterInitializer.initialize((Object)this, (UimaContext)context);
        if (this.stackSize < 1) {
            throw CleartkInitializationException.parameterLessThan((String)PARAM_STACK_SIZE, (Object)1, (Object)this.stackSize);
        }
    }

    @Override
    public List<OUTCOME_TYPE> classify(List<List<Feature>> features) throws CleartkProcessingException {
        if (this.stackSize == 1) {
            ArrayList<Object> outcomes = new ArrayList<Object>();
            ArrayList<OUTCOME_TYPE> returnValues = new ArrayList<OUTCOME_TYPE>();
            for (List<Feature> instanceFeatures : features) {
                for (OutcomeFeatureExtractor outcomeFeatureExtractor : this.outcomeFeatureExtractors) {
                    instanceFeatures.addAll(outcomeFeatureExtractor.extractFeatures(outcomes));
                }
                OUTCOME_TYPE outcome = this.delegatedClassifier.classify(instanceFeatures);
                outcomes.add(outcome);
                returnValues.add(outcome);
            }
            return returnValues;
        }
        try {
            return this.viterbi(features);
        }
        catch (UnsupportedOperationException uoe) {
            throw CleartkProcessingException.unsupportedOperationSetParameter(uoe, this.delegatedClassifier, "score", PARAM_STACK_SIZE, 1);
        }
    }

    public List<OUTCOME_TYPE> viterbi(List<List<Feature>> featureLists) throws CleartkProcessingException {
        if (featureLists == null || featureLists.size() == 0) {
            return Collections.emptyList();
        }
        Collection<Object> paths = null;
        for (List<Feature> features : featureLists) {
            if (paths == null) {
                paths = Lists.newArrayList();
                Map<OUTCOME_TYPE, Double> scoredOutcomes = this.getScoredOutcomes(features, null);
                for (Object object : this.getTopOutcomes(scoredOutcomes)) {
                    paths.add(new Path(object, scoredOutcomes.get(object), null));
                }
                continue;
            }
            HashMap maxPaths = Maps.newHashMap();
            for (Path path : paths) {
                Map<OUTCOME_TYPE, Double> scoredOutcomes = this.getScoredOutcomes(features, path);
                for (OUTCOME_TYPE outcome : this.getTopOutcomes(scoredOutcomes)) {
                    double outcomeScore = scoredOutcomes.get(outcome);
                    double score = this.addScores ? path.score + outcomeScore : path.score * outcomeScore;
                    Path maxPath = (Path)maxPaths.get(outcome);
                    if (maxPath != null && !(score > maxPath.score)) continue;
                    maxPaths.put(outcome, new Path(outcome, score, path));
                }
            }
            paths = maxPaths.values();
        }
        return ((Path)Collections.max(paths)).outcomes;
    }

    @Override
    public List<Map<OUTCOME_TYPE, Double>> score(List<List<Feature>> features) throws CleartkProcessingException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Type> getTypeArguments(Class<?> genericType) {
        if (genericType.equals(SequenceClassifier.class)) {
            genericType = Classifier.class;
        }
        return ReflectionUtil.getTypeArguments(genericType, this.delegatedClassifier);
    }

    private Map<OUTCOME_TYPE, Double> getScoredOutcomes(List<Feature> features, Path path) throws CleartkProcessingException {
        Map<OUTCOME_TYPE, Double> scoredOutcomes;
        features = Lists.newArrayList(features);
        if (path != null) {
            ArrayList<Object> previousOutcomes = new ArrayList<Object>(path.outcomes);
            for (OutcomeFeatureExtractor outcomeFeatureExtractor : this.outcomeFeatureExtractors) {
                features.addAll(outcomeFeatureExtractor.extractFeatures(previousOutcomes));
            }
        }
        if ((scoredOutcomes = this.delegatedClassifier.score(features)).isEmpty()) {
            throw new IllegalStateException("expected at least one scored outcome, found " + scoredOutcomes);
        }
        return scoredOutcomes;
    }

    private List<OUTCOME_TYPE> getTopOutcomes(Map<OUTCOME_TYPE, Double> scoredOutcomes) {
        Ordering ordering = Ordering.natural().onResultOf(Functions.forMap(scoredOutcomes));
        return ordering.greatestOf(scoredOutcomes.keySet(), this.stackSize);
    }

    private class Path
    implements Comparable<Path> {
        public OUTCOME_TYPE outcome;
        public double score;
        public Path parent;
        public List<OUTCOME_TYPE> outcomes;

        public Path(OUTCOME_TYPE outcome, double score, Path parent) {
            this.outcome = outcome;
            this.score = score;
            this.parent = parent;
            this.outcomes = Lists.newArrayList();
            if (this.parent != null) {
                this.outcomes.addAll(this.parent.outcomes);
            }
            this.outcomes.add(this.outcome);
        }

        @Override
        public int compareTo(Path that) {
            return Doubles.compare((double)this.score, (double)that.score);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append("outcome", this.outcome).append("score", this.score).append("parent", (Object)this.parent).toString();
        }
    }
}

