/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.jar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.cleartk.util.ClassLookup;

public abstract class JarClassifierBuilder<CLASSIFIER_TYPE> {
    private static final Attributes.Name CLASSIFIER_BUILDER_ATTRIBUTE_NAME = new Attributes.Name("classifierBuilderClass");
    protected Manifest manifest = new Manifest();
    private static final String MODEL_FILE_NAME = "model.jar";

    public static JarClassifierBuilder<?> fromTrainingDirectory(File dir) throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(JarClassifierBuilder.getManifestFile(dir)));){
            Manifest manifest = new Manifest(stream);
            JarClassifierBuilder<?> jarClassifierBuilder = JarClassifierBuilder.fromManifest(manifest);
            return jarClassifierBuilder;
        }
    }

    public static JarClassifierBuilder<?> fromManifest(Manifest manifest) {
        JarClassifierBuilder builder;
        String className = manifest.getMainAttributes().getValue(CLASSIFIER_BUILDER_ATTRIBUTE_NAME);
        try {
            builder = ClassLookup.lookupClass((String)className).asSubclass(JarClassifierBuilder.class).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("ClassifierBuilder class read from manifest does not exist", e);
        }
        builder.manifest = manifest;
        return builder;
    }

    public static void trainAndPackage(File trainingDirectory, String ... trainingArguments) throws Exception {
        JarClassifierBuilder<?> classifierBuilder = JarClassifierBuilder.fromTrainingDirectory(trainingDirectory);
        classifierBuilder.trainClassifier(trainingDirectory, trainingArguments);
        classifierBuilder.packageClassifier(trainingDirectory);
    }

    public JarClassifierBuilder() {
        Attributes attributes = this.manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.put(CLASSIFIER_BUILDER_ATTRIBUTE_NAME, this.getClass().getName());
    }

    public void saveToTrainingDirectory(File dir) throws IOException {
        try (FileOutputStream manifestStream = new FileOutputStream(JarClassifierBuilder.getManifestFile(dir));){
            this.manifest.write(manifestStream);
        }
    }

    public abstract void trainClassifier(File var1, String ... var2) throws Exception;

    public void packageClassifier(File dir) throws IOException {
        try (JarOutputStream modelStream = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(JarClassifierBuilder.getModelJarFile(dir))), this.manifest);){
            this.packageClassifier(dir, modelStream);
        }
    }

    protected void packageClassifier(File dir, JarOutputStream modelStream) throws IOException {
    }

    public static File getModelJarFile(File dir) {
        return new File(dir, MODEL_FILE_NAME);
    }

    public static File getModelJarFile(String directoryName) {
        return JarClassifierBuilder.getModelJarFile(new File(directoryName));
    }

    public CLASSIFIER_TYPE loadClassifierFromTrainingDirectory(File dir) throws IOException {
        File modelJarFile = JarClassifierBuilder.getModelJarFile(dir);
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(modelJarFile));){
            CLASSIFIER_TYPE CLASSIFIER_TYPE = this.loadClassifier(inputStream);
            return CLASSIFIER_TYPE;
        }
    }

    public CLASSIFIER_TYPE loadClassifier(InputStream inputStream) throws IOException {
        if (inputStream instanceof JarInputStream) {
            JarInputStream modelStream = (JarInputStream)inputStream;
            this.unpackageClassifier(modelStream);
            return this.newClassifier();
        }
        try (JarInputStream modelStream = new JarInputStream(inputStream);){
            this.unpackageClassifier(modelStream);
            CLASSIFIER_TYPE CLASSIFIER_TYPE = this.newClassifier();
            return CLASSIFIER_TYPE;
        }
    }

    protected void unpackageClassifier(JarInputStream modelStream) throws IOException {
    }

    protected abstract CLASSIFIER_TYPE newClassifier();

    private static File getManifestFile(File dir) {
        return new File(dir, "MANIFEST.MF");
    }
}

