/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.encoder.outcome;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;

public class StringToIntegerOutcomeEncoder
implements OutcomeEncoder<String, Integer> {
    private static final long serialVersionUID = -4592095619017878663L;
    public static final String LOOKUP_FILE_NAME = "outcome-lookup.txt";
    private Map<String, Integer> map = new TreeMap<String, Integer>();
    private Map<Integer, String> reverseMap = new TreeMap<Integer, String>();
    private int nextIndex;

    public StringToIntegerOutcomeEncoder() {
        this.nextIndex = 1;
    }

    public StringToIntegerOutcomeEncoder(int firstIndex) {
        this.nextIndex = firstIndex;
    }

    @Override
    public Integer encode(String input) {
        if (input == null) {
            return null;
        }
        if (!this.map.containsKey(input)) {
            this.map.put(input, this.nextIndex);
            this.reverseMap.put(this.nextIndex, input);
            ++this.nextIndex;
        }
        return this.map.get(input);
    }

    @Override
    public String decode(Integer outcome) {
        if (outcome == null) {
            return null;
        }
        return this.reverseMap.get(outcome);
    }

    @Override
    public void finalizeOutcomeSet(File outputDirectory) throws IOException {
        File outputFile = new File(outputDirectory, LOOKUP_FILE_NAME);
        PrintWriter writer = new PrintWriter(outputFile);
        ArrayList<Integer> values = new ArrayList<Integer>(this.map.values());
        Collections.sort(values);
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            writer.format("%d %s\n", value, this.reverseMap.get(value));
        }
        writer.close();
    }
}

