/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.encoder.features;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.cleartk.ml.Feature;
import org.cleartk.ml.encoder.CleartkEncoderException;
import org.cleartk.ml.encoder.features.FeaturesEncoder_ImplBase;
import org.cleartk.ml.encoder.features.NameNumber;
import org.cleartk.ml.encoder.features.normalizer.NameNumberNormalizer;
import org.cleartk.ml.encoder.features.normalizer.NoOpNormalizer;
import org.cleartk.ml.util.featurevector.FeatureVector;
import org.cleartk.ml.util.featurevector.InvalidFeatureVectorValueException;
import org.cleartk.ml.util.featurevector.SparseFeatureVector;
import org.cleartk.util.collection.GenericStringMapper;
import org.cleartk.util.collection.StringMapper;
import org.cleartk.util.collection.UnknownKeyException;
import org.cleartk.util.collection.Writable;

public class FeatureVectorFeaturesEncoder
extends FeaturesEncoder_ImplBase<FeatureVector, NameNumber> {
    private static final long serialVersionUID = 6714456694285732480L;
    public static final String LOOKUP_FILE_NAME = "features-lookup.txt";
    private boolean expandIndex = true;
    private StringMapper stringMapper;
    private NameNumberNormalizer normalizer;

    public FeatureVectorFeaturesEncoder(int cutoff, NameNumberNormalizer normalizer) {
        this.normalizer = normalizer;
        this.stringMapper = new GenericStringMapper(cutoff);
    }

    public FeatureVectorFeaturesEncoder(int cutoff) {
        this(cutoff, new NoOpNormalizer());
    }

    public FeatureVectorFeaturesEncoder() {
        this(0, new NoOpNormalizer());
    }

    @Override
    public FeatureVector encodeAll(Iterable<Feature> features) throws CleartkEncoderException {
        ArrayList<NameNumber> fves = new ArrayList<NameNumber>();
        for (Feature feature : features) {
            fves.addAll(this.encode(feature));
        }
        this.normalizer.normalize(fves);
        SparseFeatureVector fv = new SparseFeatureVector();
        for (NameNumber fve : fves) {
            String name = fve.name;
            Number value = fve.number;
            if (value.doubleValue() == 0.0) continue;
            try {
                double v;
                if (this.expandIndex) {
                    int i = this.stringMapper.getOrGenerateInteger(name);
                    v = fv.get(i) + value.doubleValue();
                    fv.set(i, v);
                    continue;
                }
                try {
                    int i = this.stringMapper.getInteger(name);
                    v = fv.get(i) + value.doubleValue();
                    fv.set(i, v);
                }
                catch (UnknownKeyException i) {}
            }
            catch (InvalidFeatureVectorValueException e) {
                throw CleartkEncoderException.invalidFeatureVectorValue(e, e.getIndex(), e.getValue());
            }
        }
        return fv;
    }

    @Override
    public void finalizeFeatureSet(File outputDirectory) throws IOException {
        this.expandIndex = false;
        this.stringMapper.finalizeMap();
        if (this.stringMapper instanceof Writable) {
            Writable writableMap = (Writable)this.stringMapper;
            File outputFile = new File(outputDirectory, LOOKUP_FILE_NAME);
            writableMap.write(outputFile);
        }
    }

    public void setNormalizer(NameNumberNormalizer normalizer) {
        this.normalizer = normalizer;
    }
}

