/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.util;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.classdump.luna.util.ByteIterator;
import org.classdump.luna.util.Check;

public class CharsetEncoderByteIterator
implements ByteIterator {
    private String string;
    private CharsetEncoder encoder;
    private final CharBuffer in;
    private final ByteBuffer out;
    private int idx;
    private int byteIdx;
    private boolean flushed;
    private static final int DEFAULT_STEP_SIZE = 16;

    public CharsetEncoderByteIterator(String string, Charset charset, int stepSize) {
        Objects.requireNonNull(string);
        Check.gt(stepSize, 1);
        this.encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        this.string = string;
        this.idx = 0;
        this.byteIdx = 0;
        this.flushed = false;
        stepSize = Math.min(stepSize, string.length());
        stepSize = Math.max(2, stepSize);
        this.in = CharBuffer.allocate(stepSize);
        int outBufferSize = (int)((float)(stepSize + 1) * this.encoder.maxBytesPerChar());
        this.out = ByteBuffer.allocate(outBufferSize);
        this.out.flip();
    }

    public CharsetEncoderByteIterator(String string, Charset charset) {
        this(string, charset, 16);
    }

    private void fetch() {
        char c;
        this.in.clear();
        while (this.idx < this.string.length() && this.in.hasRemaining() && (!Character.isHighSurrogate(c = this.string.charAt(this.idx)) || this.in.remaining() >= 2)) {
            this.in.put(c);
            ++this.idx;
        }
        this.in.flip();
    }

    private void encode() {
        this.out.clear();
        try {
            CoderResult result = this.encoder.encode(this.in, this.out, this.idx >= this.string.length());
            if (!result.isUnderflow()) {
                result.throwException();
            }
        }
        catch (CharacterCodingException ex) {
            throw new IllegalStateException(ex);
        }
        this.out.flip();
    }

    private void encodeNextChars() {
        this.fetch();
        this.encode();
    }

    private void flush() {
        this.flushed = true;
        this.out.clear();
        try {
            CoderResult result = this.encoder.flush(this.out);
            if (!result.isUnderflow()) {
                result.throwException();
            }
        }
        catch (CharacterCodingException ex) {
            throw new IllegalStateException(ex);
        }
        this.out.flip();
    }

    @Override
    public boolean hasNext() {
        if (this.out.hasRemaining()) {
            return true;
        }
        if (this.idx < this.string.length()) {
            this.encodeNextChars();
            return this.out.hasRemaining();
        }
        if (!this.string.isEmpty() && !this.flushed) {
            this.flush();
            return this.out.hasRemaining();
        }
        return false;
    }

    @Override
    public byte nextByte() {
        try {
            byte b = this.out.get();
            ++this.byteIdx;
            return b;
        }
        catch (BufferOverflowException ex) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public Byte next() {
        return this.nextByte();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("read-only iterator");
    }
}

