/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.runtime;

import java.util.Objects;
import org.classdump.luna.Arithmetic;
import org.classdump.luna.ByteString;
import org.classdump.luna.Conversions;
import org.classdump.luna.LuaMathOperators;
import org.classdump.luna.MetatableProvider;
import org.classdump.luna.Metatables;
import org.classdump.luna.Ordering;
import org.classdump.luna.Table;
import org.classdump.luna.Userdata;
import org.classdump.luna.runtime.Errors;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.runtime.LuaFunction;
import org.classdump.luna.runtime.ResolvedControlThrowable;
import org.classdump.luna.runtime.Resumable;
import org.classdump.luna.runtime.ReturnBuffer;
import org.classdump.luna.runtime.UnresolvedControlThrowable;

public final class Dispatch {
    private static final CmpResultResumable CMP_RESULT_RESUMABLE_TRUE = new CmpResultResumable(true);
    private static final CmpResultResumable CMP_RESULT_RESUMABLE_FALSE = new CmpResultResumable(false);
    private static final Long ZERO = 0L;

    private Dispatch() {
    }

    static LuaFunction callTarget(MetatableProvider metatableProvider, Object target) {
        if (target instanceof LuaFunction) {
            return (LuaFunction)target;
        }
        Object handler = Metatables.getMetamethod(metatableProvider, Metatables.MT_CALL, target);
        if (handler instanceof LuaFunction) {
            return (LuaFunction)handler;
        }
        throw Errors.illegalCallAttempt(target);
    }

    static void mt_invoke(ExecutionContext context, Object target) throws ResolvedControlThrowable {
        LuaFunction fn = Dispatch.callTarget(context, target);
        if (fn == target) {
            fn.invoke(context);
        } else {
            fn.invoke(context, target);
        }
    }

    static void mt_invoke(ExecutionContext context, Object target, Object arg1) throws ResolvedControlThrowable {
        LuaFunction fn = Dispatch.callTarget(context, target);
        if (fn == target) {
            fn.invoke(context, arg1);
        } else {
            fn.invoke(context, target, arg1);
        }
    }

    static void mt_invoke(ExecutionContext context, Object target, Object arg1, Object arg2) throws ResolvedControlThrowable {
        LuaFunction fn = Dispatch.callTarget(context, target);
        if (fn == target) {
            fn.invoke(context, arg1, arg2);
        } else {
            fn.invoke(context, target, arg1, arg2);
        }
    }

    static void mt_invoke(ExecutionContext context, Object target, Object arg1, Object arg2, Object arg3) throws ResolvedControlThrowable {
        LuaFunction fn = Dispatch.callTarget(context, target);
        if (fn == target) {
            fn.invoke(context, arg1, arg2, arg3);
        } else {
            fn.invoke(context, target, arg1, arg2, arg3);
        }
    }

    static void mt_invoke(ExecutionContext context, Object target, Object arg1, Object arg2, Object arg3, Object arg4) throws ResolvedControlThrowable {
        LuaFunction fn = Dispatch.callTarget(context, target);
        if (fn == target) {
            fn.invoke(context, arg1, arg2, arg3, arg4);
        } else {
            fn.invoke(context, target, arg1, arg2, arg3, arg4);
        }
    }

    static void mt_invoke(ExecutionContext context, Object target, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) throws ResolvedControlThrowable {
        LuaFunction fn = Dispatch.callTarget(context, target);
        if (fn == target) {
            fn.invoke(context, arg1, arg2, arg3, arg4, arg5);
        } else {
            fn.invoke(context, new Object[]{target, arg1, arg2, arg3, arg4, arg5});
        }
    }

    static void mt_invoke(ExecutionContext context, Object target, Object[] args) throws ResolvedControlThrowable {
        LuaFunction fn = Dispatch.callTarget(context, target);
        if (fn == target) {
            fn.invoke(context, args);
        } else {
            Object[] mtArgs = new Object[args.length + 1];
            mtArgs[0] = target;
            System.arraycopy(args, 0, mtArgs, 1, args.length);
            fn.invoke(context, mtArgs);
        }
    }

    static void evaluateTailCalls(ExecutionContext context) throws ResolvedControlThrowable {
        ReturnBuffer r = context.getReturnBuffer();
        block8: while (r.isCall()) {
            Object target = r.getCallTarget();
            switch (r.size()) {
                case 0: {
                    Dispatch.mt_invoke(context, target);
                    continue block8;
                }
                case 1: {
                    Dispatch.mt_invoke(context, target, r.get0());
                    continue block8;
                }
                case 2: {
                    Dispatch.mt_invoke(context, target, r.get0(), r.get1());
                    continue block8;
                }
                case 3: {
                    Dispatch.mt_invoke(context, target, r.get0(), r.get1(), r.get2());
                    continue block8;
                }
                case 4: {
                    Dispatch.mt_invoke(context, target, r.get0(), r.get1(), r.get2(), r.get3());
                    continue block8;
                }
                case 5: {
                    Dispatch.mt_invoke(context, target, r.get0(), r.get1(), r.get2(), r.get3(), r.get4());
                    continue block8;
                }
            }
            Dispatch.mt_invoke(context, target, r.getAsArray());
        }
    }

    public static void call(ExecutionContext context, Object target) throws UnresolvedControlThrowable {
        try {
            Dispatch.mt_invoke(context, target);
            Dispatch.evaluateTailCalls(context);
        }
        catch (ResolvedControlThrowable ct) {
            throw ct.unresolve();
        }
    }

    public static void call(ExecutionContext context, Object target, Object arg1) throws UnresolvedControlThrowable {
        try {
            Dispatch.mt_invoke(context, target, arg1);
            Dispatch.evaluateTailCalls(context);
        }
        catch (ResolvedControlThrowable ct) {
            throw ct.unresolve();
        }
    }

    public static void call(ExecutionContext context, Object target, Object arg1, Object arg2) throws UnresolvedControlThrowable {
        try {
            Dispatch.mt_invoke(context, target, arg1, arg2);
            Dispatch.evaluateTailCalls(context);
        }
        catch (ResolvedControlThrowable ct) {
            throw ct.unresolve();
        }
    }

    public static void call(ExecutionContext context, Object target, Object arg1, Object arg2, Object arg3) throws UnresolvedControlThrowable {
        try {
            Dispatch.mt_invoke(context, target, arg1, arg2, arg3);
            Dispatch.evaluateTailCalls(context);
        }
        catch (ResolvedControlThrowable ct) {
            throw ct.unresolve();
        }
    }

    public static void call(ExecutionContext context, Object target, Object arg1, Object arg2, Object arg3, Object arg4) throws UnresolvedControlThrowable {
        try {
            Dispatch.mt_invoke(context, target, arg1, arg2, arg3, arg4);
            Dispatch.evaluateTailCalls(context);
        }
        catch (ResolvedControlThrowable ct) {
            throw ct.unresolve();
        }
    }

    public static void call(ExecutionContext context, Object target, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) throws UnresolvedControlThrowable {
        try {
            Dispatch.mt_invoke(context, target, arg1, arg2, arg3, arg4, arg5);
            Dispatch.evaluateTailCalls(context);
        }
        catch (ResolvedControlThrowable ct) {
            throw ct.unresolve();
        }
    }

    public static void call(ExecutionContext context, Object target, Object[] args) throws UnresolvedControlThrowable {
        try {
            Dispatch.mt_invoke(context, target, args);
            Dispatch.evaluateTailCalls(context);
        }
        catch (ResolvedControlThrowable ct) {
            throw ct.unresolve();
        }
    }

    private static void try_mt_arithmetic(ExecutionContext context, ByteString event, Object a, Object b) throws UnresolvedControlThrowable {
        Object handler = Metatables.binaryHandlerFor(context, event, a, b);
        if (handler == null) {
            throw Errors.illegalArithmeticAttempt(a, b);
        }
        Dispatch.call(context, handler, a, b);
    }

    private static void try_mt_arithmetic(ExecutionContext context, ByteString event, Object o) throws UnresolvedControlThrowable {
        Object handler = Metatables.getMetamethod(context, event, o);
        if (handler == null) {
            throw Errors.illegalArithmeticAttempt(o);
        }
        Dispatch.call(context, handler, o, o);
    }

    public static void add(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        Number nb;
        Number na = Conversions.arithmeticValueOf(a);
        Arithmetic math = Arithmetic.of(na, nb = Conversions.arithmeticValueOf(b));
        if (math != null) {
            context.getReturnBuffer().setTo(math.add(na, nb));
        } else {
            Dispatch.try_mt_arithmetic(context, Metatables.MT_ADD, a, b);
        }
    }

    public static Number add(Number a, Number b) {
        return Arithmetic.of(a, b).add(a, b);
    }

    public static void sub(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        Number nb;
        Number na = Conversions.arithmeticValueOf(a);
        Arithmetic m = Arithmetic.of(na, nb = Conversions.arithmeticValueOf(b));
        if (m != null) {
            context.getReturnBuffer().setTo(m.sub(na, nb));
        } else {
            Dispatch.try_mt_arithmetic(context, Metatables.MT_SUB, a, b);
        }
    }

    public static Number sub(Number a, Number b) {
        return Arithmetic.of(a, b).sub(a, b);
    }

    public static void mul(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        Number nb;
        Number na = Conversions.arithmeticValueOf(a);
        Arithmetic m = Arithmetic.of(na, nb = Conversions.arithmeticValueOf(b));
        if (m != null) {
            context.getReturnBuffer().setTo(m.mul(na, nb));
        } else {
            Dispatch.try_mt_arithmetic(context, Metatables.MT_MUL, a, b);
        }
    }

    public static Number mul(Number a, Number b) {
        return Arithmetic.of(a, b).mul(a, b);
    }

    public static void div(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        Number nb;
        Number na = Conversions.arithmeticValueOf(a);
        Arithmetic m = Arithmetic.of(na, nb = Conversions.arithmeticValueOf(b));
        if (m != null) {
            context.getReturnBuffer().setTo(m.div(na, nb));
        } else {
            Dispatch.try_mt_arithmetic(context, Metatables.MT_DIV, a, b);
        }
    }

    public static Number div(Number a, Number b) {
        return Arithmetic.of(a, b).div(a, b);
    }

    public static void mod(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        Number nb;
        Number na = Conversions.arithmeticValueOf(a);
        Arithmetic m = Arithmetic.of(na, nb = Conversions.arithmeticValueOf(b));
        if (m != null) {
            context.getReturnBuffer().setTo(m.mod(na, nb));
        } else {
            Dispatch.try_mt_arithmetic(context, Metatables.MT_MOD, a, b);
        }
    }

    public static Number mod(Number a, Number b) {
        return Arithmetic.of(a, b).mod(a, b);
    }

    public static void idiv(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        Number nb;
        Number na = Conversions.arithmeticValueOf(a);
        Arithmetic m = Arithmetic.of(na, nb = Conversions.arithmeticValueOf(b));
        if (m != null) {
            context.getReturnBuffer().setTo(m.idiv(na, nb));
        } else {
            Dispatch.try_mt_arithmetic(context, Metatables.MT_IDIV, a, b);
        }
    }

    public static Number idiv(Number a, Number b) {
        return Arithmetic.of(a, b).idiv(a, b);
    }

    public static void pow(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        Number nb;
        Number na = Conversions.arithmeticValueOf(a);
        Arithmetic m = Arithmetic.of(na, nb = Conversions.arithmeticValueOf(b));
        if (m != null) {
            context.getReturnBuffer().setTo(m.pow(na, nb));
        } else {
            Dispatch.try_mt_arithmetic(context, Metatables.MT_POW, a, b);
        }
    }

    public static Number pow(Number a, Number b) {
        return Arithmetic.of(a, b).pow(a, b);
    }

    private static void try_mt_bitwise(ExecutionContext context, ByteString event, Object a, Object b) throws UnresolvedControlThrowable {
        Object handler = Metatables.binaryHandlerFor(context, event, a, b);
        if (handler == null) {
            throw Errors.illegalBitwiseOperationAttempt(a, b);
        }
        Dispatch.call(context, handler, a, b);
    }

    private static void try_mt_bitwise(ExecutionContext context, ByteString event, Object o) throws UnresolvedControlThrowable {
        Object handler = Metatables.getMetamethod(context, event, o);
        if (handler == null) {
            throw Errors.illegalBitwiseOperationAttempt(o);
        }
        Dispatch.call(context, handler, o, o);
    }

    public static void band(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        Long la = Conversions.integerValueOf(a);
        Long lb = Conversions.integerValueOf(b);
        if (la != null && lb != null) {
            context.getReturnBuffer().setTo(LuaMathOperators.band(la, lb));
        } else {
            Dispatch.try_mt_bitwise(context, Metatables.MT_BAND, a, b);
        }
    }

    public static void bor(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        Long la = Conversions.integerValueOf(a);
        Long lb = Conversions.integerValueOf(b);
        if (la != null && lb != null) {
            context.getReturnBuffer().setTo(LuaMathOperators.bor(la, lb));
        } else {
            Dispatch.try_mt_bitwise(context, Metatables.MT_BOR, a, b);
        }
    }

    public static void bxor(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        Long la = Conversions.integerValueOf(a);
        Long lb = Conversions.integerValueOf(b);
        if (la != null && lb != null) {
            context.getReturnBuffer().setTo(LuaMathOperators.bxor(la, lb));
        } else {
            Dispatch.try_mt_bitwise(context, Metatables.MT_BXOR, a, b);
        }
    }

    public static void shl(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        Long la = Conversions.integerValueOf(a);
        Long lb = Conversions.integerValueOf(b);
        if (la != null && lb != null) {
            context.getReturnBuffer().setTo(LuaMathOperators.shl(la, lb));
        } else {
            Dispatch.try_mt_bitwise(context, Metatables.MT_SHL, a, b);
        }
    }

    public static void shr(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        Long la = Conversions.integerValueOf(a);
        Long lb = Conversions.integerValueOf(b);
        if (la != null && lb != null) {
            context.getReturnBuffer().setTo(LuaMathOperators.shr(la, lb));
        } else {
            Dispatch.try_mt_bitwise(context, Metatables.MT_SHR, a, b);
        }
    }

    public static void unm(ExecutionContext context, Object o) throws UnresolvedControlThrowable {
        Number no = Conversions.arithmeticValueOf(o);
        Arithmetic m = Arithmetic.of(no);
        if (m != null) {
            context.getReturnBuffer().setTo(m.unm(no));
        } else {
            Dispatch.try_mt_arithmetic(context, Metatables.MT_UNM, o);
        }
    }

    public static Number unm(Number n) {
        return Arithmetic.of(n).unm(n);
    }

    public static void bnot(ExecutionContext context, Object o) throws UnresolvedControlThrowable {
        Long lo = Conversions.integerValueOf(o);
        if (lo != null) {
            context.getReturnBuffer().setTo(LuaMathOperators.bnot(lo));
        } else {
            Dispatch.try_mt_bitwise(context, Metatables.MT_BNOT, o);
        }
    }

    public static long len(String s) {
        return ByteString.of(s).length();
    }

    public static void len(ExecutionContext context, Object o) throws UnresolvedControlThrowable {
        if (o instanceof ByteString) {
            context.getReturnBuffer().setTo(((ByteString)o).length());
        } else if (o instanceof String) {
            context.getReturnBuffer().setTo(Dispatch.len((String)o));
        } else {
            Object handler = Metatables.getMetamethod(context, Metatables.MT_LEN, o);
            if (handler != null) {
                Dispatch.call(context, handler, o, o);
            } else if (o instanceof Table) {
                context.getReturnBuffer().setTo(((Table)o).rawlen());
            } else {
                throw Errors.illegalGetLengthAttempt(o);
            }
        }
    }

    public static void concat(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        ByteString sa = Conversions.stringValueOf(a);
        ByteString sb = Conversions.stringValueOf(b);
        if (sa != null && sb != null) {
            context.getReturnBuffer().setTo(sa.concat(sb));
        } else {
            Object handler = Metatables.binaryHandlerFor(context, Metatables.MT_CONCAT, a, b);
            if (handler != null) {
                Dispatch.call(context, handler, a, b);
            } else {
                throw Errors.illegalConcatenationAttempt(a, b);
            }
        }
    }

    private static Resumable cmpResultResumable(boolean cmpTo) {
        return cmpTo ? CMP_RESULT_RESUMABLE_TRUE : CMP_RESULT_RESUMABLE_FALSE;
    }

    private static void _call_comparison_mt(ExecutionContext context, boolean cmpTo, Object handler, Object a, Object b) throws UnresolvedControlThrowable {
        try {
            Dispatch.call(context, handler, a, b);
        }
        catch (UnresolvedControlThrowable ct) {
            throw ct.resolve(Dispatch.cmpResultResumable(cmpTo), null).unresolve();
        }
        ReturnBuffer result = context.getReturnBuffer();
        result.setTo(cmpTo == Conversions.booleanValueOf(result.get0()));
    }

    private static void eq(ExecutionContext context, boolean polarity, Object a, Object b) throws UnresolvedControlThrowable {
        Object handler;
        boolean rawEqual = Ordering.isRawEqual(a, b);
        if (!rawEqual && (a instanceof Table && b instanceof Table || a instanceof Userdata && b instanceof Userdata) && (handler = Metatables.binaryHandlerFor(context, Metatables.MT_EQ, a, b)) != null) {
            Dispatch._call_comparison_mt(context, polarity, handler, a, b);
            return;
        }
        context.getReturnBuffer().setTo(rawEqual == polarity);
    }

    public static void eq(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        Dispatch.eq(context, true, a, b);
    }

    public static void neq(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        Dispatch.eq(context, false, a, b);
    }

    public static boolean eq(Number a, Number b) {
        return Ordering.NUMERIC.eq(a, b);
    }

    public static void lt(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        Ordering<Object> c = Ordering.of(a, b);
        if (c != null) {
            boolean result = c.lt(a, b);
            context.getReturnBuffer().setTo(result);
        } else {
            Object handler = Metatables.binaryHandlerFor(context, Metatables.MT_LT, a, b);
            if (handler != null) {
                Dispatch._call_comparison_mt(context, true, handler, a, b);
            } else {
                throw Errors.illegalComparisonAttempt(a, b);
            }
        }
    }

    public static boolean lt(Number a, Number b) {
        return Ordering.NUMERIC.lt(a, b);
    }

    public static boolean lt(String a, String b) {
        return Ordering.STRING.lt(ByteString.of(a), ByteString.of(b));
    }

    public static void le(ExecutionContext context, Object a, Object b) throws UnresolvedControlThrowable {
        Ordering<Object> c = Ordering.of(a, b);
        if (c != null) {
            boolean result = c.le(a, b);
            context.getReturnBuffer().setTo(result);
        } else {
            Object le_handler = Metatables.binaryHandlerFor(context, Metatables.MT_LE, a, b);
            if (le_handler != null) {
                Dispatch._call_comparison_mt(context, true, le_handler, a, b);
            } else {
                Object lt_handler = Metatables.binaryHandlerFor(context, Metatables.MT_LT, a, b);
                if (lt_handler != null) {
                    Dispatch._call_comparison_mt(context, false, lt_handler, b, a);
                } else {
                    throw Errors.illegalComparisonAttempt(a, b);
                }
            }
        }
    }

    public static boolean le(Number a, Number b) {
        return Ordering.NUMERIC.le(a, b);
    }

    public static boolean le(String a, String b) {
        return Ordering.STRING.le(ByteString.of(a), ByteString.of(b));
    }

    public static void index(ExecutionContext context, Object table, Object key) throws UnresolvedControlThrowable {
        Table t;
        Object value;
        if (table instanceof Table && (value = (t = (Table)table).rawget(key)) != null) {
            context.getReturnBuffer().setTo(value);
            return;
        }
        Object handler = Metatables.getMetamethod(context, Metatables.MT_INDEX, table);
        if (handler == null && table instanceof Table) {
            context.getReturnBuffer().setTo(null);
            return;
        }
        if (handler instanceof LuaFunction) {
            LuaFunction fn = (LuaFunction)handler;
            try {
                fn.invoke(context, table, key);
                Dispatch.evaluateTailCalls(context);
            }
            catch (ResolvedControlThrowable ct) {
                throw ct.unresolve();
            }
        } else if (handler instanceof Table) {
            Dispatch.index(context, handler, key);
        } else {
            throw Errors.illegalIndexAttempt(table, key);
        }
    }

    public static void index(ExecutionContext context, Table table, Object key) throws UnresolvedControlThrowable {
        Dispatch.index(context, (Object)Objects.requireNonNull(table), key);
    }

    public static void index(ExecutionContext context, Table table, long key) throws UnresolvedControlThrowable {
        Dispatch.index(context, (Object)Objects.requireNonNull(table), (Object)key);
    }

    public static void setindex(ExecutionContext context, Object table, Object key, Object value) throws UnresolvedControlThrowable {
        Table t;
        Object r;
        if (table instanceof Table && (r = (t = (Table)table).rawget(key)) != null) {
            t.rawset(key, value);
            return;
        }
        Object handler = Metatables.getMetamethod(context, Metatables.MT_NEWINDEX, table);
        if (handler == null && table instanceof Table) {
            Table t2 = (Table)table;
            t2.rawset(key, value);
            return;
        }
        if (handler instanceof LuaFunction) {
            LuaFunction fn = (LuaFunction)handler;
            try {
                fn.invoke(context, table, key, value);
                Dispatch.evaluateTailCalls(context);
            }
            catch (ResolvedControlThrowable ct) {
                throw ct.unresolve();
            }
        } else if (handler instanceof Table) {
            Dispatch.setindex(context, handler, key, value);
        } else {
            throw Errors.illegalIndexAttempt(table, key);
        }
    }

    public static void setindex(ExecutionContext context, Table table, Object key, Object value) throws UnresolvedControlThrowable {
        Dispatch.setindex(context, (Object)Objects.requireNonNull(table), key, value);
    }

    public static void setindex(ExecutionContext context, Table table, long key, Object value) throws UnresolvedControlThrowable {
        Dispatch.setindex(context, (Object)Objects.requireNonNull(table), (Object)key, value);
    }

    public static boolean signed_le(Number a, Number b, Number sign) {
        return !Dispatch.eq(ZERO, sign) && (Dispatch.lt(ZERO, sign) ? Dispatch.le(a, b) : Dispatch.le(b, a));
    }

    private static class CmpResultResumable
    implements Resumable {
        private final boolean cmpTo;

        public CmpResultResumable(boolean cmpTo) {
            this.cmpTo = cmpTo;
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            ReturnBuffer result;
            boolean resultValue = Conversions.booleanValueOf((result = context.getReturnBuffer()).get0());
            result.setTo(this.cmpTo == resultValue);
        }
    }
}

