/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser.ast;

import java.util.Objects;
import org.classdump.luna.parser.ast.Attributes;
import org.classdump.luna.parser.ast.Block;
import org.classdump.luna.parser.ast.BodyStatement;
import org.classdump.luna.parser.ast.Expr;
import org.classdump.luna.parser.ast.Name;
import org.classdump.luna.parser.ast.Transformer;

public class NumericForStatement
extends BodyStatement {
    private final Name name;
    private final Expr init;
    private final Expr limit;
    private final Expr step;
    private final Block block;

    public NumericForStatement(Attributes attr, Name name, Expr init, Expr limit, Expr step, Block block) {
        super(attr);
        this.name = Objects.requireNonNull(name);
        this.init = Objects.requireNonNull(init);
        this.limit = Objects.requireNonNull(limit);
        this.step = step;
        this.block = Objects.requireNonNull(block);
    }

    public Name name() {
        return this.name;
    }

    public Expr init() {
        return this.init;
    }

    public Expr limit() {
        return this.limit;
    }

    public Expr step() {
        return this.step;
    }

    public Block block() {
        return this.block;
    }

    public NumericForStatement update(Name name, Expr init, Expr limit, Expr step, Block block) {
        if (this.name.equals(name) && this.init.equals(init) && this.limit.equals(limit) && Objects.equals(this.step, step) && this.block.equals(block)) {
            return this;
        }
        return new NumericForStatement(this.attributes(), name, init, limit, step, block);
    }

    public NumericForStatement withAttributes(Attributes attr) {
        if (this.attributes().equals(attr)) {
            return this;
        }
        return new NumericForStatement(attr, this.name, this.init, this.limit, this.step, this.block);
    }

    public NumericForStatement with(Object o) {
        return this.withAttributes(this.attributes().with(o));
    }

    @Override
    public BodyStatement accept(Transformer tf) {
        return tf.transform(this);
    }
}

