/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser.ast;

import java.util.Objects;
import org.classdump.luna.LuaFormat;
import org.classdump.luna.parser.ast.Literal;
import org.classdump.luna.parser.ast.Transformer;
import org.classdump.luna.util.Check;

public abstract class Numeral
extends Literal {
    private Numeral() {
    }

    public static Numeral fromString(String s) {
        Objects.requireNonNull(s);
        Number n = LuaFormat.tryParseNumeral(s);
        if (n == null) {
            throw new IllegalArgumentException("not a number: " + s);
        }
        return n instanceof Double || n instanceof Float ? new FloatNumeral(n.doubleValue()) : new IntegerNumeral(n.longValue());
    }

    public static class FloatNumeral
    extends Numeral {
        private final double value;

        public FloatNumeral(double value) {
            Check.notNaN(value);
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FloatNumeral that = (FloatNumeral)o;
            return Double.compare(this.value, that.value) == 0;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.value);
            return (int)(temp ^ temp >>> 32);
        }

        public String toString() {
            return Double.toString(this.value);
        }

        public double value() {
            return this.value;
        }

        @Override
        public Literal accept(Transformer tf) {
            return tf.transform(this);
        }
    }

    public static class IntegerNumeral
    extends Numeral {
        private final long value;

        public IntegerNumeral(long value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntegerNumeral that = (IntegerNumeral)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return Long.toString(this.value);
        }

        public long value() {
            return this.value;
        }

        @Override
        public Literal accept(Transformer tf) {
            return tf.transform(this);
        }
    }
}

