/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser.ast;

import java.util.Objects;
import org.classdump.luna.parser.ast.Attributes;
import org.classdump.luna.parser.ast.Expr;
import org.classdump.luna.parser.ast.Operator;
import org.classdump.luna.parser.ast.Transformer;

public class BinaryOperationExpr
extends Expr {
    private final Operator.Binary op;
    private final Expr left;
    private final Expr right;

    public BinaryOperationExpr(Attributes attr, Operator.Binary op, Expr left, Expr right) {
        super(attr);
        this.op = Objects.requireNonNull(op);
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    public Operator.Binary op() {
        return this.op;
    }

    public Expr left() {
        return this.left;
    }

    public Expr right() {
        return this.right;
    }

    public BinaryOperationExpr update(Expr left, Expr right) {
        if (this.left.equals(left) && this.right.equals(right)) {
            return this;
        }
        return new BinaryOperationExpr(this.attributes(), this.op, left, right);
    }

    @Override
    public Expr accept(Transformer tf) {
        return tf.transform(this);
    }
}

