/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser.analysis;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.classdump.luna.parser.analysis.FunctionVarInfo;
import org.classdump.luna.parser.analysis.ResolvedVariable;
import org.classdump.luna.parser.analysis.Variable;
import org.classdump.luna.parser.ast.Name;

class FunctionVarInfoBuilder {
    private final FunctionVarInfoBuilder parent;
    private final Deque<BlockScope> blockScopes;
    private final List<Variable> params;
    private final List<Variable> locals;
    private final List<Variable.Ref> upvals;
    private boolean varargsUsed;

    public FunctionVarInfoBuilder(FunctionVarInfoBuilder parent) {
        this.parent = parent;
        this.blockScopes = new ArrayDeque<BlockScope>();
        this.params = new ArrayList<Variable>();
        this.locals = new ArrayList<Variable>();
        this.upvals = new ArrayList<Variable.Ref>();
        this.varargsUsed = false;
        if (parent == null) {
            this.upvals.add(Variable.ENV.ref());
        }
    }

    public FunctionVarInfoBuilder parent() {
        return this.parent;
    }

    public BlockScope enterBlock() {
        BlockScope b = new BlockScope();
        this.blockScopes.push(b);
        return b;
    }

    public void leaveBlock() {
        this.blockScopes.pop();
    }

    public Variable addParam(Name n) {
        Variable v = this.addLocal(n);
        this.params.add(v);
        return v;
    }

    public Variable addLocal(Name n) {
        Variable v = this.blockScopes.peek().addLocal(n);
        this.locals.add(v);
        return v;
    }

    public void setVararg() {
        this.varargsUsed = true;
    }

    public boolean isVararg() {
        return this.varargsUsed;
    }

    private Variable findLocal(Name n) {
        for (BlockScope b : this.blockScopes) {
            Variable v = b.find(n);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public ResolvedVariable resolve(Name n) {
        ResolvedVariable p;
        Variable v = this.findLocal(n);
        if (v != null) {
            return ResolvedVariable.local(v);
        }
        ResolvedVariable result = null;
        if (this.parent != null && (p = this.parent.resolve(n)) != null) {
            result = ResolvedVariable.upvalue(p.variable());
        }
        if (result == null && n.equals(Variable.ENV_NAME)) {
            result = ResolvedVariable.upvalue(Variable.ENV);
        }
        if (result != null) {
            this.registerUpvalue(result);
        }
        return result;
    }

    private void registerUpvalue(ResolvedVariable rv) {
        Variable.Ref ref = rv.variable().ref();
        if (rv.isUpvalue() && !this.upvals.contains(ref)) {
            this.upvals.add(ref);
        }
    }

    public FunctionVarInfo toVarInfo() {
        return new FunctionVarInfo(Collections.unmodifiableList(this.params), Collections.unmodifiableList(this.locals), Collections.unmodifiableList(this.upvals), this.varargsUsed);
    }

    private static class Local {
        public final Name name;
        public final Variable var;

        public Local(Name name, Variable var) {
            this.name = Objects.requireNonNull(name);
            this.var = Objects.requireNonNull(var);
        }
    }

    private static class BlockScope {
        public final Deque<Local> locals = new ArrayDeque<Local>();

        public Variable addLocal(Name n) {
            Variable v = new Variable(n);
            this.locals.push(new Local(n, v));
            return v;
        }

        public Variable find(Name n) {
            for (Local l : this.locals) {
                if (!l.name.equals(n)) continue;
                return l.var;
            }
            return null;
        }
    }
}

