/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.classdump.luna.parser.Exprs;
import org.classdump.luna.parser.SourceElement;
import org.classdump.luna.parser.ast.Expr;
import org.classdump.luna.parser.ast.Operator;
import org.classdump.luna.parser.ast.SourceInfo;

class ExprBuilder {
    private final Deque<Expr> operandStack = new ArrayDeque<Expr>();
    private final Deque<SourceElement<Operator>> operatorStack = new ArrayDeque<SourceElement<Operator>>();

    ExprBuilder() {
    }

    private static boolean isRightAssociative(Operator op) {
        return op instanceof Operator.Binary && !((Operator.Binary)op).isLeftAssociative();
    }

    private static boolean hasLesserPrecedence(Operator newOp, Operator top) {
        Objects.requireNonNull(newOp);
        Objects.requireNonNull(top);
        return !(newOp instanceof Operator.Unary) && (ExprBuilder.isRightAssociative(newOp) ? newOp.precedence() < top.precedence() : newOp.precedence() <= top.precedence());
    }

    private void makeOp(SourceElement<Operator> srcOp) {
        SourceInfo src = srcOp.sourceInfo();
        Operator op = srcOp.element();
        if (op instanceof Operator.Binary) {
            Expr r = this.operandStack.pop();
            Expr l = this.operandStack.pop();
            this.operandStack.push(Exprs.binaryOperation(src, (Operator.Binary)op, l, r));
        } else if (op instanceof Operator.Unary) {
            Expr a = this.operandStack.pop();
            this.operandStack.push(Exprs.unaryOperation(src, (Operator.Unary)op, a));
        } else {
            throw new IllegalStateException("Illegal operator: " + op);
        }
    }

    public void addOp(SourceInfo src, Operator op) {
        Objects.requireNonNull(src);
        Objects.requireNonNull(op);
        while (!this.operatorStack.isEmpty() && ExprBuilder.hasLesserPrecedence(op, this.operatorStack.peek().element())) {
            this.makeOp(this.operatorStack.pop());
        }
        this.operatorStack.push(SourceElement.of(src, op));
    }

    public void addExpr(Expr expr) {
        Objects.requireNonNull(expr);
        this.operandStack.push(expr);
    }

    public Expr build() {
        while (!this.operatorStack.isEmpty()) {
            this.makeOp(this.operatorStack.pop());
        }
        Expr result = this.operandStack.pop();
        assert (this.operandStack.isEmpty());
        assert (this.operatorStack.isEmpty());
        return result;
    }
}

