/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.classdump.luna.ByteString;
import org.classdump.luna.Table;
import org.classdump.luna.lib.IoFile;
import org.classdump.luna.lib.io.SeekableOutputStream;

public class OutputStreamIoFile
extends IoFile {
    private final SeekableOutputStream out;

    public OutputStreamIoFile(OutputStream out, Table metatable, Object userValue) {
        super(metatable, userValue);
        this.out = new SeekableOutputStream(Objects.requireNonNull(out));
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("cannot close standard file");
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(ByteString s) throws IOException {
        s.writeTo(this.out);
    }

    @Override
    public long seek(IoFile.Whence whence, long offset) throws IOException {
        switch (whence) {
            case BEGINNING: 
            case END: {
                return this.out.setPosition(offset);
            }
            case CURRENT_POSITION: {
                return this.out.addPosition(offset);
            }
        }
        throw new IllegalArgumentException("Illegal whence: " + (Object)((Object)whence));
    }
}

