/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.classdump.luna.ByteString;
import org.classdump.luna.ByteStringBuilder;
import org.classdump.luna.Conversions;
import org.classdump.luna.LuaFormat;
import org.classdump.luna.LuaRuntimeException;
import org.classdump.luna.Metatables;
import org.classdump.luna.PlainValueTypeNamer;
import org.classdump.luna.StateContext;
import org.classdump.luna.Table;
import org.classdump.luna.impl.NonsuspendableFunctionException;
import org.classdump.luna.impl.UnimplementedFunction;
import org.classdump.luna.lib.AbstractLibFunction;
import org.classdump.luna.lib.ArgumentIterator;
import org.classdump.luna.lib.BadArgumentException;
import org.classdump.luna.lib.BasicLib;
import org.classdump.luna.lib.ModuleLib;
import org.classdump.luna.lib.StringPattern;
import org.classdump.luna.runtime.AbstractFunction0;
import org.classdump.luna.runtime.Dispatch;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.runtime.IllegalOperationAttemptException;
import org.classdump.luna.runtime.LuaFunction;
import org.classdump.luna.runtime.ResolvedControlThrowable;
import org.classdump.luna.runtime.UnresolvedControlThrowable;
import org.classdump.luna.util.ByteIterator;

public final class StringLib {
    static final LuaFunction BYTE = new Byte();
    static final LuaFunction CHAR = new Char();
    static final LuaFunction DUMP = new Dump();
    static final LuaFunction FIND = new Find();
    static final LuaFunction FORMAT = new Format();
    static final LuaFunction GMATCH = new GMatch();
    static final LuaFunction GSUB = new GSub();
    static final LuaFunction LEN = new Len();
    static final LuaFunction LOWER = new Lower();
    static final LuaFunction MATCH = new Match();
    static final LuaFunction PACK = new Pack();
    static final LuaFunction PACKSIZE = new PackSize();
    static final LuaFunction REP = new Rep();
    static final LuaFunction REVERSE = new Reverse();
    static final LuaFunction SUB = new Sub();
    static final LuaFunction UNPACK = new Unpack();
    static final LuaFunction UPPER = new Upper();

    public static LuaFunction byteFn() {
        return BYTE;
    }

    public static LuaFunction charFn() {
        return CHAR;
    }

    public static LuaFunction dump() {
        return DUMP;
    }

    public static LuaFunction find() {
        return FIND;
    }

    public static LuaFunction format() {
        return FORMAT;
    }

    public static LuaFunction gmatch() {
        return GMATCH;
    }

    public static LuaFunction gsub() {
        return GSUB;
    }

    public static LuaFunction len() {
        return LEN;
    }

    public static LuaFunction lower() {
        return LOWER;
    }

    public static LuaFunction match() {
        return MATCH;
    }

    static LuaFunction pack() {
        return PACK;
    }

    static LuaFunction packsize() {
        return PACKSIZE;
    }

    public static LuaFunction rep() {
        return REP;
    }

    public static LuaFunction reverse() {
        return REVERSE;
    }

    public static LuaFunction sub() {
        return SUB;
    }

    static LuaFunction unpack() {
        return UNPACK;
    }

    public static LuaFunction upper() {
        return UPPER;
    }

    private StringLib() {
    }

    public static void installInto(StateContext context, Table env) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(env);
        Table t = context.newTable();
        t.rawset("byte", (Object)StringLib.byteFn());
        t.rawset("char", (Object)StringLib.charFn());
        t.rawset("dump", (Object)StringLib.dump());
        t.rawset("find", (Object)StringLib.find());
        t.rawset("format", (Object)StringLib.format());
        t.rawset("gmatch", (Object)StringLib.gmatch());
        t.rawset("gsub", (Object)StringLib.gsub());
        t.rawset("len", (Object)StringLib.len());
        t.rawset("lower", (Object)StringLib.lower());
        t.rawset("match", (Object)StringLib.match());
        t.rawset("pack", (Object)StringLib.pack());
        t.rawset("packsize", (Object)StringLib.packsize());
        t.rawset("rep", (Object)StringLib.rep());
        t.rawset("reverse", (Object)StringLib.reverse());
        t.rawset("sub", (Object)StringLib.sub());
        t.rawset("unpack", (Object)StringLib.unpack());
        t.rawset("upper", (Object)StringLib.upper());
        Table mt = context.newTable();
        mt.rawset(Metatables.MT_INDEX, (Object)t);
        context.setStringMetatable(mt);
        ModuleLib.install(env, "string", t);
    }

    private static int lowerBound(int i, int len) {
        int j = i < 0 ? len + i + 1 : i;
        return Math.max(1, j);
    }

    private static int upperBound(int i, int len) {
        int j = i < 0 ? len + i + 1 : i;
        return Math.max(0, Math.min(len, j));
    }

    private static byte toLower(byte b) {
        int c = b & 0xFF;
        return c >= 65 && c <= 90 ? (byte)(c - 65 + 97) : b;
    }

    private static ByteString toLowerCase(ByteString s) {
        boolean changed = false;
        ByteStringBuilder bld = new ByteStringBuilder();
        ByteIterator it = s.byteIterator();
        while (it.hasNext()) {
            byte c;
            byte b = it.nextByte();
            changed |= b != (c = StringLib.toLower(b));
            bld.append(c);
        }
        return changed ? bld.toByteString() : s;
    }

    private static byte toUpper(byte b) {
        int c = b & 0xFF;
        return c >= 97 && c <= 122 ? (byte)(c - 97 + 65) : b;
    }

    private static ByteString toUpperCase(ByteString s) {
        boolean changed = false;
        ByteStringBuilder bld = new ByteStringBuilder();
        ByteIterator it = s.byteIterator();
        while (it.hasNext()) {
            byte c;
            byte b = it.nextByte();
            changed |= b != (c = StringLib.toUpper(b));
            bld.append(c);
        }
        return changed ? bld.toByteString() : s;
    }

    static class Upper
    extends AbstractLibFunction {
        Upper() {
        }

        @Override
        protected String name() {
            return "upper";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            ByteString s = args.nextString();
            context.getReturnBuffer().setTo(StringLib.toUpperCase(s));
        }
    }

    static class Unpack
    extends UnimplementedFunction {
        public Unpack() {
            super("string.unpack");
        }
    }

    static class Sub
    extends AbstractLibFunction {
        Sub() {
        }

        @Override
        protected String name() {
            return "sub";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            ByteString s = args.nextString();
            int i = (int)args.nextInteger();
            int j = (int)args.nextOptionalInteger(-1L);
            int len = s.length();
            ByteString result = (i = StringLib.lowerBound(i, len) - 1) < (j = StringLib.upperBound(j, len)) ? s.substring(i, j) : ByteString.empty();
            context.getReturnBuffer().setTo(result);
        }
    }

    static class Reverse
    extends AbstractLibFunction {
        Reverse() {
        }

        @Override
        protected String name() {
            return "reverse";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            ByteString s = args.nextString();
            byte[] bytes = s.getBytes();
            for (int i = 0; i < bytes.length / 2; ++i) {
                int j = bytes.length - 1 - i;
                byte tmp = bytes[i];
                bytes[i] = bytes[j];
                bytes[j] = tmp;
            }
            ByteString result = ByteString.copyOf(bytes);
            context.getReturnBuffer().setTo(result);
        }
    }

    static class Rep
    extends AbstractLibFunction {
        Rep() {
        }

        @Override
        protected String name() {
            return "rep";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            ByteString result;
            ByteString s = args.nextString();
            int n = args.nextInt();
            ByteString sep = args.nextOptionalString(ByteString.empty());
            if (n > 0) {
                ByteStringBuilder bld = new ByteStringBuilder();
                for (int i = 0; i < n; ++i) {
                    bld.append(s);
                    if (i + 1 >= n) continue;
                    bld.append(sep);
                }
                result = bld.toByteString();
            } else {
                result = ByteString.empty();
            }
            context.getReturnBuffer().setTo(result);
        }
    }

    static class PackSize
    extends UnimplementedFunction {
        public PackSize() {
            super("string.packsize");
        }
    }

    static class Pack
    extends UnimplementedFunction {
        public Pack() {
            super("string.pack");
        }
    }

    static class Match
    extends AbstractLibFunction {
        Match() {
        }

        @Override
        protected String name() {
            return "match";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            String s = args.nextString().toString();
            String pattern = args.nextString().toString();
            int init = args.nextOptionalInt(1);
            init = StringLib.lowerBound(init, s.length());
            StringPattern pat = StringPattern.fromString(pattern);
            StringPattern.Match m = pat.match(s, init - 1);
            if (m != null) {
                if (m.captures().isEmpty()) {
                    context.getReturnBuffer().setTo(m.fullMatch());
                } else {
                    context.getReturnBuffer().setToContentsOf(m.captures());
                }
            } else {
                context.getReturnBuffer().setTo(null);
            }
        }
    }

    static class Lower
    extends AbstractLibFunction {
        Lower() {
        }

        @Override
        protected String name() {
            return "lower";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            ByteString s = args.nextString();
            context.getReturnBuffer().setTo(StringLib.toLowerCase(s));
        }
    }

    static class Len
    extends AbstractLibFunction {
        Len() {
        }

        @Override
        protected String name() {
            return "len";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            ByteString s = args.nextString();
            context.getReturnBuffer().setTo(s.length());
        }
    }

    static class GSub
    extends AbstractLibFunction {
        private static final String ARG3_ERROR_MESSAGE = "string/function/table expected";

        GSub() {
        }

        @Override
        protected String name() {
            return "gsub";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Object repl;
            String s = args.nextString().toString();
            String pattern = args.nextString().toString();
            if (!args.hasNext()) {
                throw new BadArgumentException(3, this.name(), ARG3_ERROR_MESSAGE);
            }
            Object o = args.nextAny();
            ByteString replStr = Conversions.stringValueOf(o);
            if (replStr != null) {
                repl = replStr.toString();
            } else if (o instanceof Table || o instanceof LuaFunction) {
                repl = o;
            } else {
                throw new BadArgumentException(3, this.name(), ARG3_ERROR_MESSAGE);
            }
            int n = args.nextOptionalInt(Integer.MAX_VALUE);
            StringPattern pat = StringPattern.fromString(pattern);
            this.run(context, s, 0, new StringBuilder(), pat, 0, n, repl);
        }

        private void run(ExecutionContext context, String str, int idx, StringBuilder bld, StringPattern pat, int count, int num, Object repl) throws ResolvedControlThrowable {
            StringPattern.Match m;
            while (count < num && (m = pat.match(str, idx)) != null) {
                ++count;
                if (idx < m.beginIndex()) {
                    bld.append(str.substring(idx, m.beginIndex()));
                }
                List<Object> captures = m.captures().isEmpty() ? Collections.singletonList(m.fullMatch()) : m.captures();
                int n = idx = m.endIndex() != idx ? m.endIndex() : m.endIndex() + 1;
                if (repl instanceof String) {
                    String r = GSub.stringReplace((String)repl, m.fullMatch(), captures);
                    bld.append(r);
                    continue;
                }
                this.nonStringReplace(context, str, pat, idx, count, num, bld, repl, m.fullMatch(), captures);
            }
            if (idx < str.length()) {
                bld.append(str.substring(idx, str.length()));
            }
            context.getReturnBuffer().setTo(bld.toString(), count);
        }

        private static String stringReplace(String s, String fullMatch, List<Object> captures) {
            StringBuilder bld = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '%' && i + 1 < s.length()) {
                    char d = s.charAt(i + 1);
                    ++i;
                    if (d >= '0' && d <= '9') {
                        int idx = d - 48;
                        if (idx == 0) {
                            bld.append(fullMatch);
                            continue;
                        }
                        if (idx - 1 < captures.size()) {
                            ByteString sv = Conversions.stringValueOf(captures.get(idx - 1));
                            assert (sv != null);
                            bld.append(sv);
                            continue;
                        }
                        bld.append(d);
                        continue;
                    }
                    bld.append(d);
                    continue;
                }
                bld.append(c);
            }
            return bld.toString();
        }

        private void nonStringReplace(ExecutionContext context, String str, StringPattern pat, int idx, int count, int num, StringBuilder bld, Object repl, String fullMatch, List<Object> captures) throws ResolvedControlThrowable {
            block5: {
                assert (!captures.isEmpty());
                Object cap = captures.get(0);
                try {
                    if (repl instanceof Table) {
                        Dispatch.index(context, (Table)repl, cap);
                        break block5;
                    }
                    if (repl instanceof LuaFunction) {
                        Dispatch.call(context, (Object)((LuaFunction)repl), captures.toArray());
                        break block5;
                    }
                    throw new IllegalStateException("Illegal replacement: " + repl);
                }
                catch (UnresolvedControlThrowable ct) {
                    throw ct.resolve(this, new State(str, pat, count, num, repl, bld, fullMatch, idx));
                }
            }
            GSub.resumeReplace(context, bld, fullMatch);
        }

        private static void resumeReplace(ExecutionContext context, StringBuilder bld, String fullMatch) {
            Object value = context.getReturnBuffer().get0();
            ByteString sv = Conversions.stringValueOf(value);
            if (sv != null) {
                bld.append(sv);
            } else if (!Conversions.booleanValueOf(value)) {
                bld.append(fullMatch);
            } else {
                throw new LuaRuntimeException((Object)("invalid replacement value (a " + PlainValueTypeNamer.INSTANCE.typeNameOf(value) + ")"));
            }
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            State state = (State)suspendedState;
            GSub.resumeReplace(context, state.bld, state.fullMatch);
            this.run(context, state.str, state.idx, state.bld, state.pat, state.count, state.num, state.repl);
        }

        private static class State {
            public final String str;
            public final StringPattern pat;
            public final int count;
            public final int num;
            public final Object repl;
            public final StringBuilder bld;
            public final String fullMatch;
            public final int idx;

            private State(String str, StringPattern pat, int count, int num, Object repl, StringBuilder bld, String fullMatch, int idx) {
                this.str = str;
                this.pat = pat;
                this.count = count;
                this.num = num;
                this.repl = repl;
                this.bld = bld;
                this.fullMatch = fullMatch;
                this.idx = idx;
            }
        }
    }

    static class GMatch
    extends AbstractLibFunction {
        GMatch() {
        }

        @Override
        protected String name() {
            return "gmatch";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            String s = args.nextString().toString();
            String pattern = args.nextString().toString();
            StringPattern pat = StringPattern.fromString(pattern, true);
            IteratorFunction f = new IteratorFunction(s, pat);
            context.getReturnBuffer().setTo(f);
        }

        static class IteratorFunction
        extends AbstractFunction0 {
            public final String string;
            public final StringPattern pattern;
            private final AtomicInteger index;

            public IteratorFunction(String string, StringPattern pattern) {
                this.string = Objects.requireNonNull(string);
                this.pattern = Objects.requireNonNull(pattern);
                this.index = new AtomicInteger(0);
            }

            @Override
            public void invoke(ExecutionContext context) throws ResolvedControlThrowable {
                int idx = this.index.get();
                if (idx >= 0) {
                    StringPattern.Match m = this.pattern.match(this.string, idx);
                    if (m != null) {
                        int endIndex = m.endIndex();
                        if (endIndex == idx) {
                            ++endIndex;
                        }
                        this.index.set(endIndex);
                        if (!m.captures().isEmpty()) {
                            context.getReturnBuffer().setToContentsOf(m.captures());
                        } else {
                            context.getReturnBuffer().setTo(m.fullMatch());
                        }
                    } else {
                        this.index.set(-1);
                        context.getReturnBuffer().setTo();
                    }
                } else {
                    context.getReturnBuffer().setTo();
                }
            }

            @Override
            public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
                throw new NonsuspendableFunctionException(this.getClass());
            }
        }
    }

    static class Format
    extends AbstractLibFunction {
        private static final long L_1E18 = 1000000000000000000L;
        private static final long L_9E18 = 9000000000000000000L;
        private static final long L_10E18 = -8446744073709551616L;
        private static final int FLAG_LEFTJUSTIFY = 2;
        private static final int FLAG_SIGN_ALWAYS = 4;
        private static final int FLAG_SIGN_SPACE = 8;
        private static final int FLAG_ZERO_PAD = 16;
        private static final int FLAG_ALT_FORM = 32;

        Format() {
        }

        @Override
        protected String name() {
            return "format";
        }

        private static String optionToString(char c) {
            if (Character.isLetterOrDigit(c)) {
                return "%" + c;
            }
            return "%<\\" + c + ">";
        }

        private static void repeatChar(char c, int num, StringBuilder bld) {
            for (int i = 0; i < num; ++i) {
                bld.append(c);
            }
        }

        private static String padLeft(String s, char c, int width) {
            int diff = width - s.length();
            if (diff > 0) {
                StringBuilder bld = new StringBuilder();
                Format.repeatChar(c, diff, bld);
                bld.append(s);
                return bld.toString();
            }
            return s;
        }

        private static String padRight(String s, char c, int width) {
            int diff = width - s.length();
            if (diff > 0) {
                StringBuilder bld = new StringBuilder();
                bld.append(s);
                Format.repeatChar(c, diff, bld);
                return bld.toString();
            }
            return s;
        }

        public static String longToUnsignedString(long x) {
            return x >= 0L ? Long.toString(x) : (x >= -8446744073709551616L ? '1' + Format.padLeft(Long.toString(x - -8446744073709551616L), '0', 19) : '9' + Format.padLeft(Long.toString(x - 9000000000000000000L), '0', 18));
        }

        private int literal(String fmt, int from, StringBuilder bld) {
            int index = from;
            while (index < fmt.length()) {
                char c;
                if ((c = fmt.charAt(index++)) != '%') {
                    bld.append(c);
                    continue;
                }
                if (index < fmt.length() && fmt.charAt(index) == '%') {
                    bld.append('%');
                    ++index;
                    continue;
                }
                return index;
            }
            return -1;
        }

        private static IllegalArgumentException invalidOptionException(char c) {
            return new IllegalArgumentException("invalid option '" + Format.optionToString(c) + "' to 'format'");
        }

        private static int setFlag(int flags, int mask) {
            if ((flags & mask) != 0) {
                throw new IllegalArgumentException("illegal format (repeated flags)");
            }
            return flags | mask;
        }

        private static boolean hasFlag(int flags, int mask) {
            return (flags & mask) != 0;
        }

        private static String sign(boolean nonNegative, int flags) {
            return nonNegative ? (Format.hasFlag(flags, 4) ? "+" : (Format.hasFlag(flags, 16) ? " " : "")) : "-";
        }

        private static String altForm(long value, int flags, String prefix) {
            return value != 0L && Format.hasFlag(flags, 32) ? prefix : "";
        }

        private static String padded(int precision, String digits) {
            return precision >= 0 ? Format.padLeft("0".equals(digits) ? "" : digits, '0', precision) : digits;
        }

        private static String trimmed(int precision, String chars) {
            return precision >= 0 ? chars.substring(0, Math.min(chars.length(), precision)) : chars;
        }

        private static String justified(int width, int flags, String digits) {
            return width >= 0 ? (Format.hasFlag(flags, 2) ? Format.padRight(digits, ' ', width) : Format.padLeft(digits, ' ', width)) : digits;
        }

        private static void format_signed_integer(StringBuilder bld, ArgumentIterator args, char spec, int width, int flags, int precision) {
            long l = args.nextInteger();
            String ls = LuaFormat.toString(l);
            String digits = l < 0L ? ls.substring(1) : ls;
            bld.append(Format.justified(width, flags, Format.sign(l >= 0L, flags) + Format.padded(precision, digits)));
        }

        private static void format_unsigned_integer(StringBuilder bld, ArgumentIterator args, int width, int flags, int precision) {
            long l = args.nextInteger();
            String digits = Format.longToUnsignedString(l);
            bld.append(Format.justified(width, flags, Format.padded(precision, digits)));
        }

        private static void format_octal_integer(StringBuilder bld, ArgumentIterator args, int width, int flags, int precision) {
            long l = args.nextInteger();
            String digits = Long.toOctalString(l);
            bld.append(Format.justified(width, flags, Format.altForm(l, flags, "0") + Format.padded(precision, digits)));
        }

        private static void format_hex_integer(StringBuilder bld, ArgumentIterator args, boolean uppercase, int width, int flags, int precision) {
            long l = args.nextInteger();
            String digits = Long.toHexString(l);
            String lowerCaseResult = Format.justified(width, flags, Format.altForm(l, flags, "0x") + Format.padded(precision, digits));
            bld.append(uppercase ? lowerCaseResult.toUpperCase() : lowerCaseResult);
        }

        private static void format_char(StringBuilder bld, ArgumentIterator args, int width, int flags) {
            bld.append(Format.justified(width, flags, Character.toString((char)args.nextInteger())));
        }

        private static void format_float(StringBuilder bld, ArgumentIterator args, char spec, int width, int flags, int precision) {
            double v = args.nextFloat();
            if (Double.isNaN(v) || Double.isInfinite(v)) {
                ByteString chars = Double.isNaN(v) ? LuaFormat.NAN : ByteString.of(Format.sign(v > 0.0, flags) + LuaFormat.INF);
                bld.append(Format.justified(width, flags, chars.toString()));
            } else {
                int p;
                StringBuilder fmtBld = new StringBuilder();
                fmtBld.append('%');
                if (Format.hasFlag(flags, 2)) {
                    fmtBld.append('-');
                }
                if (Format.hasFlag(flags, 4)) {
                    fmtBld.append('+');
                }
                if (Format.hasFlag(flags, 8)) {
                    fmtBld.append(' ');
                }
                if (Format.hasFlag(flags, 16)) {
                    fmtBld.append('0');
                }
                if (Format.hasFlag(flags, 32)) {
                    fmtBld.append('#');
                }
                if (width > 0) {
                    fmtBld.append(width);
                } else if (Format.hasFlag(flags, 16)) {
                    fmtBld.append('1');
                }
                if (precision > 0) {
                    fmtBld.append('.').append(precision);
                }
                fmtBld.append(spec);
                String formatted = String.format(fmtBld.toString(), v);
                if ((spec == 'a' || spec == 'A') && formatted.charAt(p = formatted.indexOf(spec == 'a' ? 112 : 80) + 1) != '-') {
                    formatted = formatted.substring(0, p) + '+' + formatted.substring(p);
                }
                bld.append(formatted);
            }
        }

        private void format_s(ExecutionContext context, String fmt, StringBuilder bld, ArgumentIterator args, int index, int width, int flags, int precision) throws ResolvedControlThrowable {
            String s;
            Object v = args.nextAny();
            ByteString stringValue = Conversions.stringValueOf(v);
            if (stringValue != null) {
                s = stringValue.toString();
            } else {
                Object metamethod = Metatables.getMetamethod(context, BasicLib.MT_TOSTRING, v);
                if (metamethod != null) {
                    try {
                        Dispatch.call(context, metamethod, v);
                    }
                    catch (UnresolvedControlThrowable ct) {
                        throw ct.resolve(this, new SuspendedState(fmt, bld.toString(), args, index, width, flags, precision));
                    }
                    Format.resume_s(context, bld, width, flags, precision);
                    return;
                }
                s = Conversions.toHumanReadableString(v).toString();
            }
            bld.append(Format.justified(width, flags, Format.trimmed(precision, s)));
        }

        private static void resume_s(ExecutionContext context, StringBuilder bld, int width, int flags, int precision) {
            Object o = context.getReturnBuffer().get0();
            ByteString sv = Conversions.stringValueOf(o);
            String s = sv != null ? sv.toString() : "";
            bld.append(Format.justified(width, flags, Format.trimmed(precision, s)));
        }

        private void format_q(StringBuilder bld, ArgumentIterator args) {
            String s;
            Object o = args.nextAny();
            if (o == null) {
                s = LuaFormat.NIL.toString();
            } else if (o instanceof Boolean) {
                s = LuaFormat.toString((Boolean)o);
            } else if (o instanceof String) {
                s = LuaFormat.escape((String)o);
            } else if (o instanceof ByteString) {
                s = LuaFormat.escape(((ByteString)o).toString());
            } else if (o instanceof Number) {
                s = Conversions.stringValueOf((Number)o).toString();
            } else {
                throw new BadArgumentException(args.position(), this.name(), "value has no literal form");
            }
            bld.append(s);
        }

        private int placeholder(ExecutionContext context, String fmt, int from, StringBuilder bld, ArgumentIterator args) throws ResolvedControlThrowable {
            char c;
            if (!args.hasNext()) {
                throw new BadArgumentException(args.size() + 1, this.name(), "no value");
            }
            int index = from;
            int flags = 0;
            boolean wasFlag = true;
            do {
                if (index >= fmt.length()) {
                    throw Format.invalidOptionException('\u0000');
                }
                c = fmt.charAt(index++);
                switch (c) {
                    case '-': {
                        flags = Format.setFlag(flags, 2);
                        break;
                    }
                    case '+': {
                        flags = Format.setFlag(flags, 4);
                        break;
                    }
                    case ' ': {
                        flags = Format.setFlag(flags, 8);
                        break;
                    }
                    case '0': {
                        flags = Format.setFlag(flags, 16);
                        break;
                    }
                    case '#': {
                        flags = Format.setFlag(flags, 32);
                        break;
                    }
                    default: {
                        --index;
                        wasFlag = false;
                    }
                }
            } while (wasFlag);
            int width = -1;
            boolean wasWidth = true;
            do {
                if (index >= fmt.length()) {
                    throw Format.invalidOptionException('\u0000');
                }
                c = fmt.charAt(index++);
                if (c >= '0' && c <= '9') {
                    if ((width = Math.max(0, width) * 10 + (c - 48)) < 100) continue;
                    throw new IllegalArgumentException("illegal format (width or precision too long)");
                }
                --index;
                wasWidth = false;
            } while (wasWidth);
            int precision = -1;
            if (index < fmt.length() && fmt.charAt(index) == '.') {
                ++index;
                precision = 0;
                boolean wasPrecision = true;
                do {
                    if (index >= fmt.length()) {
                        throw Format.invalidOptionException('\u0000');
                    }
                    c = fmt.charAt(index++);
                    if (c >= '0' && c <= '9') {
                        if ((precision = precision * 10 + (c - 48)) < 100) continue;
                        throw new IllegalArgumentException("illegal format (width or precision too long)");
                    }
                    --index;
                    wasPrecision = false;
                } while (wasPrecision);
            }
            char d = fmt.charAt(index++);
            switch (d) {
                case 'd': 
                case 'i': {
                    Format.format_signed_integer(bld, args, d, width, flags, precision);
                    break;
                }
                case 'u': {
                    Format.format_unsigned_integer(bld, args, width, flags, precision);
                    break;
                }
                case 'o': {
                    Format.format_octal_integer(bld, args, width, flags, precision);
                    break;
                }
                case 'X': 
                case 'x': {
                    Format.format_hex_integer(bld, args, d == 'X', width, flags, precision);
                    break;
                }
                case 'c': {
                    Format.format_char(bld, args, width, flags);
                    break;
                }
                case 'A': 
                case 'E': 
                case 'G': 
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    Format.format_float(bld, args, d, width, flags, precision);
                    break;
                }
                case 's': {
                    this.format_s(context, fmt, bld, args, index, width, flags, precision);
                    break;
                }
                case 'q': {
                    this.format_q(bld, args);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid option '" + Format.optionToString(d) + "' to 'format'");
                }
            }
            return index < fmt.length() ? index : -1;
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            String fmt = args.nextString().toString();
            StringBuilder bld = new StringBuilder();
            this.run(context, fmt, args, bld, 0);
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            SuspendedState ss = (SuspendedState)suspendedState;
            StringBuilder bld = new StringBuilder(ss.str);
            Format.resume_s(context, bld, ss.width, ss.flags, ss.precision);
            this.run(context, ss.fmt, ss.args, bld, ss.index);
        }

        private void run(ExecutionContext context, String fmt, ArgumentIterator args, StringBuilder bld, int idx) throws ResolvedControlThrowable {
            do {
                if ((idx = this.literal(fmt, idx, bld)) < 0) continue;
                idx = this.placeholder(context, fmt, idx, bld, args);
            } while (idx >= 0);
            context.getReturnBuffer().setTo(bld.toString());
        }

        private static class SuspendedState {
            public final String fmt;
            public final String str;
            public final ArgumentIterator args;
            public final int index;
            public final int width;
            public final int flags;
            public final int precision;

            public SuspendedState(String fmt, String str, ArgumentIterator args, int index, int width, int flags, int precision) {
                this.fmt = fmt;
                this.str = str;
                this.args = args;
                this.index = index;
                this.width = width;
                this.flags = flags;
                this.precision = precision;
            }
        }
    }

    static class Find
    extends AbstractLibFunction {
        Find() {
        }

        @Override
        protected String name() {
            return "find";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            String s = args.nextString().toString();
            String pattern = args.nextString().toString();
            int init = args.nextOptionalInt(1);
            boolean plain = args.nextOptionalBoolean(false);
            init = StringLib.lowerBound(init, s.length());
            if (plain) {
                int at = s.indexOf(pattern, init - 1);
                if (at >= 0) {
                    context.getReturnBuffer().setTo(at + 1, at + pattern.length());
                } else {
                    context.getReturnBuffer().setTo(null);
                }
            } else {
                StringPattern pat = StringPattern.fromString(pattern);
                StringPattern.Match m = pat.match(s, init - 1);
                if (m != null) {
                    ArrayList<Object> result = new ArrayList<Object>();
                    result.add(Long.valueOf(m.beginIndex() + 1));
                    result.add(Long.valueOf(m.endIndex()));
                    result.addAll(m.captures());
                    context.getReturnBuffer().setToContentsOf(result);
                } else {
                    context.getReturnBuffer().setTo(null);
                }
            }
        }
    }

    static class Dump
    extends AbstractLibFunction {
        Dump() {
        }

        @Override
        protected String name() {
            return "dump";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            LuaFunction f = args.nextFunction();
            boolean strip = args.hasNext() && args.nextBoolean();
            throw new IllegalOperationAttemptException("unable to dump given function");
        }
    }

    static class Char
    extends AbstractLibFunction {
        Char() {
        }

        @Override
        protected String name() {
            return "char";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            byte[] bytes = new byte[args.size()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)args.nextIntRange(0, 255);
            }
            ByteString s = ByteString.copyOf(bytes);
            context.getReturnBuffer().setTo(s);
        }
    }

    static class Byte
    extends AbstractLibFunction {
        Byte() {
        }

        @Override
        protected String name() {
            return "byte";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            ByteString s = args.nextString();
            int i = args.nextOptionalInt(1);
            int j = args.nextOptionalInt(i);
            int len = s.length();
            i = StringLib.lowerBound(i, len);
            j = StringLib.upperBound(j, len);
            ArrayList<Long> buf = new ArrayList<Long>();
            for (int idx = i; idx <= j; ++idx) {
                int c = s.byteAt(idx - 1) & 0xFF;
                buf.add(Long.valueOf(c));
            }
            context.getReturnBuffer().setToContentsOf(buf);
        }
    }
}

