/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib;

import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.classdump.luna.ByteString;
import org.classdump.luna.ByteStringBuilder;
import org.classdump.luna.Conversions;
import org.classdump.luna.LuaRuntimeException;
import org.classdump.luna.StateContext;
import org.classdump.luna.Table;
import org.classdump.luna.env.RuntimeEnvironment;
import org.classdump.luna.impl.UnimplementedFunction;
import org.classdump.luna.lib.AbstractLibFunction;
import org.classdump.luna.lib.ArgumentIterator;
import org.classdump.luna.lib.BasicLib;
import org.classdump.luna.lib.LoaderProvider;
import org.classdump.luna.load.ChunkLoader;
import org.classdump.luna.load.LoaderException;
import org.classdump.luna.runtime.Dispatch;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.runtime.LuaFunction;
import org.classdump.luna.runtime.ResolvedControlThrowable;
import org.classdump.luna.runtime.UnresolvedControlThrowable;
import org.classdump.luna.util.ByteIterator;

public final class ModuleLib {
    static final byte PATH_SEPARATOR = 59;
    static final byte PATH_TEMPLATE_PLACEHOLDER = 63;
    static final byte WIN_DIRECTORY_PLACEHOLDER = 33;
    static final byte LUAOPEN_IGNORE = 45;

    public static LuaFunction searchpath(FileSystem fileSystem) {
        return new SearchPath(fileSystem);
    }

    private ModuleLib() {
    }

    public static void installInto(StateContext context, Table env, RuntimeEnvironment runtimeEnvironment, ChunkLoader chunkLoader, ClassLoader classLoader) {
        ByteString path;
        ByteString config;
        Objects.requireNonNull(context);
        Objects.requireNonNull(env);
        FileSystem fileSystem = runtimeEnvironment != null ? runtimeEnvironment.fileSystem() : null;
        Table t = context.newTable();
        Table loaded = context.newTable();
        Table preload = context.newTable();
        Table searchers = context.newTable();
        Require require = new Require(t, loaded);
        if (fileSystem != null) {
            ByteStringBuilder builder = new ByteStringBuilder();
            builder.append(fileSystem.getSeparator()).append((byte)10);
            builder.append((byte)59).append((byte)10);
            builder.append((byte)63).append((byte)10);
            builder.append((byte)33).append((byte)10);
            builder.append((byte)45).append((byte)10);
            config = builder.toByteString();
        } else {
            config = null;
        }
        loaded.rawset("_G", (Object)env);
        loaded.rawset("package", (Object)t);
        if (runtimeEnvironment != null) {
            String envPath = runtimeEnvironment.getEnv("LUA_PATH_5_3");
            if (envPath == null) {
                envPath = runtimeEnvironment.getEnv("LUA_PATH");
            }
            path = ModuleLib.getPath(envPath, ModuleLib.defaultPath(runtimeEnvironment.fileSystem()));
        } else {
            path = null;
        }
        ModuleLib.addSearcher(searchers, new PreloadSearcher(preload));
        if (chunkLoader != null) {
            ModuleLib.addSearcher(searchers, new ChunkLoadPathSearcher(fileSystem, t, chunkLoader, env));
        }
        if (classLoader != null) {
            ModuleLib.addSearcher(searchers, new LoaderProviderServiceLoaderSearcher(runtimeEnvironment, env, classLoader));
        }
        t.rawset("config", config);
        t.rawset("loaded", (Object)loaded);
        t.rawset("loadlib", (Object)new UnimplementedFunction("package.loadlib"));
        t.rawset("preload", (Object)preload);
        t.rawset("searchers", (Object)searchers);
        if (fileSystem != null) {
            t.rawset("searchpath", (Object)ModuleLib.searchpath(fileSystem));
        }
        t.rawset("path", (Object)path);
        env.rawset("package", (Object)t);
        env.rawset("require", (Object)require);
    }

    static void addSearcher(Table searchers, LuaFunction fn) {
        searchers.rawset(searchers.rawlen() + 1L, (Object)fn);
    }

    static void addToLoaded(Table env, String modName, Object value) {
        Object loaded;
        Object pkg = env.rawget("package");
        if (pkg instanceof Table && (loaded = ((Table)pkg).rawget("loaded")) instanceof Table) {
            ((Table)loaded).rawset(modName, value);
        }
    }

    static void addToPreLoad(Table env, String modName, LuaFunction loader) {
        Object preload;
        Object pkg = env.rawget("package");
        if (pkg instanceof Table && (preload = ((Table)pkg).rawget("preload")) instanceof Table) {
            ((Table)preload).rawset(modName, (Object)loader);
        }
    }

    static void install(Table env, String modName, Object value) {
        env.rawset(modName, value);
        ModuleLib.addToLoaded(env, modName, value);
    }

    static Table searchers(Table libTable) {
        Object o = libTable.rawget("searchers");
        return o instanceof Table ? (Table)o : null;
    }

    static ByteString defaultPath(FileSystem fileSystem) {
        return ByteString.of("/usr/local/share/lua/5.3/?.lua;/usr/local/share/lua/5.3/?/init.lua;/usr/local/lib/lua/5.3/?.lua;/usr/local/lib/lua/5.3/?/init.lua;./?.lua;./?/init.lua");
    }

    static ByteString getPath(String envPath, ByteString defaultPath) {
        if (envPath != null) {
            return ByteString.of(envPath).replace(ByteString.of(";;"), defaultPath);
        }
        return defaultPath;
    }

    static class SearchPath
    extends AbstractLibFunction {
        private static final ByteString DEFAULT_SEP = ByteString.constOf(".");
        private final FileSystem fileSystem;
        private final ByteString defaultDirSeparator;

        SearchPath(FileSystem fileSystem) {
            this.fileSystem = Objects.requireNonNull(fileSystem);
            this.defaultDirSeparator = ByteString.of(fileSystem.getSeparator());
        }

        @Override
        protected String name() {
            return "searchpath";
        }

        static List<ByteString> getPaths(ByteString name, ByteString path, ByteString sep, ByteString rep) {
            ArrayList<ByteString> result = new ArrayList<ByteString>();
            name = name.replace(sep, rep);
            ByteStringBuilder builder = new ByteStringBuilder();
            ByteIterator it = path.byteIterator();
            block4: while (it.hasNext()) {
                byte b = it.nextByte();
                switch (b) {
                    case 63: {
                        builder.append(name);
                        continue block4;
                    }
                    case 59: {
                        result.add(builder.toByteString());
                        builder.setLength(0);
                        continue block4;
                    }
                }
                builder.append(b);
            }
            if (builder.length() > 0) {
                result.add(builder.toByteString());
            }
            return result;
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            ByteString name = args.nextString();
            ByteString path = args.nextString();
            ByteString sep = args.nextOptionalString(DEFAULT_SEP);
            ByteString rep = args.nextOptionalString(this.defaultDirSeparator);
            ByteStringBuilder msgBuilder = new ByteStringBuilder();
            for (ByteString s : SearchPath.getPaths(name, path, sep, rep)) {
                Path p = this.fileSystem.getPath(s.toString(), new String[0]);
                if (Files.isReadable(p)) {
                    context.getReturnBuffer().setTo(s);
                    return;
                }
                msgBuilder.append("\n\tno file '").append(s).append((byte)39);
            }
            context.getReturnBuffer().setTo(null, msgBuilder.toString());
        }
    }

    static class LoaderProviderServiceLoaderSearcher
    extends AbstractServiceLoaderSearcher<LoaderProvider> {
        private final RuntimeEnvironment runtimeEnvironment;
        private final Table env;

        public LoaderProviderServiceLoaderSearcher(RuntimeEnvironment runtimeEnvironment, Table env, ClassLoader classLoader) {
            super(LoaderProvider.class, classLoader);
            this.runtimeEnvironment = Objects.requireNonNull(runtimeEnvironment);
            this.env = Objects.requireNonNull(env);
        }

        @Override
        protected boolean matches(String modName, LoaderProvider service) {
            return service.name().equals(modName);
        }

        @Override
        protected LuaFunction getLoader(LoaderProvider service) {
            return service.newLoader(this.runtimeEnvironment, this.env);
        }
    }

    static abstract class AbstractServiceLoaderSearcher<T>
    extends AbstractLibFunction {
        private final Class<T> serviceClass;
        private final ServiceLoader<T> serviceLoader;

        protected AbstractServiceLoaderSearcher(Class<T> serviceClass, ClassLoader classLoader) {
            this.serviceClass = Objects.requireNonNull(serviceClass);
            this.serviceLoader = ServiceLoader.load(serviceClass, classLoader);
        }

        @Override
        protected String name() {
            return "(" + this.serviceClass.getName() + " ServiceLoader searcher)";
        }

        private LuaFunction findLoader(String modName) {
            try {
                for (T service : this.serviceLoader) {
                    LuaFunction loader;
                    if (!this.matches(modName, service) || (loader = this.getLoader(service)) == null) continue;
                    return loader;
                }
            }
            catch (ServiceConfigurationError error) {
                throw new LuaRuntimeException(error);
            }
            return null;
        }

        protected abstract boolean matches(String var1, T var2);

        protected abstract LuaFunction getLoader(T var1);

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            ByteString modName = args.nextString();
            LuaFunction loader = this.findLoader(modName.toString());
            if (loader != null) {
                context.getReturnBuffer().setTo(loader);
            } else {
                String error = "\n\tno " + this.serviceClass.getName() + " for '" + modName + "'";
                context.getReturnBuffer().setTo(error);
            }
        }
    }

    static class ChunkLoadPathSearcher
    extends AbstractLibFunction {
        private final Table libTable;
        private final FileSystem fileSystem;
        private final ChunkLoader loader;
        private final Object env;

        ChunkLoadPathSearcher(FileSystem fileSystem, Table libTable, ChunkLoader loader, Object env) {
            this.fileSystem = Objects.requireNonNull(fileSystem);
            this.libTable = Objects.requireNonNull(libTable);
            this.loader = Objects.requireNonNull(loader);
            this.env = env;
        }

        @Override
        protected String name() {
            return "(path searcher)";
        }

        private LuaFunction loaderForPath(ByteString path) throws LoaderException {
            return BasicLib.loadTextChunkFromFile(this.fileSystem, this.loader, path.toString(), BasicLib.Load.DEFAULT_MODE, this.env);
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            ByteString modName = args.nextString();
            ByteString path = Conversions.stringValueOf(this.libTable.rawget("path"));
            if (path == null) {
                throw new IllegalStateException("'package.path' must be a string");
            }
            List<ByteString> paths = SearchPath.getPaths(modName, path, SearchPath.DEFAULT_SEP, ByteString.of(this.fileSystem.getSeparator()));
            ByteStringBuilder msgBuilder = new ByteStringBuilder();
            for (ByteString s : paths) {
                Path p = this.fileSystem.getPath(s.toString(), new String[0]);
                if (Files.isReadable(p)) {
                    LuaFunction fn;
                    try {
                        fn = this.loaderForPath(s);
                    }
                    catch (LoaderException ex) {
                        throw new LuaRuntimeException((Object)("error loading module '" + modName + "' from file '" + s + "'\n\t" + ex.getLuaStyleErrorMessage()));
                    }
                    context.getReturnBuffer().setTo(fn, s);
                    return;
                }
                msgBuilder.append("\n\tno file '").append(s).append((byte)39);
            }
            context.getReturnBuffer().setTo(msgBuilder.toByteString());
        }
    }

    static class PreloadSearcher
    extends AbstractLibFunction {
        private final Table preload;

        PreloadSearcher(Table preload) {
            this.preload = Objects.requireNonNull(preload);
        }

        @Override
        protected String name() {
            return "(preload searcher)";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            ByteString modName = args.nextString();
            Object entry = this.preload.rawget(modName);
            if (entry != null) {
                context.getReturnBuffer().setTo(entry);
            } else {
                String error = "\n\tno field package.preload['" + modName + "']";
                context.getReturnBuffer().setTo(error);
            }
        }
    }

    static class Require
    extends AbstractLibFunction {
        private final Table libTable;
        private final Table loaded;

        public Require(Table libTable, Table loaded) {
            this.libTable = Objects.requireNonNull(libTable);
            this.loaded = Objects.requireNonNull(loaded);
        }

        @Override
        protected String name() {
            return "require";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            ByteString modName = args.nextString();
            Object mod = this.loaded.rawget(modName);
            if (mod != null) {
                context.getReturnBuffer().setTo(mod);
            } else {
                Table searchers = ModuleLib.searchers(this.libTable);
                if (searchers == null) {
                    throw new IllegalStateException("'package.searchers' must be a table");
                }
                this.search(context, 0, ByteString.empty(), modName, searchers, 1L);
            }
        }

        private void search(ExecutionContext context, int state, ByteString error, ByteString modName, Table searchers, long idx) throws ResolvedControlThrowable {
            Object origin;
            LuaFunction loader;
            block10: {
                try {
                    while (true) {
                        switch (state) {
                            case 0: {
                                Object o = searchers.rawget(idx++);
                                if (o == null) {
                                    throw new LuaRuntimeException((Object)("module '" + modName + "' not found:" + error));
                                }
                                state = 1;
                                Dispatch.call(context, o, modName);
                            }
                            case 1: {
                                Object result = context.getReturnBuffer().get0();
                                if (result instanceof LuaFunction) {
                                    loader = (LuaFunction)result;
                                    origin = context.getReturnBuffer().get1();
                                    break block10;
                                }
                                ByteString s = Conversions.stringValueOf(result);
                                if (s != null) {
                                    error = error.concat(s);
                                }
                                state = 0;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Invalid state: " + state);
                            }
                        }
                    }
                }
                catch (UnresolvedControlThrowable ct) {
                    throw ct.resolve(this, new Require_SuspendedState(state, error, modName, searchers, idx));
                }
            }
            this.load(context, modName, loader, origin);
        }

        private void load(ExecutionContext context, ByteString modName, LuaFunction loader, Object origin) throws ResolvedControlThrowable {
            try {
                Dispatch.call(context, loader, modName, origin);
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, modName);
            }
            this.resumeLoad(context, modName);
        }

        private void resumeLoad(ExecutionContext context, ByteString modName) {
            Object loadResult = context.getReturnBuffer().get0();
            Object requireResult = loadResult != null ? loadResult : Boolean.valueOf(true);
            this.loaded.rawset(modName, requireResult);
            context.getReturnBuffer().setTo(requireResult);
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            if (suspendedState instanceof Require_SuspendedState) {
                Require_SuspendedState ss = (Require_SuspendedState)suspendedState;
                this.search(context, ss.state, ss.error, ss.modName, ss.searchers, ss.idx);
            } else {
                this.resumeLoad(context, (ByteString)suspendedState);
            }
        }

        private static class Require_SuspendedState {
            private final int state;
            private final ByteString error;
            private final ByteString modName;
            private final Table searchers;
            private final long idx;

            private Require_SuspendedState(int state, ByteString error, ByteString modName, Table searchers, long idx) {
                this.state = state;
                this.error = error;
                this.modName = modName;
                this.searchers = searchers;
                this.idx = idx;
            }
        }
    }
}

