/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib;

import java.io.IOException;
import org.classdump.luna.ByteString;
import org.classdump.luna.Table;
import org.classdump.luna.impl.DefaultUserdata;
import org.classdump.luna.lib.AbstractLibFunction;
import org.classdump.luna.lib.ArgumentIterator;
import org.classdump.luna.lib.BadArgumentException;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.runtime.ResolvedControlThrowable;

public abstract class IoFile
extends DefaultUserdata {
    protected IoFile(Table metatable, Object userValue) {
        super(metatable, userValue);
    }

    static String typeName() {
        return "FILE*";
    }

    public String toString() {
        return "file (0x" + Integer.toHexString(this.hashCode()) + ")";
    }

    public abstract boolean isClosed();

    public abstract void close() throws IOException;

    public abstract void flush() throws IOException;

    public abstract void write(ByteString var1) throws IOException;

    public abstract long seek(Whence var1, long var2) throws IOException;

    static class ToString
    extends AbstractLibFunction {
        ToString() {
        }

        @Override
        protected String name() {
            return "tostring";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            IoFile f = args.nextUserdata(IoFile.typeName(), IoFile.class);
            context.getReturnBuffer().setTo(f.toString());
        }
    }

    static class Write
    extends AbstractLibFunction {
        Write() {
        }

        @Override
        protected String name() {
            return "write";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            IoFile f = args.nextUserdata(IoFile.typeName(), IoFile.class);
            while (args.hasNext()) {
                ByteString s = args.nextString();
                try {
                    f.write(s);
                }
                catch (Exception ex) {
                    context.getReturnBuffer().setTo(null, ex.getMessage());
                    return;
                }
            }
            context.getReturnBuffer().setTo(f);
        }
    }

    static class SetVBuf
    extends AbstractLibFunction {
        SetVBuf() {
        }

        @Override
        protected String name() {
            return "setvbuf";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            throw new UnsupportedOperationException();
        }
    }

    static class Seek
    extends AbstractLibFunction {
        Seek() {
        }

        @Override
        protected String name() {
            return "seek";
        }

        private static Whence stringToWhence(String s) {
            switch (s) {
                case "set": {
                    return Whence.BEGINNING;
                }
                case "cur": {
                    return Whence.CURRENT_POSITION;
                }
                case "end": {
                    return Whence.END;
                }
            }
            return null;
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            long position;
            long offset;
            Whence whence;
            IoFile file = args.nextUserdata(IoFile.typeName(), IoFile.class);
            if (args.hasNext()) {
                String s = args.nextString().toString();
                Whence w = Seek.stringToWhence(s);
                if (w == null) {
                    throw new BadArgumentException(1, this.name(), "invalid option '" + s + "'");
                }
                whence = w;
                offset = args.nextOptionalInteger(0L);
            } else {
                whence = Whence.CURRENT_POSITION;
                offset = 0L;
            }
            try {
                position = file.seek(whence, offset);
            }
            catch (Exception ex) {
                context.getReturnBuffer().setTo(null, ex.getMessage());
                return;
            }
            context.getReturnBuffer().setTo(position);
        }
    }

    static class Read
    extends AbstractLibFunction {
        Read() {
        }

        @Override
        protected String name() {
            return "read";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            IoFile f = args.nextUserdata(IoFile.typeName(), IoFile.class);
            throw new UnsupportedOperationException();
        }
    }

    static class Lines
    extends AbstractLibFunction {
        Lines() {
        }

        @Override
        protected String name() {
            return "lines";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            throw new UnsupportedOperationException();
        }
    }

    static class Flush
    extends AbstractLibFunction {
        Flush() {
        }

        @Override
        protected String name() {
            return "flush";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            IoFile f = args.nextUserdata(IoFile.typeName(), IoFile.class);
            try {
                f.flush();
            }
            catch (Exception ex) {
                context.getReturnBuffer().setTo(null, ex.getMessage());
                return;
            }
            context.getReturnBuffer().setTo(true);
        }
    }

    static class Close
    extends AbstractLibFunction {
        Close() {
        }

        @Override
        protected String name() {
            return "close";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            IoFile f = args.nextUserdata(IoFile.typeName(), IoFile.class);
            try {
                f.close();
            }
            catch (Exception ex) {
                context.getReturnBuffer().setTo(null, ex.getMessage());
                return;
            }
            context.getReturnBuffer().setTo(true);
        }
    }

    public static enum Whence {
        BEGINNING,
        CURRENT_POSITION,
        END;

    }
}

