/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.impl;

import java.util.Arrays;
import java.util.Collection;
import org.classdump.luna.runtime.ReturnBuffer;

class SimpleReturnBuffer
implements ReturnBuffer {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Object[] values = EMPTY_ARRAY;
    private Object tailCallTarget = null;
    private boolean tailCall = false;

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public boolean isCall() {
        return this.tailCall;
    }

    @Override
    public Object getCallTarget() {
        if (!this.tailCall) {
            throw new IllegalStateException("Not a tail call");
        }
        return this.tailCallTarget;
    }

    private void update(Object[] values, boolean tailCall, Object tailCallTarget) {
        this.values = values;
        this.tailCall = tailCall;
        this.tailCallTarget = tailCallTarget;
    }

    private void setReturn(Object[] values) {
        this.update(values, false, null);
    }

    private void setToTailCall(Object target, Object[] args) {
        this.update(args, true, target);
    }

    @Override
    public void setTo() {
        this.setReturn(EMPTY_ARRAY);
    }

    @Override
    public void setTo(Object a) {
        this.setReturn(new Object[]{a});
    }

    @Override
    public void setTo(Object a, Object b) {
        this.setReturn(new Object[]{a, b});
    }

    @Override
    public void setTo(Object a, Object b, Object c) {
        this.setReturn(new Object[]{a, b, c});
    }

    @Override
    public void setTo(Object a, Object b, Object c, Object d) {
        this.setReturn(new Object[]{a, b, c, d});
    }

    @Override
    public void setTo(Object a, Object b, Object c, Object d, Object e) {
        this.setReturn(new Object[]{a, b, c, d, e});
    }

    @Override
    public void setToContentsOf(Object[] a) {
        this.setReturn(Arrays.copyOf(a, a.length));
    }

    @Override
    public void setToContentsOf(Collection<?> collection) {
        this.setReturn(collection.toArray());
    }

    @Override
    public void setToCall(Object target) {
        this.setToTailCall(target, EMPTY_ARRAY);
    }

    @Override
    public void setToCall(Object target, Object arg1) {
        this.setToTailCall(target, new Object[]{arg1});
    }

    @Override
    public void setToCall(Object target, Object arg1, Object arg2) {
        this.setToTailCall(target, new Object[]{arg1, arg2});
    }

    @Override
    public void setToCall(Object target, Object arg1, Object arg2, Object arg3) {
        this.setToTailCall(target, new Object[]{arg1, arg2, arg3});
    }

    @Override
    public void setToCall(Object target, Object arg1, Object arg2, Object arg3, Object arg4) {
        this.setToTailCall(target, new Object[]{arg1, arg2, arg3, arg4});
    }

    @Override
    public void setToCall(Object target, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        this.setToTailCall(target, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    @Override
    public void setToCallWithContentsOf(Object target, Object[] args) {
        this.setToTailCall(target, Arrays.copyOf(args, args.length));
    }

    @Override
    public void setToCallWithContentsOf(Object target, Collection<?> args) {
        this.setToTailCall(target, args.toArray());
    }

    @Override
    public Object[] getAsArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    public Object get(int idx) {
        return idx < this.values.length ? this.values[idx] : null;
    }

    @Override
    public Object get0() {
        return this.get(0);
    }

    @Override
    public Object get1() {
        return this.get(1);
    }

    @Override
    public Object get2() {
        return this.get(2);
    }

    @Override
    public Object get3() {
        return this.get(3);
    }

    @Override
    public Object get4() {
        return this.get(4);
    }
}

