/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.impl;

import java.util.Collection;
import java.util.Objects;
import org.classdump.luna.Conversions;
import org.classdump.luna.impl.AbstractMappedCollectionView;
import org.classdump.luna.impl.MappedDelegatingReturnBuffer;
import org.classdump.luna.impl.PairCachingReturnBuffer;
import org.classdump.luna.runtime.ReturnBuffer;
import org.classdump.luna.runtime.ReturnBufferFactory;

public final class ReturnBuffers {
    private static final ReturnBufferFactory DEFAULT_FACTORY_INSTANCE = new ReturnBufferFactory(){

        @Override
        public ReturnBuffer newInstance() {
            return ReturnBuffers.newDefaultReturnBuffer();
        }
    };
    private static final Canonicaliser CANONICALISER = new Canonicaliser();

    private ReturnBuffers() {
    }

    public static ReturnBuffer newDefaultReturnBuffer() {
        return new PairCachingReturnBuffer();
    }

    public static ReturnBufferFactory defaultFactory() {
        return DEFAULT_FACTORY_INSTANCE;
    }

    static ReturnBuffer mapped(ReturnBuffer buffer, ReadMapper reads, WriteMapper writes) {
        Objects.requireNonNull(buffer);
        if (reads == null && writes == null) {
            return buffer;
        }
        return new MappedDelegatingReturnBuffer(buffer, reads, writes);
    }

    static ReturnBufferFactory mapping(final ReturnBufferFactory factory, final ReadMapper reads, final WriteMapper writes) {
        Objects.requireNonNull(factory);
        return new ReturnBufferFactory(){

            @Override
            public ReturnBuffer newInstance() {
                return ReturnBuffers.mapped(factory.newInstance(), reads, writes);
            }
        };
    }

    static ReturnBufferFactory canonical(ReturnBufferFactory factory, boolean reads, boolean writes) {
        return ReturnBuffers.mapping(factory, reads ? CANONICALISER : null, writes ? CANONICALISER : null);
    }

    static class Canonicaliser
    extends AbstractMapper {
        Canonicaliser() {
        }

        @Override
        protected Object map(Object object) {
            return Conversions.canonicalRepresentationOf(object);
        }
    }

    static abstract class AbstractMapper
    implements ReadMapper,
    WriteMapper {
        AbstractMapper() {
        }

        protected abstract Object map(Object var1);

        private Object[] mapArray(Object[] array, Object[] copy) {
            for (int i = 0; i < copy.length; ++i) {
                copy[i] = this.map(array[i]);
            }
            return copy;
        }

        public Collection<Object> mapCollection(Collection<?> collection) {
            return new AbstractMappedCollectionView<Object>(collection){

                @Override
                protected Object map(Object object) {
                    return this.map(object);
                }
            };
        }

        @Override
        public Object mapReadValue(Object object) {
            return this.map(object);
        }

        @Override
        public Object[] mapReadArray(Object[] array) {
            return this.mapArray(array, array);
        }

        @Override
        public Object mapWrittenValue(Object object) {
            return this.map(object);
        }

        @Override
        public Object[] mapWrittenArray(Object[] array) {
            return this.mapArray(array, new Object[array.length]);
        }

        @Override
        public Collection<?> mapWrittenCollection(Collection<?> array) {
            return this.mapCollection(array);
        }
    }

    static interface WriteMapper {
        public Object mapWrittenValue(Object var1);

        public Object[] mapWrittenArray(Object[] var1);

        public Collection<?> mapWrittenCollection(Collection<?> var1);
    }

    static interface ReadMapper {
        public Object mapReadValue(Object var1);

        public Object[] mapReadArray(Object[] var1);
    }
}

