/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.util;

import java.io.PrintWriter;
import java.util.Objects;
import org.classdump.luna.LuaFormat;
import org.classdump.luna.compiler.ir.BinOp;
import org.classdump.luna.compiler.ir.Branch;
import org.classdump.luna.compiler.ir.CPUWithdraw;
import org.classdump.luna.compiler.ir.Call;
import org.classdump.luna.compiler.ir.Closure;
import org.classdump.luna.compiler.ir.CodeVisitor;
import org.classdump.luna.compiler.ir.Jmp;
import org.classdump.luna.compiler.ir.Label;
import org.classdump.luna.compiler.ir.Line;
import org.classdump.luna.compiler.ir.LoadConst;
import org.classdump.luna.compiler.ir.MultiGet;
import org.classdump.luna.compiler.ir.PhiLoad;
import org.classdump.luna.compiler.ir.PhiStore;
import org.classdump.luna.compiler.ir.Ret;
import org.classdump.luna.compiler.ir.TCall;
import org.classdump.luna.compiler.ir.TabGet;
import org.classdump.luna.compiler.ir.TabNew;
import org.classdump.luna.compiler.ir.TabRawAppendMulti;
import org.classdump.luna.compiler.ir.TabRawSet;
import org.classdump.luna.compiler.ir.TabRawSetInt;
import org.classdump.luna.compiler.ir.TabSet;
import org.classdump.luna.compiler.ir.ToNext;
import org.classdump.luna.compiler.ir.ToNumber;
import org.classdump.luna.compiler.ir.UnOp;
import org.classdump.luna.compiler.ir.UpLoad;
import org.classdump.luna.compiler.ir.UpStore;
import org.classdump.luna.compiler.ir.VList;
import org.classdump.luna.compiler.ir.VarInit;
import org.classdump.luna.compiler.ir.VarLoad;
import org.classdump.luna.compiler.ir.VarStore;
import org.classdump.luna.compiler.ir.Vararg;
import org.classdump.luna.parser.util.Util;

public class IRPrinterVisitor
extends CodeVisitor {
    private final PrintWriter ps;

    public IRPrinterVisitor(PrintWriter ps) {
        this.ps = Objects.requireNonNull(ps);
    }

    @Override
    public void visit(LoadConst.Nil node) {
        this.ps.println("\tldnil " + node.dest());
    }

    @Override
    public void visit(LoadConst.Bool node) {
        this.ps.println("\tldbool " + node.dest() + " " + node.value());
    }

    @Override
    public void visit(LoadConst.Int node) {
        this.ps.println("\tldint " + node.dest() + " " + node.value());
    }

    @Override
    public void visit(LoadConst.Flt node) {
        this.ps.println("\tldflt " + node.dest() + " " + node.value());
    }

    @Override
    public void visit(LoadConst.Str node) {
        this.ps.println("\tldstr " + node.dest() + " " + LuaFormat.escape(node.value()));
    }

    @Override
    public void visit(BinOp node) {
        this.ps.println("\t" + node.op().toString().toLowerCase() + " " + node.dest() + " " + node.left() + " " + node.right());
    }

    @Override
    public void visit(UnOp node) {
        this.ps.println("\t" + node.op().toString().toLowerCase() + " " + node.dest() + " " + node.arg());
    }

    @Override
    public void visit(TabNew node) {
        this.ps.println("\ttabnew " + node.dest() + " " + node.array() + " " + node.hash());
    }

    @Override
    public void visit(TabGet node) {
        this.ps.println("\ttabget " + node.dest() + " " + node.obj() + " " + node.key());
    }

    @Override
    public void visit(TabSet node) {
        this.ps.println("\ttabset " + node.obj() + " " + node.key() + " " + node.value());
    }

    @Override
    public void visit(TabRawSet node) {
        this.ps.println("\ttabrawset " + node.obj() + " " + node.key() + " " + node.value());
    }

    @Override
    public void visit(TabRawSetInt node) {
        this.ps.println("\ttabrawsetint " + node.obj() + " " + node.idx() + " " + node.value());
    }

    @Override
    public void visit(TabRawAppendMulti node) {
        this.ps.println("\ttabrawappendstack " + node.obj() + " " + node.src() + " " + node.firstIdx());
    }

    @Override
    public void visit(VarInit node) {
        this.ps.println("\tvarinit " + node.var() + " " + node.src());
    }

    @Override
    public void visit(VarLoad node) {
        this.ps.println("\tvarload " + node.dest() + " " + node.var());
    }

    @Override
    public void visit(VarStore node) {
        this.ps.println("\tvarstore " + node.var() + " " + node.src());
    }

    @Override
    public void visit(UpLoad node) {
        this.ps.println("\tupload " + node.dest() + " " + node.upval());
    }

    @Override
    public void visit(UpStore node) {
        this.ps.println("\tupstore " + node.upval() + " " + node.src());
    }

    @Override
    public void visit(Vararg node) {
        this.ps.println("\tvararg " + node.dest());
    }

    private static String vlistToString(VList vl) {
        return "(" + (vl.isMulti() ? "multi" : "fixed") + " [" + Util.listToString(vl.addrs(), " ") + "]" + (vl.suffix() != null ? " " + vl.suffix() : "") + ")";
    }

    @Override
    public void visit(Ret node) {
        this.ps.println("\tret " + IRPrinterVisitor.vlistToString(node.args()));
    }

    @Override
    public void visit(Call node) {
        this.ps.println("\tcall " + node.dest() + " " + node.fn() + " " + IRPrinterVisitor.vlistToString(node.args()));
    }

    @Override
    public void visit(TCall node) {
        this.ps.println("\ttcall " + node.target() + " " + IRPrinterVisitor.vlistToString(node.args()));
    }

    @Override
    public void visit(MultiGet node) {
        this.ps.println("\tstackget " + node.dest() + " " + node.src() + " " + node.idx());
    }

    @Override
    public void visit(PhiStore node) {
        this.ps.println("\tphistore " + node.dest() + " " + node.src());
    }

    @Override
    public void visit(PhiLoad node) {
        this.ps.println("\tphiload " + node.dest() + " " + node.src());
    }

    @Override
    public void visit(Label node) {
        this.ps.println(node + ":");
    }

    @Override
    public void visit(Jmp node) {
        this.ps.println("\tjmp " + node.jmpDest());
    }

    @Override
    public void visit(Branch node) {
        this.ps.print("\tif (");
        node.condition().accept(this);
        this.ps.println(") " + node.jmpDest());
        this.ps.println("\t; else fall through to " + node.next());
    }

    @Override
    public void visit(Branch.Condition.Nil cond) {
        this.ps.print("nil " + cond.addr());
    }

    @Override
    public void visit(Branch.Condition.Bool cond) {
        this.ps.print(cond.expected() + " " + cond.addr());
    }

    @Override
    public void visit(Branch.Condition.NumLoopEnd cond) {
        this.ps.print("loopend " + cond.var() + " " + cond.limit() + " " + cond.step());
    }

    @Override
    public void visit(Closure node) {
        this.ps.println("\tclosure " + node.dest() + " " + node.id() + " [" + Util.listToString(node.args(), " ") + "]");
    }

    @Override
    public void visit(ToNumber node) {
        this.ps.println("\ttonumber " + node.dest() + " " + node.src() + (node.desc() != null ? " (" + node.desc() + ")" : ""));
    }

    @Override
    public void visit(ToNext node) {
        this.ps.println("\t; fall through to " + node.label());
    }

    @Override
    public void visit(CPUWithdraw node) {
        this.ps.println("\tcpu " + node.cost());
    }

    @Override
    public void visit(Line node) {
        this.ps.println("\t; line " + node.lineNumber());
    }
}

