/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.tf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.classdump.luna.compiler.ir.BasicBlock;
import org.classdump.luna.compiler.ir.BlockTermNode;
import org.classdump.luna.compiler.ir.BodyNode;
import org.classdump.luna.compiler.ir.Code;
import org.classdump.luna.compiler.ir.CodeVisitor;
import org.classdump.luna.compiler.ir.IRVisitor;
import org.classdump.luna.compiler.ir.Label;

class CodeTransformerVisitor
extends CodeVisitor {
    private final List<BasicBlock> basicBlocks = new ArrayList<BasicBlock>();
    private Label label;
    private List<BodyNode> body;
    private BlockTermNode end;

    public CodeTransformerVisitor(IRVisitor visitor) {
        super(visitor);
    }

    public CodeTransformerVisitor() {
        this(null);
    }

    public Code result() {
        return Code.of(this.basicBlocks);
    }

    @Override
    public void visit(Code code) {
        this.basicBlocks.clear();
        super.visit(code);
    }

    @Override
    public void visit(BasicBlock block) {
        this.label = block.label();
        this.body = new ArrayList<BodyNode>(block.body());
        this.end = block.end();
        BasicBlock bb = block;
        try {
            this.preVisit(block);
            super.visit(block);
            this.postVisit(block);
            bb = new BasicBlock(this.label, Collections.unmodifiableList(this.body), this.end);
        }
        finally {
            this.label = null;
            this.body = null;
            this.end = null;
        }
        this.basicBlocks.add(block.equals(bb) ? block : bb);
    }

    protected Label currentLabel() {
        return this.label;
    }

    protected void setLabel(Label l) {
        Objects.requireNonNull(l);
        this.label = l;
    }

    protected List<BodyNode> currentBody() {
        return this.body;
    }

    protected BlockTermNode currentEnd() {
        return this.end;
    }

    protected void setEnd(BlockTermNode node) {
        Objects.requireNonNull(node);
        this.end = node;
    }

    protected void preVisit(BasicBlock block) {
    }

    protected void postVisit(BasicBlock block) {
    }
}

