/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.tf;

import java.util.Objects;
import org.classdump.luna.compiler.analysis.TypeInfo;
import org.classdump.luna.compiler.analysis.types.LuaTypes;
import org.classdump.luna.compiler.analysis.types.Type;
import org.classdump.luna.compiler.ir.Branch;
import org.classdump.luna.compiler.ir.Jmp;
import org.classdump.luna.compiler.ir.ToNext;
import org.classdump.luna.compiler.tf.CodeTransformerVisitor;

class BranchInlinerVisitor
extends CodeTransformerVisitor {
    private final TypeInfo types;
    private Boolean inline;

    public BranchInlinerVisitor(TypeInfo types) {
        this.types = Objects.requireNonNull(types);
    }

    @Override
    public void visit(Branch branch) {
        try {
            this.inline = null;
            branch.condition().accept(this);
            if (this.inline != null) {
                if (this.inline.booleanValue()) {
                    this.setEnd(new Jmp(branch.jmpDest()));
                } else {
                    this.setEnd(new ToNext(branch.next()));
                }
            }
        }
        finally {
            this.inline = null;
        }
    }

    @Override
    public void visit(Branch.Condition.Nil cond) {
        Type t = this.types.typeOf(cond.addr());
        this.inline = t.isSubtypeOf(LuaTypes.NIL) ? Boolean.TRUE : (t.isSubtypeOf(LuaTypes.ANY) && !t.equals(LuaTypes.ANY) ? Boolean.FALSE : null);
    }

    @Override
    public void visit(Branch.Condition.Bool cond) {
        Type t = this.types.typeOf(cond.addr());
        this.inline = t.isSubtypeOf(LuaTypes.NIL) ? Boolean.valueOf(!cond.expected()) : (t.isSubtypeOf(LuaTypes.ANY) && !t.equals(LuaTypes.ANY) && !t.isSubtypeOf(LuaTypes.BOOLEAN) ? Boolean.valueOf(cond.expected()) : null);
    }

    @Override
    public void visit(Branch.Condition.NumLoopEnd cond) {
        this.inline = null;
    }
}

