/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.gen.asm;

import java.util.List;
import java.util.Objects;
import org.classdump.luna.compiler.gen.asm.ASMBytecodeEmitter;
import org.classdump.luna.compiler.gen.asm.RunMethod;
import org.classdump.luna.compiler.gen.asm.helpers.ASMUtils;
import org.classdump.luna.impl.DefaultSavedState;
import org.classdump.luna.impl.NonsuspendableFunctionException;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.shaded.org.objectweb.asm.Type;
import org.classdump.luna.shaded.org.objectweb.asm.tree.InsnList;
import org.classdump.luna.shaded.org.objectweb.asm.tree.InsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.LabelNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.LocalVariableNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.MethodNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.TypeInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.VarInsnNode;

class ResumeMethod {
    private final ASMBytecodeEmitter context;
    private final RunMethod runMethod;

    public ResumeMethod(ASMBytecodeEmitter context, RunMethod runMethod) {
        this.context = Objects.requireNonNull(context);
        this.runMethod = Objects.requireNonNull(runMethod);
    }

    public MethodNode methodNode() {
        MethodNode node = new MethodNode(1, "resume", Type.getMethodType(Type.VOID_TYPE, Type.getType(ExecutionContext.class), Type.getType(Object.class)).getDescriptor(), null, this.runMethod.throwsExceptions());
        if (this.runMethod.isResumable()) {
            InsnList il = node.instructions;
            List locals = node.localVariables;
            LabelNode begin = new LabelNode();
            LabelNode vars = new LabelNode();
            LabelNode end = new LabelNode();
            il.add(begin);
            il.add(new VarInsnNode(25, 2));
            il.add(new TypeInsnNode(192, Type.getInternalName(DefaultSavedState.class)));
            il.add(vars);
            il.add(new VarInsnNode(58, 3));
            il.add(new VarInsnNode(25, 0));
            il.add(new VarInsnNode(25, 1));
            il.add(new VarInsnNode(25, 3));
            il.add(new MethodInsnNode(182, Type.getInternalName(DefaultSavedState.class), "resumptionPoint", Type.getMethodDescriptor(Type.INT_TYPE, new Type[0]), false));
            if (this.context.isVararg() || this.runMethod.numOfRegisters() > 0) {
                il.add(new VarInsnNode(25, 3));
                il.add(new MethodInsnNode(182, Type.getInternalName(DefaultSavedState.class), "registers", Type.getMethodDescriptor(ASMUtils.arrayTypeFor(Object.class), new Type[0]), false));
                int numRegs = this.runMethod.numOfRegisters() + (this.context.isVararg() ? 1 : 0);
                for (int i = 0; i < numRegs; ++i) {
                    if (i + 1 < numRegs) {
                        il.add(new InsnNode(89));
                    }
                    il.add(ASMUtils.loadInt(i));
                    il.add(new InsnNode(50));
                    if (i == 0 && this.context.isVararg()) {
                        il.add(new TypeInsnNode(192, ASMUtils.arrayTypeFor(Object.class).getInternalName()));
                    }
                    if (i + 1 >= numRegs) continue;
                    il.add(new InsnNode(95));
                }
            }
            il.add(this.runMethod.methodInvokeInsn());
            il.add(new InsnNode(177));
            il.add(end);
            locals.add(new LocalVariableNode("this", this.context.thisClassType().getDescriptor(), null, begin, end, 0));
            locals.add(new LocalVariableNode("context", Type.getDescriptor(ExecutionContext.class), null, begin, end, 1));
            locals.add(new LocalVariableNode("suspendedState", this.context.savedStateClassType().getDescriptor(), null, begin, end, 2));
            locals.add(new LocalVariableNode("ss", Type.getDescriptor(DefaultSavedState.class), null, vars, end, 3));
            node.maxStack = 3 + (this.runMethod.numOfRegisters() > 0 ? 3 : 0);
            node.maxLocals = 5;
        } else {
            InsnList il = node.instructions;
            List locals = node.localVariables;
            LabelNode begin = new LabelNode();
            LabelNode end = new LabelNode();
            il.add(begin);
            il.add(new TypeInsnNode(187, Type.getInternalName(NonsuspendableFunctionException.class)));
            il.add(new InsnNode(89));
            il.add(ASMUtils.ctor(NonsuspendableFunctionException.class, new Class[0]));
            il.add(new InsnNode(191));
            il.add(end);
            locals.add(new LocalVariableNode("this", this.context.thisClassType().getDescriptor(), null, begin, end, 0));
            locals.add(new LocalVariableNode("context", Type.getDescriptor(ExecutionContext.class), null, begin, end, 1));
            locals.add(new LocalVariableNode("suspendedState", this.context.savedStateClassType().getDescriptor(), null, begin, end, 2));
            node.maxStack = 2;
            node.maxLocals = 3;
        }
        return node;
    }
}

