/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.gen.asm;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.classdump.luna.Variable;
import org.classdump.luna.compiler.gen.asm.ASMBytecodeEmitter;
import org.classdump.luna.compiler.gen.asm.RunMethod;
import org.classdump.luna.compiler.gen.asm.helpers.ASMUtils;
import org.classdump.luna.compiler.gen.asm.helpers.VariableMethods;
import org.classdump.luna.compiler.ir.Var;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.shaded.org.objectweb.asm.Opcodes;
import org.classdump.luna.shaded.org.objectweb.asm.Type;
import org.classdump.luna.shaded.org.objectweb.asm.tree.FrameNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.InsnList;
import org.classdump.luna.shaded.org.objectweb.asm.tree.InsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.JumpInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.LabelNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.LocalVariableNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.MethodNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.TypeInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.VarInsnNode;

class InvokeMethod {
    private final ASMBytecodeEmitter context;
    private final RunMethod runMethod;

    public InvokeMethod(ASMBytecodeEmitter context, RunMethod runMethod) {
        this.context = Objects.requireNonNull(context);
        this.runMethod = Objects.requireNonNull(runMethod);
    }

    public MethodNode methodNode() {
        MethodNode node = new MethodNode(1, "invoke", this.context.invokeMethodType().getDescriptor(), null, this.runMethod.throwsExceptions());
        InsnList il = node.instructions;
        List locals = node.localVariables;
        LabelNode begin = new LabelNode();
        LabelNode end = new LabelNode();
        int invokeKind = this.context.kind();
        il.add(begin);
        int[] slotParamMap = new int[this.context.slots.numSlots()];
        Arrays.fill(slotParamMap, -1);
        int paramIdx = 0;
        while (paramIdx < this.context.fn.params().size()) {
            int slotIdx = this.context.slots.slotOf(this.context.fn.params().get(paramIdx));
            assert (slotParamMap[slotIdx] == -1);
            slotParamMap[slotIdx] = paramIdx++;
        }
        if (invokeKind > 0) {
            il.add(new VarInsnNode(25, 0));
            il.add(new VarInsnNode(25, 1));
            il.add(ASMUtils.loadInt(0));
            for (int paramIdx2 : slotParamMap) {
                if (paramIdx2 < 0) {
                    il.add(new InsnNode(1));
                    continue;
                }
                Var param = this.context.fn.params().get(paramIdx2);
                boolean reified = this.context.types.isReified(param);
                if (reified) {
                    il.add(new TypeInsnNode(187, Type.getInternalName(Variable.class)));
                    il.add(new InsnNode(89));
                }
                il.add(new VarInsnNode(25, 2 + paramIdx2));
                if (!reified) continue;
                il.add(VariableMethods.constructor());
            }
        } else {
            int lv_param_offset;
            int lv_varargsSize = 3;
            int lv_varargs = 4;
            int numParams = this.context.numOfParameters();
            if (this.context.isVararg()) {
                LabelNode l_v_begin = new LabelNode();
                LabelNode l_v_nonempty = new LabelNode();
                LabelNode l_v_empty = new LabelNode();
                LabelNode l_v_done = new LabelNode();
                il.add(new VarInsnNode(25, 2));
                il.add(new InsnNode(190));
                if (numParams > 0) {
                    il.add(ASMUtils.loadInt(this.context.numOfParameters()));
                    il.add(new InsnNode(100));
                }
                il.add(new VarInsnNode(54, lv_varargsSize));
                il.add(l_v_begin);
                il.add(new VarInsnNode(21, lv_varargsSize));
                il.add(new JumpInsnNode(158, l_v_empty));
                il.add(new VarInsnNode(21, lv_varargsSize));
                il.add(new TypeInsnNode(189, Type.getInternalName(Object.class)));
                il.add(new VarInsnNode(58, lv_varargs));
                il.add(l_v_nonempty);
                il.add(new VarInsnNode(25, 2));
                il.add(ASMUtils.loadInt(numParams));
                il.add(new VarInsnNode(25, lv_varargs));
                il.add(ASMUtils.loadInt(0));
                il.add(new VarInsnNode(21, lv_varargsSize));
                il.add(new MethodInsnNode(184, Type.getInternalName(System.class), "arraycopy", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(Object.class), Type.INT_TYPE, Type.getType(Object.class), Type.INT_TYPE, Type.INT_TYPE), false));
                il.add(new JumpInsnNode(167, l_v_done));
                il.add(l_v_empty);
                il.add(new FrameNode(1, 1, new Object[]{Opcodes.INTEGER}, 0, null));
                il.add(ASMUtils.loadInt(0));
                il.add(new TypeInsnNode(189, Type.getInternalName(Object.class)));
                il.add(new VarInsnNode(58, lv_varargs));
                il.add(l_v_done);
                il.add(new FrameNode(1, 1, new Object[]{ASMUtils.arrayTypeFor(Object.class).getInternalName()}, 0, null));
                locals.add(new LocalVariableNode("sz", Type.INT_TYPE.getDescriptor(), null, l_v_begin, end, lv_varargsSize));
                locals.add(new LocalVariableNode("varargs", ASMUtils.arrayTypeFor(Object.class).getDescriptor(), null, l_v_nonempty, l_v_empty, lv_varargs));
                locals.add(new LocalVariableNode("varargs", ASMUtils.arrayTypeFor(Object.class).getDescriptor(), null, l_v_done, end, lv_varargs));
            }
            int n = lv_param_offset = this.context.isVararg() ? lv_varargs + 1 : lv_varargsSize;
            if (numParams > 0) {
                int i;
                for (int i2 = 0; i2 < numParams; ++i2) {
                    LabelNode l = new LabelNode();
                    int lv = lv_param_offset + i2;
                    il.add(new InsnNode(1));
                    il.add(new VarInsnNode(58, lv));
                    il.add(l);
                    il.add(new FrameNode(1, 1, new Object[]{Type.getInternalName(Object.class)}, 0, null));
                    locals.add(new LocalVariableNode("arg_" + i2, Type.getDescriptor(Object.class), null, l, end, lv));
                }
                LabelNode[] l_s_table = new LabelNode[numParams + 1];
                for (i = 0; i < numParams + 1; ++i) {
                    l_s_table[i] = new LabelNode();
                }
                il.add(new VarInsnNode(25, 2));
                il.add(new InsnNode(190));
                il.add(new TableSwitchInsnNode(0, numParams, l_s_table[numParams], l_s_table));
                for (i = numParams; i >= 0; --i) {
                    int paramIdx3 = i - 1;
                    il.add(l_s_table[i]);
                    il.add(new FrameNode(3, 0, null, 0, null));
                    if (paramIdx3 < 0) continue;
                    il.add(new VarInsnNode(25, 2));
                    il.add(ASMUtils.loadInt(paramIdx3));
                    il.add(new InsnNode(50));
                    il.add(new VarInsnNode(58, lv_param_offset + paramIdx3));
                }
            }
            il.add(new VarInsnNode(25, 0));
            il.add(new VarInsnNode(25, 1));
            il.add(ASMUtils.loadInt(0));
            if (this.context.isVararg()) {
                il.add(new VarInsnNode(25, lv_varargs));
            }
            for (int paramIdx4 : slotParamMap) {
                if (paramIdx4 < 0) {
                    il.add(new InsnNode(1));
                    continue;
                }
                Var param = this.context.fn.params().get(paramIdx4);
                boolean reified = this.context.types.isReified(param);
                if (reified) {
                    il.add(new TypeInsnNode(187, Type.getInternalName(Variable.class)));
                    il.add(new InsnNode(89));
                }
                il.add(new VarInsnNode(25, lv_param_offset + paramIdx4));
                if (!reified) continue;
                il.add(VariableMethods.constructor());
            }
        }
        il.add(this.runMethod.methodInvokeInsn());
        il.add(new InsnNode(177));
        il.add(end);
        locals.add(new LocalVariableNode("this", this.context.thisClassType().getDescriptor(), null, begin, end, 0));
        locals.add(new LocalVariableNode("context", Type.getDescriptor(ExecutionContext.class), null, begin, end, 1));
        if (invokeKind > 0) {
            for (int i = 0; i < invokeKind; ++i) {
                locals.add(new LocalVariableNode("arg_" + i, Type.getDescriptor(Object.class), null, begin, end, 2 + i));
            }
        } else {
            locals.add(new LocalVariableNode("args", ASMUtils.arrayTypeFor(Object.class).getDescriptor(), null, begin, end, 2));
        }
        return node;
    }
}

