/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.gen.asm;

import java.util.Arrays;
import java.util.Objects;
import org.classdump.luna.Variable;
import org.classdump.luna.compiler.gen.asm.ASMBytecodeEmitter;
import org.classdump.luna.compiler.gen.asm.RunMethod;
import org.classdump.luna.compiler.ir.UpVar;
import org.classdump.luna.shaded.org.objectweb.asm.Type;
import org.classdump.luna.shaded.org.objectweb.asm.tree.FieldInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.InsnList;
import org.classdump.luna.shaded.org.objectweb.asm.tree.InsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.LabelNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.LocalVariableNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.MethodNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.VarInsnNode;

class ConstructorMethod {
    private final ASMBytecodeEmitter context;
    private final RunMethod runMethod;

    public ConstructorMethod(ASMBytecodeEmitter context, RunMethod runMethod) {
        this.context = Objects.requireNonNull(context);
        this.runMethod = Objects.requireNonNull(runMethod);
    }

    public Type methodType() {
        Object[] args = new Type[this.context.fn.upvals().size()];
        Arrays.fill(args, Type.getType(Variable.class));
        return Type.getMethodType(Type.VOID_TYPE, (Type[])args);
    }

    public MethodNode methodNode() {
        MethodNode node = new MethodNode(1, "<init>", this.methodType().getDescriptor(), null, null);
        InsnList il = node.instructions;
        LabelNode begin = new LabelNode();
        LabelNode end = new LabelNode();
        node.localVariables.add(new LocalVariableNode("this", this.context.thisClassType().getDescriptor(), null, begin, end, 0));
        il.add(begin);
        il.add(new VarInsnNode(25, 0));
        il.add(new MethodInsnNode(183, this.context.superClassType().getInternalName(), "<init>", Type.getMethodType(Type.VOID_TYPE, new Type[0]).getDescriptor(), false));
        int idx = 0;
        for (UpVar uv : this.context.fn.upvals()) {
            String name = this.context.getUpvalueFieldName(uv);
            il.add(new VarInsnNode(25, 0));
            il.add(new VarInsnNode(25, 1 + idx));
            il.add(new FieldInsnNode(181, this.context.thisClassType().getInternalName(), name, Type.getDescriptor(Variable.class)));
            node.localVariables.add(new LocalVariableNode(name, Type.getDescriptor(Variable.class), null, begin, end, idx));
            ++idx;
        }
        for (RunMethod.ClosureFieldInstance cfi : this.runMethod.closureFields()) {
            this.context.fields().add(cfi.fieldNode());
            il.add(cfi.instantiateInsns());
        }
        il.add(new InsnNode(177));
        il.add(end);
        node.maxStack = 2;
        node.maxLocals = this.context.fn.upvals().size() + 1;
        return node;
    }
}

