/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.gen.asm;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.classdump.luna.Variable;
import org.classdump.luna.compiler.CompilerSettings;
import org.classdump.luna.compiler.FunctionId;
import org.classdump.luna.compiler.IRFunc;
import org.classdump.luna.compiler.analysis.DependencyInfo;
import org.classdump.luna.compiler.analysis.SlotAllocInfo;
import org.classdump.luna.compiler.analysis.TypeInfo;
import org.classdump.luna.compiler.gen.BytecodeEmitter;
import org.classdump.luna.compiler.gen.ClassNameTranslator;
import org.classdump.luna.compiler.gen.CompiledClass;
import org.classdump.luna.compiler.gen.asm.ConstructorMethod;
import org.classdump.luna.compiler.gen.asm.InvokeMethod;
import org.classdump.luna.compiler.gen.asm.ResumeMethod;
import org.classdump.luna.compiler.gen.asm.RunMethod;
import org.classdump.luna.compiler.gen.asm.StaticConstructorMethod;
import org.classdump.luna.compiler.gen.asm.helpers.ASMUtils;
import org.classdump.luna.compiler.gen.asm.helpers.InvokableMethods;
import org.classdump.luna.compiler.gen.asm.helpers.InvokeKind;
import org.classdump.luna.compiler.ir.AbstractVar;
import org.classdump.luna.compiler.ir.UpVar;
import org.classdump.luna.compiler.ir.Var;
import org.classdump.luna.impl.DefaultSavedState;
import org.classdump.luna.shaded.org.objectweb.asm.ClassReader;
import org.classdump.luna.shaded.org.objectweb.asm.ClassWriter;
import org.classdump.luna.shaded.org.objectweb.asm.Type;
import org.classdump.luna.shaded.org.objectweb.asm.tree.ClassNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.FieldNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.InnerClassNode;
import org.classdump.luna.shaded.org.objectweb.asm.util.CheckClassAdapter;
import org.classdump.luna.shaded.org.objectweb.asm.util.TraceClassVisitor;
import org.classdump.luna.util.ByteVector;

public class ASMBytecodeEmitter
extends BytecodeEmitter {
    public final IRFunc fn;
    public final SlotAllocInfo slots;
    public final TypeInfo types;
    public final DependencyInfo deps;
    public final CompilerSettings compilerSettings;
    public final ClassNameTranslator classNameTranslator;
    private final String sourceFile;
    private final ClassNode classNode;
    private final HashMap<UpVar, String> upvalueFieldNames;
    private final List<FieldNode> fields;
    private boolean verifyAndPrint;

    public ASMBytecodeEmitter(IRFunc fn, SlotAllocInfo slots, TypeInfo types, DependencyInfo deps, CompilerSettings compilerSettings, ClassNameTranslator classNameTranslator, String sourceFile) {
        this.fn = Objects.requireNonNull(fn);
        this.slots = Objects.requireNonNull(slots);
        this.types = Objects.requireNonNull(types);
        this.deps = Objects.requireNonNull(deps);
        this.compilerSettings = Objects.requireNonNull(compilerSettings);
        this.classNameTranslator = Objects.requireNonNull(classNameTranslator);
        this.sourceFile = Objects.requireNonNull(sourceFile);
        this.classNode = new ClassNode();
        this.fields = new ArrayList<FieldNode>();
        this.upvalueFieldNames = new HashMap();
        String s = System.getProperty("org.classdump.luna.compiler.VerifyAndPrint");
        this.verifyAndPrint = s != null && "true".equals(s.trim().toLowerCase());
    }

    int kind() {
        return InvokeKind.adjust_nativeKind(InvokeKind.encode(this.fn.params().size(), this.fn.isVararg()));
    }

    String thisClassName() {
        return this.fn.id().toClassName(this.classNameTranslator);
    }

    Type thisClassType() {
        return ASMUtils.typeForClassName(this.thisClassName());
    }

    Type superClassType() {
        return Type.getType(InvokeKind.nativeClassForKind(this.kind()));
    }

    Type parentClassType() {
        FunctionId parentId = this.fn.id().parent();
        return parentId != null ? ASMUtils.typeForClassName(parentId.toClassName(this.classNameTranslator)) : null;
    }

    public Type savedStateClassType() {
        return Type.getType(DefaultSavedState.class);
    }

    Type invokeMethodType() {
        return InvokableMethods.invoke_method(this.kind()).getMethodType();
    }

    public boolean hasUpvalues() {
        return !this.fn.upvals().isEmpty();
    }

    public int numOfParameters() {
        return this.fn.params().size();
    }

    public boolean isVararg() {
        return this.fn.isVararg();
    }

    public List<FieldNode> fields() {
        return this.fields;
    }

    private void addInnerClassLinks() {
        String ownInternalName = this.thisClassType().getInternalName();
        if (this.parentClassType() != null) {
            String parentInternalName = this.parentClassType().getInternalName();
            String suffix = ownInternalName.substring(parentInternalName.length() + 1);
            this.classNode.innerClasses.add(new InnerClassNode(ownInternalName, parentInternalName, suffix, 9));
        }
        ArrayList<FunctionId> nestedIds = new ArrayList<FunctionId>(this.deps.nestedRefs());
        Collections.sort(nestedIds, FunctionId.LEXICOGRAPHIC_COMPARATOR);
        for (FunctionId childId : nestedIds) {
            String childClassName = childId.toClassName(this.classNameTranslator);
            String childInternalName = ASMUtils.typeForClassName(childClassName).getInternalName();
            String suffix = childInternalName.substring(ownInternalName.length() + 1);
            this.classNode.innerClasses.add(new InnerClassNode(childInternalName, ownInternalName, suffix, 9));
        }
    }

    protected static NestedInstanceKind functionKind(IRFunc fn) {
        if (fn.upvals().isEmpty()) {
            return NestedInstanceKind.Pure;
        }
        for (AbstractVar abstractVar : fn.upvals()) {
            if (!(abstractVar instanceof Var)) continue;
            return NestedInstanceKind.Open;
        }
        return NestedInstanceKind.Closed;
    }

    public static String instanceFieldName() {
        return "INSTANCE";
    }

    private FieldNode instanceField() {
        return new FieldNode(25, ASMBytecodeEmitter.instanceFieldName(), this.thisClassType().getDescriptor(), null, null);
    }

    String addFieldName(String n) {
        return n;
    }

    private static String toFieldName(String n) {
        return n;
    }

    private static String ensureUnique(Collection<String> ss, String s) {
        int idx = 0;
        String prefix = s;
        while (ss.contains(s)) {
            s = prefix + "_" + idx++;
        }
        return s;
    }

    private static String preferredUpvalueName(UpVar uv) {
        return uv.name().value();
    }

    private void addUpvalueFields() {
        for (UpVar uv : this.fn.upvals()) {
            String name = ASMBytecodeEmitter.toFieldName(ASMBytecodeEmitter.ensureUnique(this.upvalueFieldNames.values(), ASMBytecodeEmitter.preferredUpvalueName(uv)));
            this.upvalueFieldNames.put(uv, name);
            FieldNode fieldNode = new FieldNode(20, name, Type.getDescriptor(Variable.class), null, null);
            this.classNode.fields.add(fieldNode);
        }
    }

    public String getUpvalueFieldName(UpVar uv) {
        String name = this.upvalueFieldNames.get(uv);
        if (name == null) {
            throw new IllegalArgumentException("upvalue field name is null for upvalue " + uv);
        }
        return name;
    }

    public ClassNode classNode() {
        StaticConstructorMethod staticCtor;
        this.classNode.version = 51;
        this.classNode.access = 33;
        this.classNode.name = this.thisClassType().getInternalName();
        this.classNode.superName = this.superClassType().getInternalName();
        this.classNode.sourceFile = this.sourceFile;
        this.addInnerClassLinks();
        if (!this.hasUpvalues()) {
            this.classNode.fields.add(this.instanceField());
        }
        this.addUpvalueFields();
        RunMethod runMethod = new RunMethod(this);
        for (RunMethod.ConstFieldInstance cfi : runMethod.constFields()) {
            this.classNode.fields.add(cfi.fieldNode());
        }
        ConstructorMethod ctor = new ConstructorMethod(this, runMethod);
        this.classNode.methods.add(ctor.methodNode());
        this.classNode.methods.add(new InvokeMethod(this, runMethod).methodNode());
        this.classNode.methods.add(new ResumeMethod(this, runMethod).methodNode());
        this.classNode.methods.addAll(runMethod.methodNodes());
        if (runMethod.usesSnapshotMethod()) {
            this.classNode.methods.add(runMethod.snapshotMethodNode());
        }
        if (!(staticCtor = new StaticConstructorMethod(this, ctor, runMethod)).isEmpty()) {
            this.classNode.methods.add(staticCtor.methodNode());
        }
        this.classNode.fields.addAll(this.fields);
        return this.classNode;
    }

    private byte[] classNodeToBytes(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(1);
        classNode.accept(writer);
        byte[] bytes = writer.toByteArray();
        if (this.verifyAndPrint) {
            ClassReader reader = new ClassReader(bytes);
            TraceClassVisitor tracer = new TraceClassVisitor(new PrintWriter(System.out));
            CheckClassAdapter checker = new CheckClassAdapter(tracer, true);
            reader.accept(checker, 0);
        }
        return bytes;
    }

    @Override
    public CompiledClass emit() {
        ClassNode classNode = this.classNode();
        byte[] bytes = this.classNodeToBytes(classNode);
        return new CompiledClass(this.thisClassName(), ByteVector.wrap(bytes));
    }

    static enum NestedInstanceKind {
        Pure,
        Closed,
        Open;

    }
}

