/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.classdump.luna.compiler.gen.SegmentedCode;
import org.classdump.luna.compiler.ir.BasicBlock;
import org.classdump.luna.compiler.ir.BodyNode;
import org.classdump.luna.compiler.ir.Code;
import org.classdump.luna.compiler.ir.Label;
import org.classdump.luna.compiler.ir.Line;
import org.classdump.luna.compiler.ir.ToNext;

public final class CodeSegmenter {
    private CodeSegmenter() {
    }

    private static int blockLength(BasicBlock blk) {
        return blk.body().size() + 1;
    }

    private static int lastLine(List<BodyNode> nodes) {
        int line = -1;
        for (BodyNode n : nodes) {
            if (!(n instanceof Line)) continue;
            line = ((Line)n).lineNumber();
        }
        return line;
    }

    private static BlockSplit splitBlockAt(BasicBlock blk, int index, int splitIdx) {
        List<BodyNode> predBody = blk.body().subList(0, index);
        ArrayList<BodyNode> succBody = new ArrayList<BodyNode>();
        int firstSuccLine = CodeSegmenter.lastLine(predBody);
        if (firstSuccLine != -1) {
            succBody.add(new Line(firstSuccLine));
        }
        succBody.addAll(blk.body().subList(index, blk.body().size()));
        Label succLabel = new Label(-(splitIdx + 1));
        BasicBlock pred = new BasicBlock(blk.label(), predBody, new ToNext(succLabel));
        BasicBlock succ = new BasicBlock(succLabel, Collections.unmodifiableList(succBody), blk.end());
        return new BlockSplit(pred, succ);
    }

    public static SegmentedCode segment(Code code, int limit) {
        BasicBlock blk;
        if (limit <= 0) {
            return SegmentedCode.singleton(code);
        }
        ArrayList<List<BasicBlock>> segmentBlocks = new ArrayList<List<BasicBlock>>();
        ArrayList<BasicBlock> currentSegment = new ArrayList<BasicBlock>();
        int count = 0;
        int splitIdx = 0;
        Iterator<BasicBlock> bit = code.blockIterator();
        BasicBlock basicBlock = blk = bit.hasNext() ? bit.next() : null;
        while (blk != null) {
            int len = CodeSegmenter.blockLength(blk);
            if (count + len < limit) {
                currentSegment.add(blk);
                count += len;
                blk = bit.hasNext() ? bit.next() : null;
                continue;
            }
            if (count + len == limit) {
                currentSegment.add(blk);
                segmentBlocks.add(Collections.unmodifiableList(currentSegment));
                currentSegment = new ArrayList();
                count = 0;
                blk = bit.hasNext() ? bit.next() : null;
                continue;
            }
            assert (count + len > limit);
            BlockSplit split = CodeSegmenter.splitBlockAt(blk, limit - count, splitIdx++);
            currentSegment.add(split.pred);
            segmentBlocks.add(Collections.unmodifiableList(currentSegment));
            currentSegment = new ArrayList();
            count = 0;
            blk = split.succ;
        }
        if (!currentSegment.isEmpty()) {
            segmentBlocks.add(Collections.unmodifiableList(currentSegment));
        }
        return SegmentedCode.of(segmentBlocks);
    }

    private static class BlockSplit {
        final BasicBlock pred;
        final BasicBlock succ;

        private BlockSplit(BasicBlock pred, BasicBlock succ) {
            this.pred = Objects.requireNonNull(pred);
            this.succ = Objects.requireNonNull(succ);
        }
    }
}

