/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.analysis.types;

import java.util.Objects;
import org.classdump.luna.compiler.analysis.types.Type;
import org.classdump.luna.compiler.analysis.types.TypeSeq;

public abstract class ReturnType {
    private ReturnType() {
    }

    public static class TailCallReturnType
    extends ReturnType {
        public final Type target;
        public final TypeSeq typeSeq;

        public TailCallReturnType(Type target, TypeSeq typeSeq) {
            this.target = Objects.requireNonNull(target);
            this.typeSeq = Objects.requireNonNull(typeSeq);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TailCallReturnType that = (TailCallReturnType)o;
            return this.target == that.target && this.typeSeq.equals(that.typeSeq);
        }

        public int hashCode() {
            int result = this.target.hashCode();
            result = 31 * result + this.typeSeq.hashCode();
            return result;
        }

        public String toString() {
            return this.target.toString() + "(" + this.typeSeq + ")";
        }
    }

    public static class ConcreteReturnType
    extends ReturnType {
        public final TypeSeq typeSeq;

        public ConcreteReturnType(TypeSeq typeSeq) {
            this.typeSeq = Objects.requireNonNull(typeSeq);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcreteReturnType that = (ConcreteReturnType)o;
            return this.typeSeq.equals(that.typeSeq);
        }

        public int hashCode() {
            return this.typeSeq.hashCode();
        }

        public String toString() {
            return this.typeSeq.toString();
        }
    }
}

