/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.analysis.types;

import java.util.Objects;
import org.classdump.luna.compiler.analysis.types.ConcreteType;
import org.classdump.luna.compiler.analysis.types.DynamicType;
import org.classdump.luna.compiler.analysis.types.Type;

public class LiteralType<T>
extends Type {
    private final ConcreteType type;
    private final T value;

    public LiteralType(ConcreteType type, T value) {
        this.type = Objects.requireNonNull(type);
        this.value = Objects.requireNonNull(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiteralType that = (LiteralType)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return this.type.toString() + "(" + this.value + ")";
    }

    public ConcreteType type() {
        return this.type;
    }

    public T value() {
        return this.value;
    }

    @Override
    public boolean isSubtypeOf(Type that) {
        return this.equals(that) || this.type().isSubtypeOf(that);
    }

    @Override
    public Type restrict(Type that) {
        return that instanceof DynamicType ? that : this;
    }

    @Override
    public Type join(Type that) {
        Objects.requireNonNull(that);
        if (that.isSubtypeOf(this)) {
            return this;
        }
        return this.type().join(that);
    }

    @Override
    public Type meet(Type that) {
        Objects.requireNonNull(that);
        if (this.isSubtypeOf(that)) {
            return this;
        }
        if (that.isSubtypeOf(this)) {
            return that;
        }
        return null;
    }
}

