/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.analysis;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.classdump.luna.compiler.analysis.types.GradualTypeLike;
import org.classdump.luna.compiler.analysis.types.Type;
import org.classdump.luna.compiler.analysis.types.TypeSeq;
import org.classdump.luna.compiler.ir.AbstractVal;
import org.classdump.luna.compiler.ir.MultiVal;
import org.classdump.luna.compiler.ir.PhiVal;
import org.classdump.luna.compiler.ir.Val;
import org.classdump.luna.compiler.ir.Var;

public class TypeInfo {
    private final Map<AbstractVal, Type> types;
    private final Map<MultiVal, TypeSeq> multiTypes;
    private final Map<Var, Boolean> vars;
    private final TypeSeq returnType;

    protected TypeInfo(Map<AbstractVal, Type> types, Map<MultiVal, TypeSeq> multiTypes, Map<Var, Boolean> vars, TypeSeq returnType) {
        this.types = Objects.requireNonNull(types);
        this.multiTypes = Objects.requireNonNull(multiTypes);
        this.vars = Objects.requireNonNull(vars);
        this.returnType = Objects.requireNonNull(returnType);
    }

    public static TypeInfo of(Map<Val, Type> valTypes, Map<PhiVal, Type> phiValTypes, Map<MultiVal, TypeSeq> multiValTypes, Set<Var> vars, Set<Var> reifiedVars, TypeSeq returnType) {
        HashMap<AbstractVal, Type> types = new HashMap<AbstractVal, Type>();
        HashMap<MultiVal, TypeSeq> multiTypes = new HashMap<MultiVal, TypeSeq>();
        HashMap<Var, Boolean> vs = new HashMap<Var, Boolean>();
        for (Map.Entry<Val, Type> entry : valTypes.entrySet()) {
            types.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<AbstractVal, Type> entry : phiValTypes.entrySet()) {
            types.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, GradualTypeLike<Type>> entry : multiValTypes.entrySet()) {
            multiTypes.put((MultiVal)entry.getKey(), (TypeSeq)entry.getValue());
        }
        for (Var var : vars) {
            vs.put(var, reifiedVars.contains(var));
        }
        for (Var var : reifiedVars) {
            if (vs.containsKey(var)) continue;
            throw new IllegalStateException("Reified variable " + var + " not found");
        }
        return new TypeInfo(types, multiTypes, vs, returnType);
    }

    public Iterable<AbstractVal> vals() {
        return this.types.keySet();
    }

    public Iterable<MultiVal> multiVals() {
        return this.multiTypes.keySet();
    }

    public Type typeOf(AbstractVal v) {
        Objects.requireNonNull(v);
        Type t = this.types.get(v);
        if (t == null) {
            throw new NoSuchElementException("No type information for " + v);
        }
        return t;
    }

    public TypeSeq typeOf(MultiVal mv) {
        Objects.requireNonNull(mv);
        TypeSeq tseq = this.multiTypes.get(mv);
        if (tseq == null) {
            throw new NoSuchElementException("No type information for multi-value " + mv);
        }
        return tseq;
    }

    public Iterable<Var> vars() {
        return this.vars.keySet();
    }

    public boolean isReified(Var v) {
        Objects.requireNonNull(v);
        Boolean r = this.vars.get(v);
        if (r != null) {
            return r;
        }
        throw new NoSuchElementException("Variable not found: " + v);
    }

    public TypeSeq returnType() {
        return this.returnType;
    }
}

