/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.analysis;

import org.classdump.luna.compiler.analysis.NumericOperationType;
import org.classdump.luna.compiler.analysis.types.LuaTypes;
import org.classdump.luna.compiler.analysis.types.Type;

public abstract class StaticMathImplementation {
    public static StaticMathImplementation MAY_BE_INTEGER = new MayBeInteger();
    public static StaticMathImplementation MUST_BE_FLOAT = new MustBeFloat();
    public static StaticMathImplementation MUST_BE_INTEGER = new MustBeInteger();

    public abstract NumericOperationType opType(Type var1, Type var2);

    public abstract NumericOperationType opType(Type var1);

    public static class MustBeInteger
    extends StaticMathImplementation {
        private MustBeInteger() {
        }

        @Override
        public NumericOperationType opType(Type l, Type r) {
            if (l.isSubtypeOf(LuaTypes.NUMBER) && r.isSubtypeOf(LuaTypes.NUMBER)) {
                return NumericOperationType.Integer;
            }
            return NumericOperationType.Any;
        }

        @Override
        public NumericOperationType opType(Type arg) {
            if (arg.isSubtypeOf(LuaTypes.NUMBER)) {
                return NumericOperationType.Integer;
            }
            return NumericOperationType.Any;
        }
    }

    public static class MustBeFloat
    extends StaticMathImplementation {
        private MustBeFloat() {
        }

        @Override
        public NumericOperationType opType(Type l, Type r) {
            if (l.isSubtypeOf(LuaTypes.NUMBER) && r.isSubtypeOf(LuaTypes.NUMBER)) {
                return NumericOperationType.Float;
            }
            return NumericOperationType.Any;
        }

        @Override
        public NumericOperationType opType(Type arg) {
            if (arg.isSubtypeOf(LuaTypes.NUMBER)) {
                return NumericOperationType.Float;
            }
            return NumericOperationType.Any;
        }
    }

    public static class MayBeInteger
    extends StaticMathImplementation {
        private MayBeInteger() {
        }

        @Override
        public NumericOperationType opType(Type l, Type r) {
            if (l.isSubtypeOf(LuaTypes.NUMBER) && r.isSubtypeOf(LuaTypes.NUMBER)) {
                if (l.isSubtypeOf(LuaTypes.NUMBER_INTEGER) && r.isSubtypeOf(LuaTypes.NUMBER_INTEGER)) {
                    return NumericOperationType.Integer;
                }
                if (l.isSubtypeOf(LuaTypes.NUMBER_FLOAT) || r.isSubtypeOf(LuaTypes.NUMBER_FLOAT)) {
                    return NumericOperationType.Float;
                }
                return NumericOperationType.Number;
            }
            return NumericOperationType.Any;
        }

        @Override
        public NumericOperationType opType(Type arg) {
            if (arg.isSubtypeOf(LuaTypes.NUMBER)) {
                if (arg.isSubtypeOf(LuaTypes.NUMBER_INTEGER)) {
                    return NumericOperationType.Integer;
                }
                if (arg.isSubtypeOf(LuaTypes.NUMBER_FLOAT)) {
                    return NumericOperationType.Float;
                }
                return NumericOperationType.Number;
            }
            return NumericOperationType.Any;
        }
    }
}

