/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler;

import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.classdump.luna.compiler.FunctionId;
import org.classdump.luna.compiler.IRFunc;

public class Module {
    private final List<IRFunc> fns;

    public Module(List<IRFunc> fns) {
        this.fns = Objects.requireNonNull(fns);
        this.verify();
    }

    private void verify() {
        HashSet<FunctionId> ids = new HashSet<FunctionId>();
        boolean hasMain = false;
        for (IRFunc fn : this.fns) {
            if (!ids.add(fn.id())) {
                throw new IllegalStateException("Function " + fn.id() + " defined more than once");
            }
            if (!fn.id().isRoot()) continue;
            hasMain = true;
        }
        if (!hasMain) {
            throw new IllegalStateException("No main function in module");
        }
    }

    public List<IRFunc> fns() {
        return this.fns;
    }

    public IRFunc get(FunctionId id) {
        Objects.requireNonNull(id);
        for (IRFunc fn : this.fns) {
            if (!fn.id().equals(id)) continue;
            return fn;
        }
        throw new NoSuchElementException();
    }

    public IRFunc main() {
        return this.get(FunctionId.root());
    }
}

