/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler;

import java.io.ByteArrayInputStream;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import org.classdump.luna.compiler.CompiledModule;
import org.classdump.luna.compiler.CompilerSettings;
import org.classdump.luna.compiler.FunctionId;
import org.classdump.luna.compiler.IRFunc;
import org.classdump.luna.compiler.IRTranslator;
import org.classdump.luna.compiler.Module;
import org.classdump.luna.compiler.analysis.DependencyAnalyser;
import org.classdump.luna.compiler.analysis.DependencyInfo;
import org.classdump.luna.compiler.analysis.LivenessAnalyser;
import org.classdump.luna.compiler.analysis.LivenessInfo;
import org.classdump.luna.compiler.analysis.SlotAllocInfo;
import org.classdump.luna.compiler.analysis.SlotAllocator;
import org.classdump.luna.compiler.analysis.TypeInfo;
import org.classdump.luna.compiler.analysis.Typer;
import org.classdump.luna.compiler.gen.BytecodeEmitter;
import org.classdump.luna.compiler.gen.CompiledClass;
import org.classdump.luna.compiler.gen.SuffixingClassNameTranslator;
import org.classdump.luna.compiler.gen.asm.ASMBytecodeEmitter;
import org.classdump.luna.compiler.tf.BranchInliner;
import org.classdump.luna.compiler.tf.CPUAccounter;
import org.classdump.luna.compiler.tf.CodeSimplifier;
import org.classdump.luna.compiler.tf.ConstFolder;
import org.classdump.luna.compiler.tf.DeadCodePruner;
import org.classdump.luna.parser.ParseException;
import org.classdump.luna.parser.Parser;
import org.classdump.luna.parser.TokenMgrError;
import org.classdump.luna.parser.analysis.NameResolver;
import org.classdump.luna.parser.ast.Chunk;
import org.classdump.luna.util.ByteVector;

public class LuaCompiler {
    private final CompilerSettings settings;

    public LuaCompiler(CompilerSettings settings) {
        this.settings = Objects.requireNonNull(settings);
    }

    public LuaCompiler() {
        this(CompilerSettings.defaultSettings());
    }

    public CompilerSettings settings() {
        return this.settings;
    }

    private static Chunk parse(String sourceText) throws ParseException, TokenMgrError {
        ByteArrayInputStream bais = new ByteArrayInputStream(sourceText.getBytes());
        Parser parser = new Parser(bais);
        return parser.Chunk();
    }

    private static Module translate(Chunk chunk) {
        chunk = NameResolver.resolveNames(chunk);
        return IRTranslator.translate(chunk);
    }

    private Iterable<IRFunc> sortTopologically(Module module) {
        return module.fns();
    }

    private IRFunc optimise(IRFunc fn) {
        IRFunc oldFn;
        do {
            oldFn = fn;
            TypeInfo typeInfo = Typer.analyseTypes(fn);
            fn = CPUAccounter.collectCPUAccounting(fn);
            fn = BranchInliner.inlineBranches(fn, typeInfo);
            if (this.settings.constFolding()) {
                fn = ConstFolder.replaceConstOperations(fn, typeInfo);
                LivenessInfo liveness = LivenessAnalyser.computeLiveness(fn);
                fn = DeadCodePruner.pruneDeadCode(fn, typeInfo, liveness);
            }
            fn = CodeSimplifier.pruneUnreachableCode(fn);
        } while (!oldFn.equals(fn = CodeSimplifier.mergeBlocks(fn)));
        return fn;
    }

    ProcessedFunc processFunction(IRFunc fn) {
        fn = CPUAccounter.insertCPUAccounting(fn);
        fn = this.optimise(fn);
        SlotAllocInfo slots = SlotAllocator.allocateSlots(fn);
        TypeInfo types = Typer.analyseTypes(fn);
        DependencyInfo deps = DependencyAnalyser.analyse(fn);
        return new ProcessedFunc(fn, slots, types, deps);
    }

    private Iterable<ProcessedFunc> processModule(Module m) {
        HashMap<FunctionId, ProcessedFunc> pfs = new HashMap<FunctionId, ProcessedFunc>();
        for (IRFunc fn : this.sortTopologically(m)) {
            ProcessedFunc pf = this.processFunction(fn);
            pfs.put(fn.id(), pf);
        }
        ProcessedFunc main = (ProcessedFunc)pfs.get(FunctionId.root());
        assert (main != null);
        HashSet<ProcessedFunc> result = new HashSet<ProcessedFunc>();
        ArrayDeque<ProcessedFunc> open = new ArrayDeque<ProcessedFunc>();
        open.add(main);
        while (!open.isEmpty()) {
            ProcessedFunc pf = (ProcessedFunc)open.pop();
            if (result.contains(pf)) continue;
            result.add(pf);
            for (FunctionId id : pf.deps.nestedRefs()) {
                open.push((ProcessedFunc)pfs.get(id));
            }
        }
        return result;
    }

    private CompiledClass compileFunction(ProcessedFunc pf, String sourceFileName, String rootClassName) {
        SuffixingClassNameTranslator classNameTranslator = new SuffixingClassNameTranslator(rootClassName);
        ASMBytecodeEmitter emitter = new ASMBytecodeEmitter(pf.fn, pf.slots, pf.types, pf.deps, this.settings, classNameTranslator, sourceFileName);
        return ((BytecodeEmitter)emitter).emit();
    }

    public CompiledModule compile(String sourceText, String sourceFileName, String rootClassName) throws ParseException, TokenMgrError {
        Objects.requireNonNull(sourceText);
        Chunk ast = LuaCompiler.parse(sourceText);
        Module module = LuaCompiler.translate(ast);
        Iterable<ProcessedFunc> pfs = this.processModule(module);
        HashMap<String, ByteVector> classMap = new HashMap<String, ByteVector>();
        String mainClass = null;
        for (ProcessedFunc pf : pfs) {
            CompiledClass cc = this.compileFunction(pf, sourceFileName, rootClassName);
            if (pf.fn.id().isRoot()) {
                assert (mainClass == null);
                mainClass = cc.name();
            }
            classMap.put(cc.name(), cc.bytes());
        }
        if (mainClass == null) {
            throw new IllegalStateException("Module main class not found");
        }
        return new CompiledModule(Collections.unmodifiableMap(classMap), mainClass);
    }

    private static class ProcessedFunc {
        public final IRFunc fn;
        public final SlotAllocInfo slots;
        public final TypeInfo types;
        public final DependencyInfo deps;

        private ProcessedFunc(IRFunc fn, SlotAllocInfo slots, TypeInfo types, DependencyInfo deps) {
            this.fn = Objects.requireNonNull(fn);
            this.slots = Objects.requireNonNull(slots);
            this.types = Objects.requireNonNull(types);
            this.deps = Objects.requireNonNull(deps);
        }
    }
}

