/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna;

import java.util.Objects;
import org.classdump.luna.ByteString;
import org.classdump.luna.LuaObject;
import org.classdump.luna.MetatableProvider;
import org.classdump.luna.Table;

public final class Metatables {
    public static final ByteString MT_ADD = ByteString.constOf("__add");
    public static final ByteString MT_SUB = ByteString.constOf("__sub");
    public static final ByteString MT_MUL = ByteString.constOf("__mul");
    public static final ByteString MT_DIV = ByteString.constOf("__div");
    public static final ByteString MT_MOD = ByteString.constOf("__mod");
    public static final ByteString MT_POW = ByteString.constOf("__pow");
    public static final ByteString MT_UNM = ByteString.constOf("__unm");
    public static final ByteString MT_IDIV = ByteString.constOf("__idiv");
    public static final ByteString MT_BAND = ByteString.constOf("__band");
    public static final ByteString MT_BOR = ByteString.constOf("__bor");
    public static final ByteString MT_BXOR = ByteString.constOf("__bxor");
    public static final ByteString MT_BNOT = ByteString.constOf("__bnot");
    public static final ByteString MT_SHL = ByteString.constOf("__shl");
    public static final ByteString MT_SHR = ByteString.constOf("__shr");
    public static final ByteString MT_CONCAT = ByteString.constOf("__concat");
    public static final ByteString MT_LEN = ByteString.constOf("__len");
    public static final ByteString MT_EQ = ByteString.constOf("__eq");
    public static final ByteString MT_LT = ByteString.constOf("__lt");
    public static final ByteString MT_LE = ByteString.constOf("__le");
    public static final ByteString MT_INDEX = ByteString.constOf("__index");
    public static final ByteString MT_NEWINDEX = ByteString.constOf("__newindex");
    public static final ByteString MT_CALL = ByteString.constOf("__call");
    public static final ByteString MT_MODE = ByteString.constOf("__mode");

    private Metatables() {
    }

    public static Object getMetamethod(ByteString event, LuaObject o) {
        Objects.requireNonNull(event);
        Objects.requireNonNull(o);
        Table mt = o.getMetatable();
        if (mt != null) {
            return mt.rawget(event);
        }
        return null;
    }

    public static Object getMetamethod(MetatableProvider metatableProvider, ByteString event, Object o) {
        Objects.requireNonNull(event);
        Table mt = metatableProvider.getMetatable(o);
        if (mt != null) {
            return mt.rawget(event);
        }
        return null;
    }

    public static Object binaryHandlerFor(MetatableProvider metatableProvider, ByteString event, Object a, Object b) {
        Objects.requireNonNull(metatableProvider);
        Objects.requireNonNull(event);
        Object ma = Metatables.getMetamethod(metatableProvider, event, a);
        return ma != null ? ma : Metatables.getMetamethod(metatableProvider, event, b);
    }
}

