/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.writer;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamResult;
import org.citygml4j.core.model.CityGMLVersion;
import org.citygml4j.xml.CityGMLContext;
import org.citygml4j.xml.converter.DefaultSimpleMultiPointConverter;
import org.citygml4j.xml.converter.DefaultSimplePolygonConverter;
import org.citygml4j.xml.converter.DefaultSimpleRectangleConverter;
import org.citygml4j.xml.converter.DefaultSimpleTriangleConverter;
import org.citygml4j.xml.transform.TransformerPipeline;
import org.citygml4j.xml.writer.AbstractCityGMLWriter;
import org.citygml4j.xml.writer.CityGMLChunkWriter;
import org.citygml4j.xml.writer.CityGMLWriteException;
import org.citygml4j.xml.writer.CityGMLWriter;
import org.xml.sax.ContentHandler;
import org.xmlobjects.XMLObjects;
import org.xmlobjects.gml.util.GMLConstants;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriterFactory;
import org.xmlobjects.util.Properties;
import org.xmlobjects.util.xml.SAXWriter;

public class CityGMLOutputFactory {
    private final XMLWriterFactory factory;
    private CityGMLVersion version;
    private TransformerPipeline transformer;

    public CityGMLOutputFactory(CityGMLVersion version, CityGMLContext context) {
        this.version = Objects.requireNonNull(version, "The CityGML version must not be null.");
        this.factory = XMLWriterFactory.newInstance((XMLObjects)context.getXMLObjects());
    }

    public CityGMLVersion getVersion() {
        return this.version;
    }

    public CityGMLOutputFactory withCityGMLVersion(CityGMLVersion version) {
        this.version = Objects.requireNonNull(version, "The CityGML version must not be null.");
        return this;
    }

    public Properties getProperties() {
        return this.factory.getProperties();
    }

    public CityGMLOutputFactory withProperty(String name, Object value) {
        this.factory.withProperty(name, value);
        return this;
    }

    public TransformerPipeline getTransformer() {
        return this.transformer;
    }

    public CityGMLOutputFactory withTransformer(TransformerPipeline transformer) {
        this.transformer = transformer;
        return this;
    }

    public CityGMLOutputFactory withDefaultCompactEncodingConverters() {
        this.factory.withProperty(GMLConstants.SIMPLE_POLYGON_CONVERTER, (Object)new DefaultSimplePolygonConverter());
        this.factory.withProperty(GMLConstants.SIMPLE_RECTANGLE_CONVERTER, (Object)new DefaultSimpleRectangleConverter());
        this.factory.withProperty(GMLConstants.SIMPLE_TRIANGLE_CONVERTER, (Object)new DefaultSimpleTriangleConverter());
        this.factory.withProperty(GMLConstants.SIMPLE_MULTI_POINT_CONVERTER, (Object)new DefaultSimpleMultiPointConverter());
        return this;
    }

    public CityGMLWriter createCityGMLWriter(File file) throws CityGMLWriteException {
        return this.createCityGMLWriter(file, StandardCharsets.UTF_8.name());
    }

    public CityGMLWriter createCityGMLWriter(File file, String encoding) throws CityGMLWriteException {
        try {
            return this.initialize(new CityGMLWriter(this.factory.createWriter(file, encoding), this.version, this.factory));
        }
        catch (XMLWriteException e) {
            throw new CityGMLWriteException("Caused by:", e);
        }
    }

    public CityGMLWriter createCityGMLWriter(Path path) throws CityGMLWriteException {
        return this.createCityGMLWriter(path, StandardCharsets.UTF_8.name());
    }

    public CityGMLWriter createCityGMLWriter(Path path, String encoding) throws CityGMLWriteException {
        try {
            return this.initialize(new CityGMLWriter(this.factory.createWriter(path, encoding), this.version, this.factory));
        }
        catch (XMLWriteException e) {
            throw new CityGMLWriteException("Caused by:", e);
        }
    }

    public CityGMLWriter createCityGMLWriter(StreamResult result) throws CityGMLWriteException {
        return this.createCityGMLWriter(result, StandardCharsets.UTF_8.name());
    }

    public CityGMLWriter createCityGMLWriter(StreamResult result, String encoding) throws CityGMLWriteException {
        try {
            return this.initialize(new CityGMLWriter(this.factory.createWriter(result, encoding), this.version, this.factory));
        }
        catch (XMLWriteException e) {
            throw new CityGMLWriteException("Caused by:", e);
        }
    }

    public CityGMLWriter createCityGMLWriter(OutputStream stream) throws CityGMLWriteException {
        return this.createCityGMLWriter(stream, StandardCharsets.UTF_8.name());
    }

    public CityGMLWriter createCityGMLWriter(OutputStream stream, String encoding) throws CityGMLWriteException {
        try {
            return this.initialize(new CityGMLWriter(this.factory.createWriter(stream, encoding), this.version, this.factory));
        }
        catch (XMLWriteException e) {
            throw new CityGMLWriteException("Caused by:", e);
        }
    }

    public CityGMLWriter createCityGMLWriter(Writer writer) throws CityGMLWriteException {
        return this.initialize(new CityGMLWriter(this.factory.createWriter(writer), this.version, this.factory));
    }

    public CityGMLWriter createCityGMLWriter(SAXWriter writer) throws CityGMLWriteException {
        return this.initialize(new CityGMLWriter(this.factory.createWriter(writer), this.version, this.factory));
    }

    public CityGMLWriter createCityGMLWriter(ContentHandler writer) throws CityGMLWriteException {
        return this.initialize(new CityGMLWriter(this.factory.createWriter(writer), this.version, this.factory));
    }

    public CityGMLChunkWriter createCityGMLChunkWriter(File file) throws CityGMLWriteException {
        return this.createCityGMLChunkWriter(file, StandardCharsets.UTF_8.name());
    }

    public CityGMLChunkWriter createCityGMLChunkWriter(File file, String encoding) throws CityGMLWriteException {
        try {
            return this.initialize(new CityGMLChunkWriter(this.factory.createWriter(file, encoding), this.version, this.factory));
        }
        catch (XMLWriteException e) {
            throw new CityGMLWriteException("Caused by:", e);
        }
    }

    public CityGMLChunkWriter createCityGMLChunkWriter(Path path) throws CityGMLWriteException {
        return this.createCityGMLChunkWriter(path, StandardCharsets.UTF_8.name());
    }

    public CityGMLChunkWriter createCityGMLChunkWriter(Path path, String encoding) throws CityGMLWriteException {
        try {
            return this.initialize(new CityGMLChunkWriter(this.factory.createWriter(path, encoding), this.version, this.factory));
        }
        catch (XMLWriteException e) {
            throw new CityGMLWriteException("Caused by:", e);
        }
    }

    public CityGMLChunkWriter createCityGMLChunkWriter(StreamResult result) throws CityGMLWriteException {
        return this.createCityGMLChunkWriter(result, StandardCharsets.UTF_8.name());
    }

    public CityGMLChunkWriter createCityGMLChunkWriter(StreamResult result, String encoding) throws CityGMLWriteException {
        try {
            return this.initialize(new CityGMLChunkWriter(this.factory.createWriter(result, encoding), this.version, this.factory));
        }
        catch (XMLWriteException e) {
            throw new CityGMLWriteException("Caused by:", e);
        }
    }

    public CityGMLChunkWriter createCityGMLChunkWriter(OutputStream stream) throws CityGMLWriteException {
        return this.createCityGMLChunkWriter(stream, StandardCharsets.UTF_8.name());
    }

    public CityGMLChunkWriter createCityGMLChunkWriter(OutputStream stream, String encoding) throws CityGMLWriteException {
        try {
            return this.initialize(new CityGMLChunkWriter(this.factory.createWriter(stream, encoding), this.version, this.factory));
        }
        catch (XMLWriteException e) {
            throw new CityGMLWriteException("Caused by:", e);
        }
    }

    public CityGMLChunkWriter createCityGMLChunkWriter(Writer writer) throws CityGMLWriteException {
        return this.initialize(new CityGMLChunkWriter(this.factory.createWriter(writer), this.version, this.factory));
    }

    public CityGMLChunkWriter createCityGMLChunkWriter(SAXWriter writer) throws CityGMLWriteException {
        return this.initialize(new CityGMLChunkWriter(this.factory.createWriter(writer), this.version, this.factory));
    }

    public CityGMLChunkWriter createCityGMLChunkWriter(ContentHandler writer) throws CityGMLWriteException {
        return this.initialize(new CityGMLChunkWriter(this.factory.createWriter(writer), this.version, this.factory));
    }

    private <T extends AbstractCityGMLWriter<?>> T initialize(T writer) throws CityGMLWriteException {
        try {
            writer.transformer = this.transformer != null ? new TransformerPipeline(this.transformer) : null;
            return writer;
        }
        catch (TransformerConfigurationException e) {
            throw new CityGMLWriteException("Caused by:", e);
        }
    }
}

