/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.reader;

import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerException;
import org.citygml4j.core.model.CityGMLObject;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.xml.reader.CityGMLChunk;
import org.citygml4j.xml.reader.CityGMLReadException;
import org.citygml4j.xml.reader.CityGMLReader;
import org.xml.sax.SAXException;
import org.xmlobjects.XMLObjects;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.builder.ObjectBuilder;
import org.xmlobjects.gml.visitor.Visitable;
import org.xmlobjects.stream.EventType;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLReaderFactory;

public class CityGMLSimpleReader
extends CityGMLReader {
    private final XMLReaderFactory factory;
    private boolean hasNext = false;

    public CityGMLSimpleReader(XMLReader reader, XMLReaderFactory factory) {
        super(reader);
        this.factory = factory;
    }

    @Override
    public boolean hasNext() throws CityGMLReadException {
        if (!this.hasNext) {
            try {
                XMLObjects xmlObjects = this.reader.getXMLObjects();
                while (this.reader.hasNext()) {
                    if (this.reader.nextTag() != EventType.START_ELEMENT) continue;
                    QName name = this.reader.getName();
                    if (this.filter == null || this.filter.accept(name)) {
                        ObjectBuilder builder = xmlObjects.getBuilder(name, AbstractFeature.class);
                        if (builder == null || !CityGMLObject.class.isAssignableFrom(xmlObjects.getObjectType(name.getNamespaceURI(), builder))) continue;
                        this.hasNext = true;
                        break;
                    }
                    int skipUntil = this.reader.getDepth() - 1;
                    while (this.reader.getDepth() != skipUntil) {
                        this.reader.nextTag();
                    }
                }
            }
            catch (XMLReadException e) {
                throw new CityGMLReadException("Caused by:", e);
            }
        }
        return this.hasNext;
    }

    @Override
    public AbstractFeature next() throws CityGMLReadException {
        if (this.hasNext()) {
            try {
                AbstractFeature feature;
                if (this.transformer == null) {
                    feature = (AbstractFeature)this.reader.getObject(AbstractFeature.class);
                    if (feature != null && this.resolver != null) {
                        this.resolver.resolveReferences(new Visitable[]{feature});
                    }
                } else {
                    feature = this.nextChunk().build(true);
                }
                AbstractFeature abstractFeature = feature;
                return abstractFeature;
            }
            catch (ObjectBuildException | XMLReadException e) {
                throw new CityGMLReadException("Caused by:", e);
            }
            finally {
                this.hasNext = false;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public CityGMLChunk nextChunk() throws CityGMLReadException {
        if (this.hasNext()) {
            try {
                XMLStreamReader reader = this.reader.getStreamReader();
                CityGMLChunk chunk = new CityGMLChunk(reader.getName(), this.factory, this.resolver);
                do {
                    chunk.bufferEvent(reader);
                } while (!chunk.isComplete() && reader.hasNext() && reader.next() >= 0);
                if (this.transformer != null) {
                    chunk.transform(this.transformer);
                }
                CityGMLChunk cityGMLChunk = chunk;
                return cityGMLChunk;
            }
            catch (XMLStreamException | TransformerException | SAXException e) {
                throw new CityGMLReadException("Caused by:", e);
            }
            finally {
                this.hasNext = false;
            }
        }
        throw new NoSuchElementException();
    }
}

