/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.reader;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Objects;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import org.citygml4j.xml.CityGMLContext;
import org.citygml4j.xml.reader.ChunkOptions;
import org.citygml4j.xml.reader.CityGMLChunkReader;
import org.citygml4j.xml.reader.CityGMLInputFilter;
import org.citygml4j.xml.reader.CityGMLReadException;
import org.citygml4j.xml.reader.CityGMLReader;
import org.citygml4j.xml.reader.CityGMLSimpleReader;
import org.citygml4j.xml.schema.CityGMLSchemaHandler;
import org.citygml4j.xml.transform.TransformerPipeline;
import org.xmlobjects.XMLObjects;
import org.xmlobjects.gml.util.id.DefaultIdCreator;
import org.xmlobjects.gml.util.id.IdCreator;
import org.xmlobjects.gml.util.reference.ReferenceResolver;
import org.xmlobjects.schema.SchemaHandler;
import org.xmlobjects.schema.SchemaHandlerException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLReaderFactory;
import org.xmlobjects.util.Properties;

public class CityGMLInputFactory {
    public static final String FAIL_ON_MISSING_ADE_SCHEMA = "org.citygml4j.failOnMissingADESchema";
    private final CityGMLContext context;
    private final XMLReaderFactory factory;
    private ChunkOptions chunkOptions;
    private TransformerPipeline transformer;
    private ReferenceResolver resolver;
    private IdCreator idCreator;

    public CityGMLInputFactory(CityGMLContext context, XMLInputFactory factory) throws CityGMLReadException {
        this.context = Objects.requireNonNull(context, "CityGML context must not be null.");
        try {
            this.factory = XMLReaderFactory.newInstance((XMLObjects)context.getXMLObjects(), (XMLInputFactory)factory);
        }
        catch (XMLReadException e) {
            throw new CityGMLReadException("Caused by:", e);
        }
    }

    public CityGMLSchemaHandler getSchemaHandler() {
        return (CityGMLSchemaHandler)this.factory.getSchemaHandler();
    }

    public CityGMLInputFactory withSchemaHandler(CityGMLSchemaHandler schemaHandler) {
        this.factory.withSchemaHandler((SchemaHandler)schemaHandler);
        return this;
    }

    public boolean isCreateGenericADEContent() {
        return this.factory.isCreateDOMAsFallback();
    }

    public CityGMLInputFactory createGenericADEContent(boolean createGenericADEContent) {
        this.factory.createDOMAsFallback(createGenericADEContent);
        return this;
    }

    public boolean isFailOnMissingADESchema() {
        return this.factory.getProperties().getAndCompare(FAIL_ON_MISSING_ADE_SCHEMA, (Object)true);
    }

    public CityGMLInputFactory failOnMissingADESchema(boolean failOnMissingADESchema) {
        this.factory.withProperty(FAIL_ON_MISSING_ADE_SCHEMA, (Object)failOnMissingADESchema);
        return this;
    }

    public ChunkOptions getChunkOptions() {
        return this.chunkOptions;
    }

    public CityGMLInputFactory withChunking(ChunkOptions chunkOptions) {
        this.chunkOptions = chunkOptions;
        return this;
    }

    public CityGMLInputFactory withChunking() {
        return this.withChunking(ChunkOptions.defaults());
    }

    public TransformerPipeline getTransformer() {
        return this.transformer;
    }

    public CityGMLInputFactory withTransformer(TransformerPipeline transformer) {
        this.transformer = transformer;
        return this;
    }

    public ReferenceResolver getReferenceResolver() {
        return this.resolver;
    }

    public CityGMLInputFactory withReferenceResolver(ReferenceResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public IdCreator getIdCreator() {
        return this.idCreator;
    }

    public CityGMLInputFactory withIdCreator(IdCreator idCreator) {
        this.idCreator = idCreator;
        return this;
    }

    public XMLReporter getXMLReporter() {
        return this.factory.getXMLReporter();
    }

    public CityGMLInputFactory withXMLReporter(XMLReporter reporter) {
        this.factory.withXMLReporter(reporter);
        return this;
    }

    public XMLResolver getXMLResolver() {
        return this.factory.getXMLResolver();
    }

    public CityGMLInputFactory withXMLResolver(XMLResolver resolver) {
        this.factory.withXMLResolver(resolver);
        return this;
    }

    public Properties getProperties() {
        return this.factory.getProperties();
    }

    public CityGMLInputFactory withProperty(String name, Object value) {
        this.factory.withProperty(name, value);
        return this;
    }

    public CityGMLReader createCityGMLReader(File file) throws CityGMLReadException {
        try {
            return this.validate().createReader(this.factory.createReader(file));
        }
        catch (SchemaHandlerException | XMLReadException e) {
            throw new CityGMLReadException("Caused by:", e);
        }
    }

    public CityGMLReader createCityGMLReader(File file, String encoding) throws CityGMLReadException {
        try {
            return this.validate().createReader(this.factory.createReader(file, encoding));
        }
        catch (SchemaHandlerException | XMLReadException e) {
            throw new CityGMLReadException("Caused by:", e);
        }
    }

    public CityGMLReader createCityGMLReader(Path path) throws CityGMLReadException {
        try {
            return this.validate().createReader(this.factory.createReader(path));
        }
        catch (SchemaHandlerException | XMLReadException e) {
            throw new CityGMLReadException("Caused by:", e);
        }
    }

    public CityGMLReader createCityGMLReader(Path path, String encoding) throws CityGMLReadException {
        try {
            return this.validate().createReader(this.factory.createReader(path, encoding));
        }
        catch (SchemaHandlerException | XMLReadException e) {
            throw new CityGMLReadException("Caused by:", e);
        }
    }

    public CityGMLReader createCityGMLReader(InputStream stream) throws CityGMLReadException {
        try {
            return this.validate().createReader(this.factory.createReader(stream));
        }
        catch (SchemaHandlerException | XMLReadException e) {
            throw new CityGMLReadException("Caused by:", e);
        }
    }

    public CityGMLReader createCityGMLReader(InputStream stream, String encoding) throws CityGMLReadException {
        try {
            return this.validate().createReader(this.factory.createReader(stream, encoding));
        }
        catch (SchemaHandlerException | XMLReadException e) {
            throw new CityGMLReadException("Caused by:", e);
        }
    }

    public CityGMLReader createCityGMLReader(String systemId, InputStream stream) throws CityGMLReadException {
        try {
            return this.validate().createReader(this.factory.createReader(systemId, stream));
        }
        catch (SchemaHandlerException | XMLReadException e) {
            throw new CityGMLReadException("Caused by:", e);
        }
    }

    public CityGMLReader createCityGMLReader(String systemId, InputStream stream, String encoding) throws CityGMLReadException {
        try {
            return this.validate().createReader(this.factory.createReader(systemId, stream, encoding));
        }
        catch (SchemaHandlerException | XMLReadException e) {
            throw new CityGMLReadException("Caused by:", e);
        }
    }

    public CityGMLReader createCityGMLReader(Reader reader) throws CityGMLReadException {
        try {
            return this.validate().createReader(this.factory.createReader(reader));
        }
        catch (SchemaHandlerException | XMLReadException e) {
            throw new CityGMLReadException("Caused by:", e);
        }
    }

    public CityGMLReader createCityGMLReader(String systemId, Reader reader) throws CityGMLReadException {
        try {
            return this.validate().createReader(this.factory.createReader(systemId, reader));
        }
        catch (SchemaHandlerException | XMLReadException e) {
            throw new CityGMLReadException("Caused by:", e);
        }
    }

    public CityGMLReader createCityGMLReader(Source source) throws CityGMLReadException {
        try {
            return this.validate().createReader(this.factory.createReader(source));
        }
        catch (SchemaHandlerException | XMLReadException e) {
            throw new CityGMLReadException("Caused by:", e);
        }
    }

    public CityGMLReader createCityGMLReader(XMLStreamReader reader) throws CityGMLReadException {
        try {
            return this.validate().createReader(this.factory.createReader(reader));
        }
        catch (SchemaHandlerException e) {
            throw new CityGMLReadException("Caused by:", e);
        }
    }

    public CityGMLReader createFilteredCityGMLReader(CityGMLReader reader, CityGMLInputFilter filter) {
        reader.filter = filter;
        return reader;
    }

    private CityGMLReader createReader(XMLReader xmlReader) throws CityGMLReadException {
        try {
            CityGMLReader reader = this.chunkOptions == null ? new CityGMLSimpleReader(xmlReader, this.factory) : new CityGMLChunkReader(xmlReader, this.chunkOptions, this.idCreator, this.factory, this.context);
            reader.transformer = this.transformer != null ? new TransformerPipeline(this.transformer) : null;
            reader.resolver = this.resolver;
            return reader;
        }
        catch (TransformerConfigurationException e) {
            throw new CityGMLReadException("Caused by:", e);
        }
    }

    private CityGMLInputFactory validate() throws SchemaHandlerException {
        if (this.isCreateGenericADEContent() && this.getSchemaHandler() == null) {
            this.factory.withSchemaHandler((SchemaHandler)this.context.getDefaultSchemaHandler());
        }
        if (this.chunkOptions != null && this.idCreator == null) {
            this.idCreator = DefaultIdCreator.getInstance();
        }
        return this;
    }
}

