/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.module.citygml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.citygml4j.core.ade.ADERegistry;
import org.citygml4j.core.model.CityGMLVersion;
import org.citygml4j.xml.CityGMLADELoader;
import org.citygml4j.xml.module.Module;
import org.citygml4j.xml.module.citygml.AppearanceModule;
import org.citygml4j.xml.module.citygml.BridgeModule;
import org.citygml4j.xml.module.citygml.BuildingModule;
import org.citygml4j.xml.module.citygml.CityFurnitureModule;
import org.citygml4j.xml.module.citygml.CityObjectGroupModule;
import org.citygml4j.xml.module.citygml.ConstructionModule;
import org.citygml4j.xml.module.citygml.CoreModule;
import org.citygml4j.xml.module.citygml.DynamizerModule;
import org.citygml4j.xml.module.citygml.GenericsModule;
import org.citygml4j.xml.module.citygml.LandUseModule;
import org.citygml4j.xml.module.citygml.PointCloudModule;
import org.citygml4j.xml.module.citygml.ReliefModule;
import org.citygml4j.xml.module.citygml.TransportationModule;
import org.citygml4j.xml.module.citygml.TunnelModule;
import org.citygml4j.xml.module.citygml.VegetationModule;
import org.citygml4j.xml.module.citygml.VersioningModule;
import org.citygml4j.xml.module.citygml.WaterBodyModule;
import org.citygml4j.xml.module.gml.GMLCoreModule;
import org.citygml4j.xml.module.gml.XLinkModule;
import org.citygml4j.xml.module.xal.XALCommonTypesModule;
import org.citygml4j.xml.module.xal.XALCoreModule;

public class CityGMLModules {
    public static final CityGMLModules v3_0 = new CityGMLModules(CityGMLVersion.v3_0, AppearanceModule.v3_0, BridgeModule.v3_0, BuildingModule.v3_0, CityFurnitureModule.v3_0, CityObjectGroupModule.v3_0, ConstructionModule.v3_0, CoreModule.v3_0, DynamizerModule.v3_0, GenericsModule.v3_0, LandUseModule.v3_0, PointCloudModule.v3_0, ReliefModule.v3_0, TransportationModule.v3_0, TunnelModule.v3_0, VegetationModule.v3_0, VersioningModule.v3_0, WaterBodyModule.v3_0, GMLCoreModule.v3_2, XLinkModule.v1_0, XALCoreModule.v3_0, XALCommonTypesModule.v3_0);
    public static final CityGMLModules v2_0 = new CityGMLModules(CityGMLVersion.v2_0, AppearanceModule.v2_0, BridgeModule.v2_0, BuildingModule.v2_0, CityFurnitureModule.v2_0, CityObjectGroupModule.v2_0, CoreModule.v2_0, GenericsModule.v2_0, LandUseModule.v2_0, ReliefModule.v2_0, TransportationModule.v2_0, TunnelModule.v2_0, VegetationModule.v2_0, WaterBodyModule.v2_0, GMLCoreModule.v3_1, XLinkModule.v1_0, XALCoreModule.v2_0);
    public static final CityGMLModules v1_0 = new CityGMLModules(CityGMLVersion.v1_0, AppearanceModule.v1_0, BuildingModule.v1_0, CityFurnitureModule.v1_0, CityObjectGroupModule.v1_0, CoreModule.v1_0, GenericsModule.v1_0, LandUseModule.v1_0, ReliefModule.v1_0, TransportationModule.v1_0, VegetationModule.v1_0, WaterBodyModule.v1_0, GMLCoreModule.v3_1, XLinkModule.v1_0, XALCoreModule.v2_0);
    private final Map<String, Module> modules = new HashMap<String, Module>();
    private final CityGMLVersion version;

    private CityGMLModules(CityGMLVersion version, Module ... modules) {
        this.version = version;
        for (Module module : modules) {
            this.modules.put(module.getNamespaceURI(), module);
        }
    }

    public static List<CityGMLModules> all() {
        return List.of(v3_0, v2_0, v1_0);
    }

    public static CityGMLModules of(CityGMLVersion version) {
        switch (version) {
            case v2_0: {
                return v2_0;
            }
            case v1_0: {
                return v1_0;
            }
        }
        return v3_0;
    }

    public static CityGMLModules of(String namespaceURI) {
        for (CityGMLModules context : CityGMLModules.all()) {
            Module module = context.getModule(namespaceURI);
            if (module == null) continue;
            return context;
        }
        return null;
    }

    public static CityGMLVersion getCityGMLVersion(String namespaceURI) {
        CityGMLModules context = CityGMLModules.of(namespaceURI);
        return context != null ? context.getCityGMLVersion() : null;
    }

    public static Module getModuleFor(String namespaceURI) {
        for (CityGMLModules context : Arrays.asList(v3_0, v2_0, v1_0)) {
            Module module = context.getModule(namespaceURI);
            if (module == null) continue;
            return module;
        }
        return null;
    }

    public static <T extends Module> T getModuleFor(String namespaceURI, Class<T> type) {
        Module module = CityGMLModules.getModuleFor(namespaceURI);
        return (T)(type.isInstance(module) ? (Module)type.cast(module) : null);
    }

    public static boolean isCityGMLNamespace(String namespaceURI) {
        return namespaceURI != null && namespaceURI.startsWith("http://www.opengis.net/citygml");
    }

    public static boolean isCityGMLNamespace(String namespaceURI, CityGMLVersion version) {
        return CityGMLModules.isCityGMLNamespace(namespaceURI) && CityGMLModules.of((CityGMLVersion)version).modules.containsKey(namespaceURI);
    }

    public static boolean isGMLNamespace(String namespaceURI) {
        return namespaceURI != null && namespaceURI.startsWith("http://www.opengis.net/gml");
    }

    public static boolean isXALNamespace(String namespaceURI) {
        return namespaceURI != null && namespaceURI.startsWith("urn:oasis:names:tc:ciq");
    }

    public List<Module> getModules() {
        ArrayList<Module> modules = new ArrayList<Module>(this.modules.values());
        modules.addAll(this.getCityGMLADELoader().getADEModules(this.version));
        return modules;
    }

    public Module getModule(String namespaceURI) {
        Module module = this.modules.get(namespaceURI);
        if (module == null) {
            module = this.getCityGMLADELoader().getADEModule(namespaceURI, this.version);
        }
        return module;
    }

    public <T extends Module> T getModule(Class<T> type) {
        for (Module module : this.getModules()) {
            if (!type.isInstance(module)) continue;
            return (T)((Module)type.cast(module));
        }
        return null;
    }

    public Set<String> getNamespaces() {
        return this.getModules().stream().map(Module::getNamespaceURI).collect(Collectors.toSet());
    }

    public CityGMLVersion getCityGMLVersion() {
        return this.version;
    }

    private CityGMLADELoader getCityGMLADELoader() {
        return (CityGMLADELoader)ADERegistry.getInstance().getADELoader(CityGMLADELoader.class);
    }
}

