/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.adapter.vegetation;

import javax.xml.namespace.QName;
import org.citygml4j.core.model.ade.ADEProperty;
import org.citygml4j.core.model.ade.generic.GenericADEOfPlantCover;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.AbstractSpace;
import org.citygml4j.core.model.core.StandardObjectClassifier;
import org.citygml4j.core.model.deprecated.vegetation.DeprecatedPropertiesOfPlantCover;
import org.citygml4j.core.model.vegetation.ADEOfPlantCover;
import org.citygml4j.core.model.vegetation.PlantCover;
import org.citygml4j.xml.adapter.CityGMLBuilderHelper;
import org.citygml4j.xml.adapter.CityGMLSerializerHelper;
import org.citygml4j.xml.adapter.ade.ADEBuilderHelper;
import org.citygml4j.xml.adapter.ade.ADESerializerHelper;
import org.citygml4j.xml.adapter.vegetation.AbstractVegetationObjectAdapter;
import org.xmlobjects.annotation.XMLElement;
import org.xmlobjects.annotation.XMLElements;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.gml.adapter.geometry.aggregates.MultiSolidPropertyAdapter;
import org.xmlobjects.gml.adapter.geometry.aggregates.MultiSurfacePropertyAdapter;
import org.xmlobjects.gml.adapter.measures.LengthAdapter;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSolid;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSolidProperty;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurfaceProperty;
import org.xmlobjects.gml.model.geometry.primitives.SolidProperty;
import org.xmlobjects.gml.model.measures.Length;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;

@XMLElements(value={@XMLElement(name="PlantCover", namespaceURI="http://www.opengis.net/citygml/vegetation/3.0"), @XMLElement(name="PlantCover", namespaceURI="http://www.opengis.net/citygml/vegetation/2.0"), @XMLElement(name="PlantCover", namespaceURI="http://www.opengis.net/citygml/vegetation/1.0")})
public class PlantCoverAdapter
extends AbstractVegetationObjectAdapter<PlantCover> {
    private final QName[] substitutionGroups = new QName[]{new QName("http://www.opengis.net/citygml/vegetation/2.0", "_GenericApplicationPropertyOfPlantCover"), new QName("http://www.opengis.net/citygml/vegetation/1.0", "_GenericApplicationPropertyOfPlantCover")};

    public PlantCover createObject(QName name, Object parent) throws ObjectBuildException {
        return new PlantCover();
    }

    @Override
    public void buildChildObject(PlantCover object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (CityGMLBuilderHelper.isVegetationNamespace(name.getNamespaceURI())) {
            if (CityGMLBuilderHelper.buildStandardObjectClassifier((StandardObjectClassifier)object, name.getLocalPart(), reader)) {
                return;
            }
            switch (name.getLocalPart()) {
                case "averageHeight": {
                    object.setAverageHeight((Length)reader.getObjectUsingBuilder(LengthAdapter.class));
                    return;
                }
                case "minHeight": {
                    object.setMinHeight((Length)reader.getObjectUsingBuilder(LengthAdapter.class));
                    return;
                }
                case "maxHeight": {
                    object.setMaxHeight((Length)reader.getObjectUsingBuilder(LengthAdapter.class));
                    return;
                }
                case "lod1MultiSurface": {
                    object.getDeprecatedProperties().setLod1MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod2MultiSurface": {
                    object.setLod2MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod3MultiSurface": {
                    object.setLod3MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod4MultiSurface": {
                    object.getDeprecatedProperties().setLod4MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod1MultiSolid": {
                    MultiSolidProperty lod1MultiSolid = (MultiSolidProperty)reader.getObjectUsingBuilder(MultiSolidPropertyAdapter.class);
                    if (!CityGMLBuilderHelper.assignDefaultGeometry((AbstractSpace)object, 1, lod1MultiSolid)) {
                        object.getDeprecatedProperties().setLod1MultiSolid(lod1MultiSolid);
                    }
                    return;
                }
                case "lod2MultiSolid": {
                    MultiSolidProperty lod2MultiSolid = (MultiSolidProperty)reader.getObjectUsingBuilder(MultiSolidPropertyAdapter.class);
                    if (!CityGMLBuilderHelper.assignDefaultGeometry((AbstractSpace)object, 2, lod2MultiSolid)) {
                        object.getDeprecatedProperties().setLod2MultiSolid(lod2MultiSolid);
                    }
                    return;
                }
                case "lod3MultiSolid": {
                    MultiSolidProperty lod3MultiSolid = (MultiSolidProperty)reader.getObjectUsingBuilder(MultiSolidPropertyAdapter.class);
                    if (!CityGMLBuilderHelper.assignDefaultGeometry((AbstractSpace)object, 3, lod3MultiSolid)) {
                        object.getDeprecatedProperties().setLod3MultiSolid(lod3MultiSolid);
                    }
                    return;
                }
                case "lod4MultiSolid": {
                    object.getDeprecatedProperties().setLod4MultiSolid((MultiSolidProperty)reader.getObjectUsingBuilder(MultiSolidPropertyAdapter.class));
                    return;
                }
                case "adeOfPlantCover": {
                    ADEBuilderHelper.addADEProperty((AbstractFeature)object, GenericADEOfPlantCover::of, reader);
                    return;
                }
            }
        } else if (CityGMLBuilderHelper.isADENamespace(name.getNamespaceURI())) {
            this.buildADEProperty(object, name, reader);
            return;
        }
        super.buildChildObject(object, name, attributes, reader);
    }

    @Override
    public void buildADEProperty(PlantCover object, QName name, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (!ADEBuilderHelper.addADEProperty((AbstractFeature)object, name, GenericADEOfPlantCover::of, reader, this.substitutionGroups)) {
            super.buildADEProperty(object, name, reader);
        }
    }

    public Element createElement(PlantCover object, Namespaces namespaces) throws ObjectSerializeException {
        return Element.of((String)CityGMLSerializerHelper.getVegetationNamespace(namespaces), (String)"PlantCover");
    }

    @Override
    public void writeChildElements(PlantCover object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        super.writeChildElements(object, namespaces, writer);
        String vegetationNamespace = CityGMLSerializerHelper.getVegetationNamespace(namespaces);
        boolean isCityGML3 = "http://www.opengis.net/citygml/vegetation/3.0".equals(vegetationNamespace);
        CityGMLSerializerHelper.writeStandardObjectClassifier((StandardObjectClassifier)object, vegetationNamespace, namespaces, writer);
        if (object.getAverageHeight() != null) {
            writer.writeElementUsingSerializer(Element.of((String)vegetationNamespace, (String)"averageHeight"), (Object)object.getAverageHeight(), LengthAdapter.class, namespaces);
        }
        if (isCityGML3) {
            if (object.getMinHeight() != null) {
                writer.writeElementUsingSerializer(Element.of((String)vegetationNamespace, (String)"minHeight"), (Object)object.getMinHeight(), LengthAdapter.class, namespaces);
            }
            if (object.getMaxHeight() != null) {
                writer.writeElementUsingSerializer(Element.of((String)vegetationNamespace, (String)"maxHeight"), (Object)object.getMaxHeight(), LengthAdapter.class, namespaces);
            }
        }
        if (!isCityGML3) {
            DeprecatedPropertiesOfPlantCover properties;
            DeprecatedPropertiesOfPlantCover deprecatedPropertiesOfPlantCover = properties = object.hasDeprecatedProperties() ? object.getDeprecatedProperties() : null;
            if (properties != null && properties.getLod1MultiSurface() != null) {
                writer.writeElementUsingSerializer(Element.of((String)vegetationNamespace, (String)"lod1MultiSurface"), (Object)properties.getLod1MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
            }
            if (object.getLod2MultiSurface() != null) {
                writer.writeElementUsingSerializer(Element.of((String)vegetationNamespace, (String)"lod2MultiSurface"), (Object)object.getLod2MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
            }
            if (object.getLod3MultiSurface() != null) {
                writer.writeElementUsingSerializer(Element.of((String)vegetationNamespace, (String)"lod3MultiSurface"), (Object)object.getLod3MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
            }
            if (properties != null && properties.getLod4MultiSurface() != null) {
                writer.writeElementUsingSerializer(Element.of((String)vegetationNamespace, (String)"lod4MultiSurface"), (Object)properties.getLod4MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
            }
            if (properties != null && properties.getLod1MultiSolid() != null) {
                writer.writeElementUsingSerializer(Element.of((String)vegetationNamespace, (String)"lod1MultiSolid"), (Object)properties.getLod1MultiSolid(), MultiSolidPropertyAdapter.class, namespaces);
            } else if (object.getLod1Solid() != null) {
                writer.writeElementUsingSerializer(Element.of((String)vegetationNamespace, (String)"lod1MultiSolid"), (Object)this.getMultiSolidProperty(object.getLod1Solid()), MultiSolidPropertyAdapter.class, namespaces);
            }
            if (properties != null && properties.getLod2MultiSolid() != null) {
                writer.writeElementUsingSerializer(Element.of((String)vegetationNamespace, (String)"lod2MultiSolid"), (Object)properties.getLod2MultiSolid(), MultiSolidPropertyAdapter.class, namespaces);
            } else if (object.getLod2Solid() != null) {
                writer.writeElementUsingSerializer(Element.of((String)vegetationNamespace, (String)"lod2MultiSolid"), (Object)this.getMultiSolidProperty(object.getLod2Solid()), MultiSolidPropertyAdapter.class, namespaces);
            }
            if (properties != null && properties.getLod3MultiSolid() != null) {
                writer.writeElementUsingSerializer(Element.of((String)vegetationNamespace, (String)"lod3MultiSolid"), (Object)properties.getLod3MultiSolid(), MultiSolidPropertyAdapter.class, namespaces);
            } else if (object.getLod3Solid() != null) {
                writer.writeElementUsingSerializer(Element.of((String)vegetationNamespace, (String)"lod3MultiSolid"), (Object)this.getMultiSolidProperty(object.getLod3Solid()), MultiSolidPropertyAdapter.class, namespaces);
            }
            if (properties != null && properties.getLod4MultiSolid() != null) {
                writer.writeElementUsingSerializer(Element.of((String)vegetationNamespace, (String)"lod4MultiSolid"), (Object)properties.getLod4MultiSolid(), MultiSolidPropertyAdapter.class, namespaces);
            }
        }
        for (ADEOfPlantCover property : object.getADEProperties(ADEOfPlantCover.class)) {
            ADESerializerHelper.writeADEProperty(isCityGML3 ? Element.of((String)vegetationNamespace, (String)"adeOfPlantCover") : null, (ADEProperty)property, namespaces, writer);
        }
    }

    private MultiSolidProperty getMultiSolidProperty(SolidProperty src) {
        MultiSolid multiSolid = new MultiSolid();
        multiSolid.getSolidMember().add(src);
        return new MultiSolidProperty(multiSolid);
    }
}

