/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.adapter.deprecated.bridge;

import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import javax.xml.namespace.QName;
import org.citygml4j.core.model.ade.ADEProperty;
import org.citygml4j.core.model.ade.generic.GenericADEOfAbstractBridge;
import org.citygml4j.core.model.bridge.ADEOfAbstractBridge;
import org.citygml4j.core.model.bridge.AbstractBridge;
import org.citygml4j.core.model.bridge.Bridge;
import org.citygml4j.core.model.bridge.BridgeConstructiveElementProperty;
import org.citygml4j.core.model.bridge.BridgeInstallation;
import org.citygml4j.core.model.bridge.BridgeInstallationProperty;
import org.citygml4j.core.model.bridge.BridgePartProperty;
import org.citygml4j.core.model.bridge.BridgeRoomProperty;
import org.citygml4j.core.model.construction.RelationToConstruction;
import org.citygml4j.core.model.core.AbstractSpaceBoundaryProperty;
import org.citygml4j.core.model.core.AddressProperty;
import org.citygml4j.core.model.deprecated.bridge.DeprecatedPropertiesOfAbstractBridge;
import org.citygml4j.xml.adapter.CityGMLBuilderHelper;
import org.citygml4j.xml.adapter.CityGMLSerializerHelper;
import org.citygml4j.xml.adapter.ade.ADEBuilderHelper;
import org.citygml4j.xml.adapter.ade.ADESerializerHelper;
import org.citygml4j.xml.adapter.bridge.BridgeConstructiveElementPropertyAdapter;
import org.citygml4j.xml.adapter.bridge.BridgeInstallationPropertyAdapter;
import org.citygml4j.xml.adapter.bridge.BridgePartPropertyAdapter;
import org.citygml4j.xml.adapter.bridge.BridgeRoomPropertyAdapter;
import org.citygml4j.xml.adapter.core.AbstractSpaceBoundaryPropertyAdapter;
import org.citygml4j.xml.adapter.core.AddressPropertyAdapter;
import org.citygml4j.xml.adapter.deprecated.bridge.AbstractBoundarySurfacePropertyAdapter;
import org.citygml4j.xml.adapter.deprecated.core.AbstractSiteAdapter;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.gml.adapter.geometry.aggregates.MultiCurvePropertyAdapter;
import org.xmlobjects.gml.adapter.geometry.aggregates.MultiSurfacePropertyAdapter;
import org.xmlobjects.gml.adapter.geometry.primitives.SolidPropertyAdapter;
import org.xmlobjects.gml.model.geometry.aggregates.MultiCurveProperty;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurfaceProperty;
import org.xmlobjects.gml.model.geometry.primitives.SolidProperty;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;
import org.xmlobjects.xml.TextContent;

public abstract class AbstractBridgeAdapter<T extends AbstractBridge>
extends AbstractSiteAdapter<T> {
    private final QName substitutionGroup = new QName("http://www.opengis.net/citygml/bridge/2.0", "_GenericApplicationPropertyOfAbstractBridge");

    @Override
    public void buildChildObject(T object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (CityGMLBuilderHelper.isBridgeNamespace(name.getNamespaceURI())) {
            if (CityGMLBuilderHelper.buildStandardObjectClassifier(object, name.getLocalPart(), reader)) {
                return;
            }
            switch (name.getLocalPart()) {
                case "yearOfConstruction": {
                    reader.getTextContent().ifGYear(v -> object.setDateOfConstruction(v.toLocalDate()));
                    return;
                }
                case "yearOfDemolition": {
                    reader.getTextContent().ifGYear(v -> object.setDateOfDemolition(v.toLocalDate()));
                    return;
                }
                case "isMovable": {
                    reader.getTextContent().ifBoolean(arg_0 -> object.setIsMovable(arg_0));
                    return;
                }
                case "lod1Solid": {
                    object.setLod1Solid((SolidProperty)reader.getObjectUsingBuilder(SolidPropertyAdapter.class));
                    return;
                }
                case "lod1MultiSurface": {
                    object.getDeprecatedProperties().setLod1MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod1TerrainIntersection": {
                    object.setLod1TerrainIntersectionCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "lod2Solid": {
                    object.setLod2Solid((SolidProperty)reader.getObjectUsingBuilder(SolidPropertyAdapter.class));
                    return;
                }
                case "lod2MultiSurface": {
                    object.setLod2MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod2MultiCurve": {
                    object.setLod2MultiCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "lod2TerrainIntersection": {
                    object.setLod2TerrainIntersectionCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "outerBridgeConstruction": {
                    object.getBridgeConstructiveElements().add((BridgeConstructiveElementProperty)reader.getObjectUsingBuilder(BridgeConstructiveElementPropertyAdapter.class));
                    return;
                }
                case "outerBridgeInstallation": 
                case "interiorBridgeInstallation": {
                    object.getBridgeInstallations().add((BridgeInstallationProperty)reader.getObjectUsingBuilder(BridgeInstallationPropertyAdapter.class));
                    return;
                }
                case "boundedBy": {
                    object.addBoundary((AbstractSpaceBoundaryProperty)reader.getObjectUsingBuilder(AbstractSpaceBoundaryPropertyAdapter.class));
                    return;
                }
                case "lod3Solid": {
                    object.setLod3Solid((SolidProperty)reader.getObjectUsingBuilder(SolidPropertyAdapter.class));
                    return;
                }
                case "lod3MultiSurface": {
                    object.setLod3MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod3MultiCurve": {
                    object.setLod3MultiCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "lod3TerrainIntersection": {
                    object.setLod3TerrainIntersectionCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "lod4Solid": {
                    object.getDeprecatedProperties().setLod4Solid((SolidProperty)reader.getObjectUsingBuilder(SolidPropertyAdapter.class));
                    return;
                }
                case "lod4MultiSurface": {
                    object.getDeprecatedProperties().setLod4MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod4MultiCurve": {
                    object.getDeprecatedProperties().setLod4MultiCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "lod4TerrainIntersection": {
                    object.getDeprecatedProperties().setLod4TerrainIntersectionCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "interiorBridgeRoom": {
                    object.getBridgeRooms().add((BridgeRoomProperty)reader.getObjectUsingBuilder(BridgeRoomPropertyAdapter.class));
                    return;
                }
                case "consistsOfBridgePart": {
                    BridgePartProperty consistsOfBridgePart = (BridgePartProperty)reader.getObjectUsingBuilder(BridgePartPropertyAdapter.class);
                    if ((consistsOfBridgePart.getObject() != null || consistsOfBridgePart.getGenericElement() != null) && object instanceof Bridge) {
                        ((Bridge)object).getBridgeParts().add(consistsOfBridgePart);
                    } else {
                        object.getDeprecatedProperties().getConsistsOfBridgeParts().add(consistsOfBridgePart);
                    }
                    return;
                }
                case "address": {
                    object.getAddresses().add((AddressProperty)reader.getObjectUsingBuilder(AddressPropertyAdapter.class));
                    return;
                }
            }
        } else if (CityGMLBuilderHelper.isADENamespace(name.getNamespaceURI())) {
            this.buildADEProperty(object, name, reader);
            return;
        }
        super.buildChildObject(object, name, attributes, reader);
    }

    @Override
    public void buildADEProperty(T object, QName name, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (!ADEBuilderHelper.addADEProperty(object, name, GenericADEOfAbstractBridge::of, reader, new QName[]{this.substitutionGroup})) {
            super.buildADEProperty(object, name, reader);
        }
    }

    @Override
    public void writeChildElements(T object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        Bridge bridge;
        super.writeChildElements(object, namespaces, writer);
        String bridgeNamespace = CityGMLSerializerHelper.getBridgeNamespace(namespaces);
        DeprecatedPropertiesOfAbstractBridge properties = object.hasDeprecatedProperties() ? object.getDeprecatedProperties() : null;
        CityGMLSerializerHelper.writeStandardObjectClassifier(object, bridgeNamespace, namespaces, writer);
        if (object.getDateOfConstruction() != null) {
            writer.writeElement(Element.of((String)bridgeNamespace, (String)"yearOfConstruction").addTextContent(TextContent.ofGYear((OffsetDateTime)OffsetDateTime.of(object.getDateOfConstruction(), LocalTime.MIN, ZoneOffset.UTC))));
        }
        if (object.getDateOfDemolition() != null) {
            writer.writeElement(Element.of((String)bridgeNamespace, (String)"yearOfDemolition").addTextContent(TextContent.ofGYear((OffsetDateTime)OffsetDateTime.of(object.getDateOfDemolition(), LocalTime.MIN, ZoneOffset.UTC))));
        }
        if (object.isSetIsMovable()) {
            writer.writeElement(Element.of((String)bridgeNamespace, (String)"isMovable").addTextContent(TextContent.ofBoolean((Boolean)object.getIsMovable())));
        }
        if (object.getLod1Solid() != null) {
            writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"lod1Solid"), (Object)object.getLod1Solid(), SolidPropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod1MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"lod1MultiSurface"), (Object)properties.getLod1MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (object.getLod1TerrainIntersectionCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"lod1TerrainIntersection"), (Object)object.getLod1TerrainIntersectionCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (object.getLod2Solid() != null) {
            writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"lod2Solid"), (Object)object.getLod2Solid(), SolidPropertyAdapter.class, namespaces);
        }
        if (object.getLod2MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"lod2MultiSurface"), (Object)object.getLod2MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (object.getLod2MultiCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"lod2MultiCurve"), (Object)object.getLod2MultiCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (object.getLod2TerrainIntersectionCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"lod2TerrainIntersection"), (Object)object.getLod2TerrainIntersectionCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (object.isSetBridgeConstructiveElements()) {
            for (Object property : object.getBridgeConstructiveElements()) {
                writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"outerBridgeConstruction"), property, BridgeConstructiveElementPropertyAdapter.class, namespaces);
            }
        }
        if (object.isSetBridgeInstallations()) {
            for (Object property : object.getBridgeInstallations()) {
                if (property.getObject() != null && ((BridgeInstallation)property.getObject()).getRelationToConstruction() != RelationToConstruction.INSIDE) {
                    writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"outerBridgeInstallation"), property, BridgeInstallationPropertyAdapter.class, namespaces);
                    continue;
                }
                writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"interiorBridgeInstallation"), property, BridgeInstallationPropertyAdapter.class, namespaces);
            }
        }
        if (object.isSetBoundaries()) {
            for (Object property : object.getBoundaries()) {
                writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"boundedBy"), property, AbstractBoundarySurfacePropertyAdapter.class, namespaces);
            }
        }
        if (object.getLod3Solid() != null) {
            writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"lod3Solid"), (Object)object.getLod3Solid(), SolidPropertyAdapter.class, namespaces);
        }
        if (object.getLod3MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"lod3MultiSurface"), (Object)object.getLod3MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (object.getLod3MultiCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"lod3MultiCurve"), (Object)object.getLod3MultiCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (object.getLod3TerrainIntersectionCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"lod3TerrainIntersection"), (Object)object.getLod3TerrainIntersectionCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod4Solid() != null) {
            writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"lod4Solid"), (Object)properties.getLod4Solid(), SolidPropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod4MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"lod4MultiSurface"), (Object)properties.getLod4MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod4MultiCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"lod4MultiCurve"), (Object)properties.getLod4MultiCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod4TerrainIntersectionCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"lod4TerrainIntersection"), (Object)properties.getLod4TerrainIntersectionCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (object.isSetBridgeRooms()) {
            for (Object property : object.getBridgeRooms()) {
                writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"interiorBridgeRoom"), property, BridgeRoomPropertyAdapter.class, namespaces);
            }
        }
        if (object instanceof Bridge && (bridge = (Bridge)object).isSetBridgeParts()) {
            for (BridgePartProperty property : bridge.getBridgeParts()) {
                writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"consistsOfBridgePart"), (Object)property, BridgePartPropertyAdapter.class, namespaces);
            }
        }
        if (properties != null && properties.isSetConsistsOfBridgeParts()) {
            for (Object property : properties.getConsistsOfBridgeParts()) {
                writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"consistsOfBridgePart"), property, BridgePartPropertyAdapter.class, namespaces);
            }
        }
        if (object.isSetAddresses()) {
            for (Object property : object.getAddresses()) {
                writer.writeElementUsingSerializer(Element.of((String)bridgeNamespace, (String)"address"), property, AddressPropertyAdapter.class, namespaces);
            }
        }
        for (Object property : object.getADEProperties(ADEOfAbstractBridge.class)) {
            ADESerializerHelper.writeADEProperty((ADEProperty)property, namespaces, writer);
        }
    }
}

