/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.adapter.appearance;

import java.util.List;
import javax.xml.namespace.QName;
import org.citygml4j.core.model.ade.ADEProperty;
import org.citygml4j.core.model.ade.generic.GenericADEOfAbstractTexture;
import org.citygml4j.core.model.appearance.ADEOfAbstractTexture;
import org.citygml4j.core.model.appearance.AbstractTexture;
import org.citygml4j.core.model.appearance.ColorPlusOpacity;
import org.citygml4j.core.model.appearance.TextureType;
import org.citygml4j.core.model.appearance.WrapMode;
import org.citygml4j.xml.adapter.CityGMLBuilderHelper;
import org.citygml4j.xml.adapter.CityGMLSerializerHelper;
import org.citygml4j.xml.adapter.ade.ADEBuilderHelper;
import org.citygml4j.xml.adapter.ade.ADESerializerHelper;
import org.citygml4j.xml.adapter.appearance.AbstractSurfaceDataAdapter;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.gml.adapter.basictypes.CodeAdapter;
import org.xmlobjects.gml.model.basictypes.Code;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;
import org.xmlobjects.xml.TextContent;

public abstract class AbstractTextureAdapter<T extends AbstractTexture>
extends AbstractSurfaceDataAdapter<T> {
    private final QName[] substitutionGroups = new QName[]{new QName("http://www.opengis.net/citygml/appearance/2.0", "_GenericApplicationPropertyOfTexture"), new QName("http://www.opengis.net/citygml/appearance/1.0", "_GenericApplicationPropertyOfTexture")};

    @Override
    public void buildChildObject(T object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (CityGMLBuilderHelper.isAppearanceNamespace(name.getNamespaceURI())) {
            switch (name.getLocalPart()) {
                case "imageURI": {
                    reader.getTextContent().ifPresent(arg_0 -> object.setImageURI(arg_0));
                    return;
                }
                case "mimeType": {
                    object.setMimeType((Code)reader.getObjectUsingBuilder(CodeAdapter.class));
                    return;
                }
                case "textureType": {
                    reader.getTextContent().ifPresent(v -> object.setTextureType(TextureType.fromValue((String)v)));
                    return;
                }
                case "wrapMode": {
                    reader.getTextContent().ifPresent(v -> object.setWrapMode(WrapMode.fromValue((String)v)));
                    return;
                }
                case "borderColor": {
                    reader.getTextContent().ifDoubleList(v -> object.setBorderColor(ColorPlusOpacity.fromList((List)v)));
                    return;
                }
                case "adeOfAbstractTexture": {
                    ADEBuilderHelper.addADEProperty(object, GenericADEOfAbstractTexture::of, reader);
                    return;
                }
            }
        } else if (CityGMLBuilderHelper.isADENamespace(name.getNamespaceURI())) {
            this.buildADEProperty(object, name, reader);
            return;
        }
        super.buildChildObject(object, name, attributes, reader);
    }

    @Override
    public void buildADEProperty(T object, QName name, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (!ADEBuilderHelper.addADEProperty(object, name, GenericADEOfAbstractTexture::of, reader, this.substitutionGroups)) {
            super.buildADEProperty(object, name, reader);
        }
    }

    @Override
    public void writeChildElements(T object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        super.writeChildElements(object, namespaces, writer);
        String appearanceNamespace = CityGMLSerializerHelper.getAppearanceNamespace(namespaces);
        boolean isCityGML3 = "http://www.opengis.net/citygml/appearance/3.0".equalsIgnoreCase(appearanceNamespace);
        if (object.getImageURI() != null) {
            writer.writeElement(Element.of((String)appearanceNamespace, (String)"imageURI").addTextContent(object.getImageURI()));
        }
        if (object.getMimeType() != null) {
            writer.writeElementUsingSerializer(Element.of((String)appearanceNamespace, (String)"mimeType"), (Object)object.getMimeType(), CodeAdapter.class, namespaces);
        }
        if (object.getTextureType() != null) {
            writer.writeElement(Element.of((String)appearanceNamespace, (String)"textureType").addTextContent(object.getTextureType().toValue()));
        }
        if (object.getWrapMode() != null) {
            writer.writeElement(Element.of((String)appearanceNamespace, (String)"wrapMode").addTextContent(object.getWrapMode().toValue()));
        }
        if (object.getBorderColor() != null) {
            writer.writeElement(Element.of((String)appearanceNamespace, (String)"borderColor").addTextContent(TextContent.ofDoubleList((List)object.getBorderColor().toList())));
        }
        for (ADEOfAbstractTexture property : object.getADEProperties(ADEOfAbstractTexture.class)) {
            ADESerializerHelper.writeADEProperty(isCityGML3 ? Element.of((String)appearanceNamespace, (String)"adeOfAbstractTexture") : null, (ADEProperty)property, namespaces, writer);
        }
    }
}

