/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.adapter.ade;

import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSSchemaSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.citygml4j.core.model.ade.ADEProperty;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.xml.reader.MissingADESchemaException;
import org.w3c.dom.Element;
import org.xmlobjects.annotation.XMLElements;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.builder.ObjectBuilder;
import org.xmlobjects.schema.SchemaHandler;
import org.xmlobjects.schema.SchemaHandlerException;
import org.xmlobjects.stream.EventType;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;

public class ADEBuilderHelper {
    public static void addADEProperty(AbstractFeature feature, Function<Element, ADEProperty> creator, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (reader.hasNext() && reader.nextTag() == EventType.START_ELEMENT) {
            QName name = reader.getName();
            ObjectBuilder builder = reader.getXMLObjects().getBuilder(name, ADEProperty.class);
            if (builder != null) {
                ADEBuilderHelper.buildADEProperty(feature, name, (ObjectBuilder<ADEProperty>)builder, reader);
            } else if (reader.isCreateDOMAsFallback()) {
                feature.addADEProperty(creator.apply(reader.getDOMElement()));
            }
        }
    }

    public static boolean addADEProperty(AbstractFeature feature, QName name, Function<Element, ADEProperty> creator, XMLReader reader, QName ... substitutionGroups) throws ObjectBuildException, XMLReadException {
        ObjectBuilder builder = reader.getXMLObjects().getBuilder(name, ADEProperty.class);
        if (builder != null) {
            ADEBuilderHelper.buildADEProperty(feature, name, (ObjectBuilder<ADEProperty>)builder, reader);
            return true;
        }
        if (reader.isCreateDOMAsFallback() && ADEBuilderHelper.substitutes(name, reader, substitutionGroups)) {
            feature.addADEProperty(creator.apply(reader.getDOMElement()));
            return true;
        }
        return false;
    }

    private static void buildADEProperty(AbstractFeature feature, QName name, ObjectBuilder<ADEProperty> builder, XMLReader reader) throws ObjectBuildException, XMLReadException {
        Map singletons = (Map)reader.getProperties().getOrSet("org.citygml4j.singletonADEs", Map.class, HashMap::new);
        Boolean isSingleton = (Boolean)singletons.get(builder.getClass().getName());
        if (isSingleton == null) {
            XMLElements elements = builder.getClass().getAnnotation(XMLElements.class);
            isSingleton = elements != null && elements.value().length > 0;
            singletons.put(builder.getClass().getName(), isSingleton);
        }
        if (isSingleton.booleanValue()) {
            Class objectType = reader.getXMLObjects().getObjectType(name.getNamespaceURI(), builder);
            for (ADEProperty property : feature.getADEProperties(objectType)) {
                if (property.getClass() != objectType) continue;
                reader.fillObjectUsingBuilder((Object)property, builder);
                return;
            }
        }
        feature.addADEProperty((ADEProperty)reader.getObjectUsingBuilder(builder));
    }

    private static boolean substitutes(QName name, XMLReader reader, QName ... substitutionGroups) throws XMLReadException {
        block7: {
            if (reader.getSchemaHandler() != null) {
                try {
                    SchemaHandler schemaHandler = reader.getSchemaHandler();
                    schemaHandler.resolveAndParseSchema(name.getNamespaceURI());
                    XSSchemaSet schemas = schemaHandler.getSchemaSet(name.getNamespaceURI());
                    XSElementDecl element = schemas.getElementDecl(name.getNamespaceURI(), name.getLocalPart());
                    if (element != null) {
                        XSElementDecl head = null;
                        while ((element = element.getSubstAffiliation()) != null) {
                            head = element;
                        }
                        if (head != null) {
                            for (QName substitutionGroup : substitutionGroups) {
                                if (!substitutionGroup.getNamespaceURI().equals(head.getTargetNamespace()) || !substitutionGroup.getLocalPart().equals(head.getName())) continue;
                                return true;
                            }
                        }
                    }
                }
                catch (SchemaHandlerException e) {
                    if (!reader.getProperties().getAndCompare("org.citygml4j.failOnMissingADESchema", (Object)true)) break block7;
                    throw new MissingADESchemaException("Failed to load ADE schema document for target namespace '" + name.getNamespaceURI() + "'.", e);
                }
            }
        }
        return false;
    }
}

